/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import java.nio.ByteBuffer;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.schema.AvroSchema;
import org.apache.pulsar.client.impl.schema.JSONSchema;
import org.apache.pulsar.client.impl.schema.ProtobufSchema;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.KeyValueEncodingType;
import org.apache.pulsar.common.schema.SchemaType;
import org.springframework.core.ResolvableType;
import org.springframework.core.log.LogAccessor;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.annotation.PulsarMessage;
import org.springframework.pulsar.core.PulsarMessageAnnotationRegistry;
import org.springframework.pulsar.core.Resolved;
import org.springframework.pulsar.core.SchemaResolver;
import org.springframework.util.Assert;

public class DefaultSchemaResolver
implements SchemaResolver {
    private final LogAccessor logger = new LogAccessor(this.getClass());
    private static final Map<Class<?>, Schema<?>> BASE_SCHEMA_MAPPINGS = new HashMap();
    private final Map<Class<?>, Schema<?>> customSchemaMappings = new LinkedHashMap();
    private final PulsarMessageAnnotationRegistry pulsarMessageAnnotationRegistry = new PulsarMessageAnnotationRegistry();
    private boolean usePulsarMessageAnnotations = true;

    public void usePulsarMessageAnnotations(boolean usePulsarMessageAnnotations) {
        this.usePulsarMessageAnnotations = usePulsarMessageAnnotations;
    }

    @Nullable
    public Schema<?> addCustomSchemaMapping(Class<?> messageType, Schema<?> schema) {
        return this.customSchemaMappings.put(messageType, schema);
    }

    @Nullable
    public Schema<?> removeCustomMapping(Class<?> messageType) {
        return this.customSchemaMappings.remove(messageType);
    }

    public Map<Class<?>, Schema<?>> getCustomSchemaMappings() {
        return Collections.unmodifiableMap(this.customSchemaMappings);
    }

    @Override
    public <T> Resolved<Schema<T>> resolveSchema(@Nullable Class<?> messageClass, boolean returnDefault) {
        if (messageClass == null) {
            return Resolved.failed("Schema must be specified when the message is null");
        }
        Schema<?> schema = BASE_SCHEMA_MAPPINGS.get(messageClass);
        if (schema == null) {
            schema = this.getCustomSchemaOrMaybeDefault(messageClass, returnDefault);
        }
        if (schema == null) {
            return Resolved.failed("Schema not specified and no schema found for " + String.valueOf(messageClass));
        }
        return Resolved.of(this.castToType(schema));
    }

    @Nullable
    protected Schema<?> getCustomSchemaOrMaybeDefault(@Nullable Class<?> messageClass, boolean returnDefault) {
        Schema<?> schema = this.customSchemaMappings.get(messageClass);
        if (this.usePulsarMessageAnnotations && schema == null && messageClass != null && (schema = this.getAnnotatedSchemaType(messageClass)) != null) {
            this.addCustomSchemaMapping(messageClass, schema);
        }
        if (schema == null && returnDefault) {
            if (messageClass != null) {
                try {
                    return Schema.JSON(messageClass);
                }
                catch (Exception e) {
                    this.logger.debug((Throwable)e, (CharSequence)("Failed to create JSON schema for " + messageClass.getName()));
                }
            }
            return Schema.BYTES;
        }
        return schema;
    }

    Schema<?> getAnnotatedSchemaType(Class<?> messageClass) {
        PulsarMessage annotation = this.pulsarMessageAnnotationRegistry.getAnnotationFor(messageClass).orElse(null);
        if (annotation == null || annotation.schemaType() == SchemaType.NONE) {
            return null;
        }
        SchemaType schemaType = annotation.schemaType();
        if (schemaType != SchemaType.KEY_VALUE) {
            return this.resolveSchema(annotation.schemaType(), messageClass, null).value().orElse(null);
        }
        Class<?> messageKeyClass = annotation.messageKeyType();
        Assert.state((messageKeyClass != Void.class ? 1 : 0) != 0, (String)"messageKeyClass can not be Void.class when using KEY_VALUE schema type");
        SchemaType messageValueSchemaType = annotation.messageValueSchemaType();
        Assert.state((messageValueSchemaType != SchemaType.NONE && messageValueSchemaType != SchemaType.KEY_VALUE ? 1 : 0) != 0, () -> "messageValueSchemaType can not be NONE or KEY_VALUE when using KEY_VALUE schema type");
        Schema keySchema = this.resolveSchema(messageKeyClass).orElseThrow();
        Schema valueSchema = this.resolveSchema(messageValueSchemaType, messageClass, null).orElseThrow();
        return Schema.KeyValue(keySchema, valueSchema, (KeyValueEncodingType)KeyValueEncodingType.INLINE);
    }

    @Override
    public <T> Resolved<Schema<T>> resolveSchema(SchemaType schemaType, @Nullable ResolvableType messageType) {
        try {
            Schema<?> schema = switch (schemaType) {
                case SchemaType.STRING -> Schema.STRING;
                case SchemaType.BOOLEAN -> Schema.BOOL;
                case SchemaType.INT8 -> Schema.INT8;
                case SchemaType.INT16 -> Schema.INT16;
                case SchemaType.INT32 -> Schema.INT32;
                case SchemaType.INT64 -> Schema.INT64;
                case SchemaType.FLOAT -> Schema.FLOAT;
                case SchemaType.DOUBLE -> Schema.DOUBLE;
                case SchemaType.DATE -> Schema.DATE;
                case SchemaType.TIME -> Schema.TIME;
                case SchemaType.TIMESTAMP -> Schema.TIMESTAMP;
                case SchemaType.BYTES -> Schema.BYTES;
                case SchemaType.INSTANT -> Schema.INSTANT;
                case SchemaType.LOCAL_DATE -> Schema.LOCAL_DATE;
                case SchemaType.LOCAL_TIME -> Schema.LOCAL_TIME;
                case SchemaType.LOCAL_DATE_TIME -> Schema.LOCAL_DATE_TIME;
                case SchemaType.JSON -> JSONSchema.of(this.requireNonNullMessageType(schemaType, messageType));
                case SchemaType.AVRO -> AvroSchema.of(this.requireNonNullMessageType(schemaType, messageType));
                case SchemaType.PROTOBUF -> {
                    Class<?> messageClass = this.requireNonNullMessageType(schemaType, messageType);
                    yield ProtobufSchema.of(messageClass);
                }
                case SchemaType.KEY_VALUE -> {
                    this.requireNonNullMessageType(schemaType, messageType);
                    yield this.getMessageKeyValueSchema(messageType);
                }
                case SchemaType.AUTO_CONSUME -> Schema.AUTO_CONSUME();
                case SchemaType.NONE -> {
                    if (messageType == null || messageType.getRawClass() == null) {
                        yield Schema.BYTES;
                    }
                    if (KeyValue.class.isAssignableFrom(messageType.getRawClass())) {
                        yield this.getMessageKeyValueSchema(messageType);
                    }
                    yield this.resolveSchema(messageType.getRawClass(), true).orElseThrow();
                }
                default -> throw new IllegalArgumentException("Unsupported schema type: " + schemaType.name());
            };
            return Resolved.of(this.castToType(schema));
        }
        catch (RuntimeException e) {
            return Resolved.failed(e);
        }
    }

    @Nullable
    private Class<?> requireNonNullMessageType(SchemaType schemaType, @Nullable ResolvableType messageType) {
        return Objects.requireNonNull(messageType, "messageType must be specified for " + schemaType.name()).getRawClass();
    }

    private Schema<?> getMessageKeyValueSchema(ResolvableType messageType) {
        Class keyClass = messageType.resolveGeneric(new int[]{0});
        Class valueClass = messageType.resolveGeneric(new int[]{1});
        Schema keySchema = this.resolveSchema(keyClass).orElseThrow();
        Schema valueSchema = this.resolveSchema(valueClass).orElseThrow();
        return Schema.KeyValue(keySchema, valueSchema, (KeyValueEncodingType)KeyValueEncodingType.INLINE);
    }

    private <X> Schema<X> castToType(Schema<?> rawSchema) {
        return rawSchema;
    }

    static {
        BASE_SCHEMA_MAPPINGS.put(byte[].class, Schema.BYTES);
        BASE_SCHEMA_MAPPINGS.put(ByteBuffer.class, Schema.BYTEBUFFER);
        BASE_SCHEMA_MAPPINGS.put(ByteBuffer.allocate(0).getClass(), Schema.BYTEBUFFER);
        BASE_SCHEMA_MAPPINGS.put(ByteBuffer.allocateDirect(0).getClass(), Schema.BYTEBUFFER);
        BASE_SCHEMA_MAPPINGS.put(String.class, Schema.STRING);
        BASE_SCHEMA_MAPPINGS.put(Boolean.class, Schema.BOOL);
        BASE_SCHEMA_MAPPINGS.put(Boolean.TYPE, Schema.BOOL);
        BASE_SCHEMA_MAPPINGS.put(Byte.class, Schema.INT8);
        BASE_SCHEMA_MAPPINGS.put(Byte.TYPE, Schema.INT8);
        BASE_SCHEMA_MAPPINGS.put(Short.class, Schema.INT16);
        BASE_SCHEMA_MAPPINGS.put(Short.TYPE, Schema.INT16);
        BASE_SCHEMA_MAPPINGS.put(Integer.class, Schema.INT32);
        BASE_SCHEMA_MAPPINGS.put(Integer.TYPE, Schema.INT32);
        BASE_SCHEMA_MAPPINGS.put(Long.class, Schema.INT64);
        BASE_SCHEMA_MAPPINGS.put(Long.TYPE, Schema.INT64);
        BASE_SCHEMA_MAPPINGS.put(Float.class, Schema.FLOAT);
        BASE_SCHEMA_MAPPINGS.put(Float.TYPE, Schema.FLOAT);
        BASE_SCHEMA_MAPPINGS.put(Double.class, Schema.DOUBLE);
        BASE_SCHEMA_MAPPINGS.put(Double.TYPE, Schema.DOUBLE);
        BASE_SCHEMA_MAPPINGS.put(Date.class, Schema.DATE);
        BASE_SCHEMA_MAPPINGS.put(Time.class, Schema.TIME);
        BASE_SCHEMA_MAPPINGS.put(Timestamp.class, Schema.TIMESTAMP);
        BASE_SCHEMA_MAPPINGS.put(Instant.class, Schema.INSTANT);
        BASE_SCHEMA_MAPPINGS.put(LocalDate.class, Schema.LOCAL_DATE);
        BASE_SCHEMA_MAPPINGS.put(LocalDateTime.class, Schema.LOCAL_DATE_TIME);
        BASE_SCHEMA_MAPPINGS.put(LocalTime.class, Schema.LOCAL_TIME);
    }
}

