/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory;

import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.core.OrderComparator;

public interface ObjectProvider<T>
extends ObjectFactory<T>,
Iterable<T> {
    @Override
    default public T getObject() throws BeansException {
        Iterator<T> it = this.iterator();
        if (!it.hasNext()) {
            throw new NoSuchBeanDefinitionException(Object.class);
        }
        T result = it.next();
        if (it.hasNext()) {
            throw new NoUniqueBeanDefinitionException(Object.class, 2, "more than 1 matching bean");
        }
        return result;
    }

    default public T getObject(Object ... args) throws BeansException {
        throw new UnsupportedOperationException("Retrieval with arguments not supported -for custom ObjectProvider classes, implement getObject(Object...) for your purposes");
    }

    default public @Nullable T getIfAvailable() throws BeansException {
        try {
            return this.getObject();
        }
        catch (NoUniqueBeanDefinitionException ex) {
            throw ex;
        }
        catch (NoSuchBeanDefinitionException ex) {
            return null;
        }
    }

    default public T getIfAvailable(Supplier<T> defaultSupplier) throws BeansException {
        T dependency = this.getIfAvailable();
        return dependency != null ? dependency : defaultSupplier.get();
    }

    default public void ifAvailable(Consumer<T> dependencyConsumer) throws BeansException {
        T dependency = this.getIfAvailable();
        if (dependency != null) {
            dependencyConsumer.accept(dependency);
        }
    }

    default public @Nullable T getIfUnique() throws BeansException {
        try {
            return this.getObject();
        }
        catch (NoSuchBeanDefinitionException ex) {
            return null;
        }
    }

    default public T getIfUnique(Supplier<T> defaultSupplier) throws BeansException {
        T dependency = this.getIfUnique();
        return dependency != null ? dependency : defaultSupplier.get();
    }

    default public void ifUnique(Consumer<T> dependencyConsumer) throws BeansException {
        T dependency = this.getIfUnique();
        if (dependency != null) {
            dependencyConsumer.accept(dependency);
        }
    }

    @Override
    default public Iterator<T> iterator() {
        return this.stream().iterator();
    }

    default public Stream<T> stream() {
        throw new UnsupportedOperationException("Element access not supported - for custom ObjectProvider classes, implement stream() to enable all other methods");
    }

    default public Stream<T> orderedStream() {
        return this.stream().sorted((Comparator<T>)OrderComparator.INSTANCE);
    }
}

