/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import reactor.core.publisher.Mono;

public abstract class ExchangeFilterFunctions {
    @Deprecated
    public static final String BASIC_AUTHENTICATION_CREDENTIALS_ATTRIBUTE = ExchangeFilterFunctions.class.getName() + ".basicAuthenticationCredentials";

    public static ExchangeFilterFunction limitResponseSize(long maxByteCount) {
        return (request, next) -> next.exchange(request).map(response -> response.mutate().body(body2 -> DataBufferUtils.takeUntilByteCount((Publisher)body2, (long)maxByteCount)).build());
    }

    public static ExchangeFilterFunction statusError(Predicate<HttpStatus> statusPredicate, Function<ClientResponse, ? extends Throwable> exceptionFunction) {
        Assert.notNull(statusPredicate, (String)"Predicate must not be null");
        Assert.notNull(exceptionFunction, (String)"Function must not be null");
        return ExchangeFilterFunction.ofResponseProcessor(response -> statusPredicate.test(response.statusCode()) ? Mono.error((Throwable)((Throwable)exceptionFunction.apply((ClientResponse)response))) : Mono.just((Object)response));
    }

    public static ExchangeFilterFunction basicAuthentication(String username, String password) {
        String encodedCredentials = HttpHeaders.encodeBasicAuth((String)username, (String)password, null);
        return (request, next) -> next.exchange(ClientRequest.from(request).headers(headers2 -> headers2.setBasicAuth(encodedCredentials)).build());
    }

    @Deprecated
    public static ExchangeFilterFunction basicAuthentication() {
        return (request, next) -> {
            Object attr = request.attributes().get(BASIC_AUTHENTICATION_CREDENTIALS_ATTRIBUTE);
            if (attr instanceof Credentials) {
                Credentials cred = (Credentials)attr;
                return next.exchange(ClientRequest.from(request).headers(headers2 -> headers2.setBasicAuth(cred.username, cred.password)).build());
            }
            return next.exchange(request);
        };
    }

    @Deprecated
    public static final class Credentials {
        private final String username;
        private final String password;

        public Credentials(String username, String password) {
            Assert.notNull((Object)username, (String)"'username' must not be null");
            Assert.notNull((Object)password, (String)"'password' must not be null");
            this.username = username;
            this.password = password;
        }

        public static Consumer<Map<String, Object>> basicAuthenticationCredentials(String username, String password) {
            Credentials credentials = new Credentials(username, password);
            return map -> map.put(BASIC_AUTHENTICATION_CREDENTIALS_ATTRIBUTE, credentials);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Credentials)) {
                return false;
            }
            Credentials otherCred = (Credentials)other;
            return this.username.equals(otherCred.username) && this.password.equals(otherCred.password);
        }

        public int hashCode() {
            return this.username.hashCode() * 31 + this.password.hashCode();
        }
    }
}

