/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.sample;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.talend.sdk.component.api.configuration.Option;
import org.talend.sdk.component.api.processor.ElementListener;
import org.talend.sdk.component.api.processor.Processor;
import org.talend.sdk.component.sample.FileService;
import org.talend.sdk.component.sample.User;

@Processor(name="writer")
public class UserWriter
implements Serializable {
    private final File file;
    private final FileService service;
    private transient PrintStream writer;

    public UserWriter(@Option(value="file") File file, FileService service) {
        this.file = file;
        this.service = service;
    }

    @PostConstruct
    public void open() throws FileNotFoundException {
        this.writer = this.service.createOutput(this.file);
    }

    @ElementListener
    public void write(User user) throws IOException {
        this.writer.println(user.getId() + ";" + user.getName());
    }

    @PreDestroy
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
    }
}

