/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.sample.other;

import java.io.Serializable;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.talend.sdk.component.api.configuration.Option;
import org.talend.sdk.component.api.configuration.action.Proposable;
import org.talend.sdk.component.api.configuration.type.DataSet;
import org.talend.sdk.component.api.configuration.type.DataStore;
import org.talend.sdk.component.api.configuration.ui.OptionsOrder;
import org.talend.sdk.component.api.configuration.ui.widget.Credential;
import org.talend.sdk.component.api.input.Emitter;
import org.talend.sdk.component.api.input.Producer;
import org.talend.sdk.component.api.service.Service;
import org.talend.sdk.component.api.service.completion.DynamicValues;
import org.talend.sdk.component.api.service.completion.Values;

@Emitter(family="complex", name="demo")
public class ComplexComponent
implements Serializable {
    private final ComplexDataSet dataset;

    public ComplexComponent(@Option(value="dataset") ComplexDataSet dataset) {
        this.dataset = dataset;
    }

    @Producer
    public String value() {
        return "";
    }

    @DataSet(value="complicated")
    @OptionsOrder(value={"path", "credentials"})
    public static class ComplexDataSet
    implements Serializable {
        @Option
        private Credentials credentials;
        @Option
        @Proposable(value="path")
        private String path;

        public Credentials getCredentials() {
            return this.credentials;
        }

        public String getPath() {
            return this.path;
        }

        public void setCredentials(Credentials credentials) {
            this.credentials = credentials;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ComplexDataSet)) {
                return false;
            }
            ComplexDataSet other = (ComplexDataSet)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Credentials this$credentials = this.getCredentials();
            Credentials other$credentials = other.getCredentials();
            if (this$credentials == null ? other$credentials != null : !((Object)this$credentials).equals(other$credentials)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            return !(this$path == null ? other$path != null : !this$path.equals(other$path));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ComplexDataSet;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Credentials $credentials = this.getCredentials();
            result = result * 59 + ($credentials == null ? 43 : ((Object)$credentials).hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            return result;
        }

        public String toString() {
            return "ComplexComponent.ComplexDataSet(credentials=" + this.getCredentials() + ", path=" + this.getPath() + ")";
        }
    }

    @Service
    public static class PathService {
        @DynamicValues(family="complex", value="path")
        public Values find(@Option(value="value") String value) {
            return new Values((Collection)IntStream.range(1, 11).mapToObj(i -> new Values.Item("file_" + i, "/opt/sample/file_" + i + ".txt")).collect(Collectors.toList()));
        }
    }

    @DataStore(value="complicated")
    public static class Credentials
    implements Serializable {
        @Option
        private String username;
        @Option
        @Credential
        private String password;

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Credentials)) {
                return false;
            }
            Credentials other = (Credentials)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Credentials;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        public String toString() {
            return "ComplexComponent.Credentials(username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
        }
    }
}

