/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.launcher;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.wildfly.core.launcher.AbstractCommandBuilder;
import org.wildfly.core.launcher.Arguments;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.Environment;
import org.wildfly.core.launcher.Jvm;
import org.wildfly.core.launcher.logger.LauncherMessages;

public class StandaloneCommandBuilder
extends AbstractCommandBuilder<StandaloneCommandBuilder>
implements CommandBuilder {
    static final String DEBUG_FORMAT = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=%s,address=%d";
    private static final String MODULE_NAME = "org.jboss.as.standalone";
    private static final String SERVER_BASE_DIR = "jboss.server.base.dir";
    private static final String SERVER_CONFIG_DIR = "jboss.server.config.dir";
    private static final String SERVER_LOG_DIR = "jboss.server.log.dir";
    private Path baseDir;
    private final Arguments javaOpts = new Arguments();
    private String debugArg;
    private String modulesLocklessArg;
    private String modulesMetricsArg;
    private final Map<String, String> securityProperties;
    private boolean addModuleAgent;
    private final Collection<String> moduleOpts;

    private StandaloneCommandBuilder(Path wildflyHome) {
        super(wildflyHome, MODULE_NAME);
        this.javaOpts.addAll(DEFAULT_VM_ARGUMENTS);
        this.securityProperties = new LinkedHashMap<String, String>();
        this.moduleOpts = new ArrayList<String>();
        this.addModuleAgent = false;
    }

    public static StandaloneCommandBuilder of(Path wildflyHome) {
        return new StandaloneCommandBuilder(Environment.validateWildFlyDir(wildflyHome));
    }

    public static StandaloneCommandBuilder of(String wildflyHome) {
        return new StandaloneCommandBuilder(Environment.validateWildFlyDir(wildflyHome));
    }

    @Override
    public StandaloneCommandBuilder addJavaOption(String jvmArg) {
        if (jvmArg != null && !jvmArg.trim().isEmpty()) {
            Arguments.Argument argument = Arguments.parse(jvmArg);
            switch (argument.getKey()) {
                case "jboss.server.base.dir": {
                    if (argument.getValue() == null) break;
                    this.setBaseDirectory(argument.getValue());
                    break;
                }
                case "jboss.server.config.dir": {
                    if (argument.getValue() == null) break;
                    this.setConfigurationDirectory(argument.getValue());
                    break;
                }
                case "jboss.server.log.dir": {
                    if (argument.getValue() == null) break;
                    this.setLogDirectory(argument.getValue());
                    break;
                }
                case "java.security.manager": {
                    this.setUseSecurityManager(StandaloneCommandBuilder.isJavaSecurityManagerConfigured(argument));
                    break;
                }
                default: {
                    this.javaOpts.add(argument);
                }
            }
        }
        return this;
    }

    @Override
    public StandaloneCommandBuilder addJavaOptions(String ... javaOpts) {
        if (javaOpts != null) {
            for (String javaOpt : javaOpts) {
                this.addJavaOption(javaOpt);
            }
        }
        return this;
    }

    @Override
    public StandaloneCommandBuilder addJavaOptions(Iterable<String> javaOpts) {
        if (javaOpts != null) {
            for (String javaOpt : javaOpts) {
                this.addJavaOption(javaOpt);
            }
        }
        return this;
    }

    @Override
    public StandaloneCommandBuilder setJavaOptions(Iterable<String> javaOpts) {
        this.javaOpts.clear();
        return this.addJavaOptions((Iterable)javaOpts);
    }

    @Override
    public StandaloneCommandBuilder setJavaOptions(String ... javaOpts) {
        this.javaOpts.clear();
        return this.addJavaOptions(javaOpts);
    }

    @Override
    public List<String> getJavaOptions() {
        return this.javaOpts.asList();
    }

    @Override
    public StandaloneCommandBuilder addModuleOption(String arg) {
        if (arg != null) {
            if (arg.startsWith("-javaagent:")) {
                this.addModuleAgent = true;
            } else {
                if ("-mp".equals(arg) || "--modulepath".equals(arg)) {
                    throw LauncherMessages.MESSAGES.invalidArgument(arg, "addModuleOption");
                }
                if ("-secmgr".equals(arg)) {
                    throw LauncherMessages.MESSAGES.invalidArgument(arg, "setUseSecurityManager");
                }
            }
            this.moduleOpts.add(arg);
        }
        return this;
    }

    @Override
    public StandaloneCommandBuilder addModuleOptions(String ... args) {
        if (args != null) {
            for (String arg : args) {
                this.addModuleOption(arg);
            }
        }
        return this;
    }

    @Override
    public StandaloneCommandBuilder addModuleOptions(Iterable<String> args) {
        if (args != null) {
            for (String arg : args) {
                this.addModuleOption(arg);
            }
        }
        return this;
    }

    @Override
    public StandaloneCommandBuilder setModuleOptions(String ... args) {
        this.moduleOpts.clear();
        this.addModuleOptions(args);
        return this;
    }

    @Override
    public StandaloneCommandBuilder setModuleOptions(Iterable<String> args) {
        this.moduleOpts.clear();
        this.addModuleOptions((Iterable)args);
        return this;
    }

    public StandaloneCommandBuilder setDebug() {
        return this.setDebug(false, 8787);
    }

    public StandaloneCommandBuilder setDebug(int port) {
        return this.setDebug(false, port);
    }

    public StandaloneCommandBuilder setDebug(boolean suspend, int port) {
        this.debugArg = String.format(DEBUG_FORMAT, suspend ? "y" : "n", port);
        return this;
    }

    public StandaloneCommandBuilder setBaseDirectory(String baseDir) {
        this.baseDir = Environment.validateAndNormalizeDir(baseDir, true);
        return this;
    }

    public StandaloneCommandBuilder setBaseDirectory(Path baseDir) {
        this.baseDir = Environment.validateAndNormalizeDir(baseDir, true);
        return this;
    }

    @Override
    public StandaloneCommandBuilder setJavaHome(String javaHome) {
        this.environment.setJvm(Jvm.of(javaHome));
        return this;
    }

    @Override
    public StandaloneCommandBuilder setJavaHome(Path javaHome) {
        this.environment.setJvm(Jvm.of(javaHome));
        return this;
    }

    @Override
    public StandaloneCommandBuilder setModulesLockless(boolean b) {
        this.modulesLocklessArg = b ? "-Djboss.modules.lockless=true" : null;
        return this;
    }

    @Override
    public StandaloneCommandBuilder setModulesMetrics(boolean b) {
        this.modulesMetricsArg = b ? "-Djboss.modules.metrics=true" : null;
        return this;
    }

    public StandaloneCommandBuilder setServerConfiguration(String configFile) {
        this.setSingleServerArg("-c", configFile);
        return this;
    }

    public String getServerConfiguration() {
        return this.getServerArg("-c");
    }

    public StandaloneCommandBuilder setServerReadOnlyConfiguration(String configFile) {
        this.setSingleServerArg("--read-only-server-config", configFile);
        return this;
    }

    public String getReadOnlyServerConfiguration() {
        return this.getServerArg("--read-only-server-config");
    }

    public StandaloneCommandBuilder addSecurityProperty(String key) {
        this.securityProperties.put(key, null);
        return this;
    }

    public StandaloneCommandBuilder addSecurityProperty(String key, String value) {
        this.securityProperties.put(key, value);
        return this;
    }

    public StandaloneCommandBuilder addSecurityProperties(Map<String, String> properties) {
        this.securityProperties.putAll(properties);
        return this;
    }

    public StandaloneCommandBuilder setGitRepository(String gitRepository, String gitBranch, String gitAuthentication) {
        if (gitRepository == null) {
            throw LauncherMessages.MESSAGES.nullParam("git-repo");
        }
        this.addServerArg("--git-repo", gitRepository);
        if (gitBranch != null) {
            this.addServerArg("--git-branch", gitBranch);
        }
        if (gitAuthentication != null) {
            this.addServerArg("--git-auth", gitAuthentication);
        }
        return this;
    }

    public StandaloneCommandBuilder setYamlFiles(Collection<Path> yamlFiles) {
        if (yamlFiles == null || yamlFiles.isEmpty()) {
            return this;
        }
        StringJoiner joiner = new StringJoiner(File.pathSeparator);
        for (Path yamlFile : yamlFiles) {
            joiner.add(yamlFile.toAbsolutePath().toString());
        }
        this.setSingleServerArg("--yaml", joiner.toString());
        return this;
    }

    public StandaloneCommandBuilder setYamlFiles(Path ... yamlFiles) {
        if (yamlFiles == null || yamlFiles.length == 0) {
            return this;
        }
        return this.setYamlFiles(List.of(yamlFiles));
    }

    public StandaloneCommandBuilder setStability(String stability) {
        if (stability != null) {
            this.setSingleServerArg("--stability", stability);
        }
        return this;
    }

    @Override
    public List<String> buildArguments() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("-D[Standalone]");
        if (this.addModuleAgent) {
            cmd.add("-javaagent:" + this.getModulesJarName());
        }
        cmd.addAll(this.getJavaOptions());
        if (this.environment.getJvm().isModular()) {
            cmd.addAll(DEFAULT_MODULAR_VM_ARGUMENTS);
            for (String optionalModularArgument : OPTIONAL_DEFAULT_MODULAR_VM_ARGUMENTS) {
                if (!Jvm.isPackageAvailable(this.environment.getJvm().getPath(), optionalModularArgument)) continue;
                cmd.add(optionalModularArgument);
            }
        }
        if (this.environment.getJvm().enhancedSecurityManagerAvailable()) {
            cmd.add("-Djava.security.manager=allow");
        }
        StandaloneCommandBuilder.addSystemPropertyArg(cmd, "jboss.home.dir", this.getWildFlyHome());
        StandaloneCommandBuilder.addSystemPropertyArg(cmd, SERVER_BASE_DIR, this.getBaseDirectory());
        StandaloneCommandBuilder.addSystemPropertyArg(cmd, SERVER_LOG_DIR, this.getLogDirectory());
        StandaloneCommandBuilder.addSystemPropertyArg(cmd, SERVER_CONFIG_DIR, this.getConfigurationDirectory());
        if (this.modulesLocklessArg != null) {
            cmd.add(this.modulesLocklessArg);
        }
        if (this.modulesMetricsArg != null) {
            cmd.add(this.modulesMetricsArg);
        }
        if (this.debugArg != null) {
            cmd.add(this.debugArg);
        }
        cmd.add(this.getBootLogArgument("server.log"));
        cmd.add(this.getLoggingPropertiesArgument("logging.properties"));
        cmd.add("-jar");
        cmd.add(this.getModulesJarName());
        if (this.useSecurityManager()) {
            cmd.add("-secmgr");
        }
        cmd.addAll(this.moduleOpts);
        cmd.add("-mp");
        cmd.add(this.getModulePaths());
        cmd.add(MODULE_NAME);
        StringBuilder sb = new StringBuilder(64);
        for (Map.Entry<String, String> entry : this.securityProperties.entrySet()) {
            sb.append("-S").append(entry.getKey());
            if (entry.getValue() != null) {
                sb.append('=').append(entry.getValue());
            }
            cmd.add(sb.toString());
            sb.setLength(0);
        }
        cmd.addAll(this.getServerArguments());
        return cmd;
    }

    @Override
    public Path getJavaHome() {
        return this.environment.getJvm().getPath();
    }

    @Override
    public Path getBaseDirectory() {
        if (this.baseDir == null) {
            return this.normalizePath("standalone");
        }
        return this.baseDir;
    }

    @Override
    protected StandaloneCommandBuilder getThis() {
        return this;
    }

    @Override
    boolean addServerArgument(Arguments.Argument argument) {
        switch (argument.getKey()) {
            case "jboss.server.base.dir": {
                if (argument.getValue() == null) break;
                this.setBaseDirectory(argument.getValue());
                return false;
            }
            case "jboss.server.config.dir": {
                if (argument.getValue() == null) break;
                this.setConfigurationDirectory(argument.getValue());
                return false;
            }
            case "jboss.server.log.dir": {
                if (argument.getValue() == null) break;
                this.setLogDirectory(argument.getValue());
                return false;
            }
        }
        return true;
    }
}

