/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.dao;

import java.util.Date;
import java.util.Map;
import java.util.Set;

public interface ProcessManagementDAO {
    public Map<InstanceSummaryKey, Long> countInstancesSummary(Set<String> var1);

    public Map<String, FailedSummaryValue> findFailedCountAndLastFailedDateForProcessIds(Set<String> var1);

    public static class FailedSummaryValue {
        public final Long count;
        public final Date lastFailed;

        public FailedSummaryValue(Long count, Date lastFailed) {
            this.count = count;
            this.lastFailed = lastFailed;
        }
    }

    public static class InstanceSummaryKey {
        public final String pid;
        public final String instanceStatus;

        public InstanceSummaryKey(String pid, String instanceStatus) {
            this.pid = pid;
            this.instanceStatus = instanceStatus;
        }

        public String toString() {
            return "InstanceSummaryKey [instanceStatus=" + this.instanceStatus + ", pid=" + this.pid + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.instanceStatus == null ? 0 : this.instanceStatus.hashCode());
            result = 31 * result + (this.pid == null ? 0 : this.pid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InstanceSummaryKey other = (InstanceSummaryKey)obj;
            if (this.instanceStatus == null ? other.instanceStatus != null : !this.instanceStatus.equals(other.instanceStatus)) {
                return false;
            }
            return !(this.pid == null ? other.pid != null : !this.pid.equals(other.pid));
        }
    }
}

