/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.test;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MessageExchangeContext;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MessageExchangeContextImpl
implements MessageExchangeContext {
    private static final String PROBE_NS = "http://ode/bpel/unit-test/ProbeService.wsdl";
    private static final String FAULT_NS = "http://ode/bpel/unit-test/FaultService.wsdl";
    private static final QName probePT = new QName("http://ode/bpel/unit-test/ProbeService.wsdl", "probeMessagePT");
    private static final QName faultPT = new QName("http://ode/bpel/unit-test/FaultService.wsdl", "faultMessagePT");
    private Message currentResponse;

    public void invokePartner(PartnerRoleMessageExchange mex) throws ContextException {
        QName calledPT = mex.getPortType().getQName();
        if (calledPT.equals(probePT)) {
            this.invokeProbeService(mex);
        }
        if (calledPT.equals(faultPT)) {
            this.invokeFaultService(mex);
        }
    }

    public void onAsyncReply(MyRoleMessageExchange myRoleMex) throws BpelEngineException {
        MessageExchange.Status mStat = myRoleMex.getStatus();
        if (mStat == MessageExchange.Status.RESPONSE) {
            this.currentResponse = myRoleMex.getResponse();
        }
        myRoleMex.complete();
    }

    private void invokeProbeService(PartnerRoleMessageExchange prmx) {
        Message msg = prmx.getRequest();
        Element elm1 = prmx.getRequest().getPart("probeName");
        Element elm2 = prmx.getRequest().getPart("probeData");
        if (elm1 != null && elm2 != null) {
            String cat = elm2.getTextContent() + " -> " + elm1.getTextContent();
            elm2.setTextContent(cat);
            msg.setPart("probeData", elm2);
            Message response = prmx.createMessage(prmx.getOperation().getOutput().getMessage().getQName());
            response.setMessage(msg.getMessage());
            prmx.reply(response);
        }
    }

    private void invokeFaultService(PartnerRoleMessageExchange prmx) {
        QName errorMsgType = new QName(FAULT_NS, "errorMessage");
        QName responseMsgType = new QName(FAULT_NS, "faultMessage");
        Message faultMsg = prmx.createMessage(errorMsgType);
        Message responseMsg = prmx.createMessage(responseMsgType);
        String ind1 = prmx.getRequest().getPart("faultIndicator1").getTextContent();
        String ind2 = prmx.getRequest().getPart("faultIndicator2").getTextContent();
        String inputData = prmx.getRequest().getPart("faultData").getTextContent();
        StringBuffer faultData = new StringBuffer("<message><errorID>FA-1</errorID><errorText>");
        faultData.append(inputData);
        faultData.append("</errorText></message>");
        StringBuffer responseData = new StringBuffer("<message><faultName>FA-NoFault</faultName><faultData>");
        responseData.append(inputData);
        responseData.append("</faultData></message>");
        Element faultResponse = null;
        Element response = null;
        try {
            faultResponse = DOMUtils.stringToDOM((String)faultData.toString());
            response = DOMUtils.stringToDOM((String)responseData.toString());
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        faultMsg.setMessage(faultResponse);
        responseMsg.setMessage(response);
        if (ind1.equals("yes")) {
            prmx.replyWithFault(new QName(FAULT_NS, "FaultMessage1"), faultMsg);
        } else if (ind2.equals("yes")) {
            prmx.replyWithFault(new QName(FAULT_NS, "FaultMessage2"), faultMsg);
        } else {
            prmx.replyWithFault(new QName(FAULT_NS, "UnKnownFault"), faultMsg);
        }
    }

    public Message getCurrentResponse() {
        return this.currentResponse;
    }

    public void clearCurrentResponse() {
        this.currentResponse = null;
    }
}

