/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.CorrelationKeySet;
import org.apache.ode.bpel.dao.CorrelatorMessageDAO;
import org.apache.ode.bpel.dao.MessageDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.PartnerLinkDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.dao.jpa.CorrelatorDAOImpl;
import org.apache.ode.dao.jpa.MessageDAOImpl;
import org.apache.ode.dao.jpa.MexProperty;
import org.apache.ode.dao.jpa.OpenJPADAO;
import org.apache.ode.dao.jpa.PartnerLinkDAOImpl;
import org.apache.ode.dao.jpa.ProcessDAOImpl;
import org.apache.ode.dao.jpa.ProcessInstanceDAOImpl;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.uuid.UUID;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.StringId;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="ODE_MESSAGE_EXCHANGE")
@NamedQueries(value={@NamedQuery(name="DELETE_MEXS_BY_PROCESS", query="delete from MessageExchangeDAOImpl as m where m._process = :process"), @NamedQuery(name="SELECT_MEX_IDS_BY_PROCESS", query="select m._id from MessageExchangeDAOImpl as m where m._process = :process"), @NamedQuery(name="DELETE_MEXS_BY_INSTANCE", query="delete from MessageExchangeDAOImpl as m where m._processInst = :instance")})
public class MessageExchangeDAOImpl
extends OpenJPADAO
implements MessageExchangeDAO,
CorrelatorMessageDAO,
PersistenceCapable {
    private static final Log __log = LogFactory.getLog(MessageExchangeDAOImpl.class);
    public static final String DELETE_MEXS_BY_PROCESS = "DELETE_MEXS_BY_PROCESS";
    public static final String SELECT_MEX_IDS_BY_PROCESS = "SELECT_MEX_IDS_BY_PROCESS";
    public static final String DELETE_MEXS_BY_INSTANCE = "DELETE_MEXS_BY_INSTANCE";
    @Id
    @Column(name="MESSAGE_EXCHANGE_ID")
    private String _id;
    @Basic
    @Column(name="CALLEE")
    private String _callee;
    @Basic
    @Column(name="CHANNEL")
    private String _channel;
    @Basic
    @Column(name="CORRELATION_ID")
    private String _correlationId;
    @Basic
    @Column(name="CORRELATION_STATUS")
    private String _correlationStatus;
    @Basic
    @Column(name="CREATE_TIME")
    private Date _createTime;
    @Basic
    @Column(name="DIRECTION")
    private char _direction;
    @Lob
    @Column(name="EPR")
    private String _epr;
    @Transient
    private Element _eprElement;
    @Basic
    @Column(name="FAULT")
    private String _fault;
    @Basic
    @Column(name="FAULT_EXPLANATION")
    private String _faultExplanation;
    @Basic
    @Column(name="OPERATION")
    private String _operation;
    @Basic
    @Column(name="PARTNER_LINK_MODEL_ID")
    private int _partnerLinkModelId;
    @Basic
    @Column(name="PATTERN")
    private String _pattern;
    @Basic
    @Column(name="PORT_TYPE")
    private String _portType;
    @Basic
    @Column(name="PROPAGATE_TRANS")
    private boolean _propagateTransactionFlag;
    @Basic
    @Column(name="STATUS")
    private String _status;
    @Basic
    @Column(name="CORRELATION_KEYS")
    private String _correlationKeys;
    @Basic
    @Column(name="PIPED_ID")
    private String _pipedMessageExchangeId;
    @Basic
    @Column(name="SUBSCRIBER_COUNT")
    private int _subscriberCount;
    @OneToMany(targetEntity=MexProperty.class, mappedBy="_mex", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private Collection<MexProperty> _props = new ArrayList<MexProperty>();
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @Column(name="PROCESS_INSTANCE_ID")
    private ProcessInstanceDAOImpl _processInst;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @Column(name="PARTNER_LINK_ID")
    private PartnerLinkDAOImpl _partnerLink;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @Column(name="PROCESS_ID")
    private ProcessDAOImpl _process;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Column(name="REQUEST_MESSAGE_ID")
    private MessageDAOImpl _request;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Column(name="RESPONSE_MESSAGE_ID")
    private MessageDAOImpl _response;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @Column(name="CORR_ID")
    private CorrelatorDAOImpl _correlator;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$ode$dao$jpa$CorrelatorDAOImpl;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$Lorg$apache$ode$dao$jpa$PartnerLinkDAOImpl;
    static /* synthetic */ Class class$Lorg$apache$ode$dao$jpa$ProcessDAOImpl;
    static /* synthetic */ Class class$Lorg$apache$ode$dao$jpa$ProcessInstanceDAOImpl;
    static /* synthetic */ Class class$Ljava$util$Collection;
    static /* synthetic */ Class class$Lorg$apache$ode$dao$jpa$MessageDAOImpl;
    static /* synthetic */ Class class$Lorg$apache$ode$dao$jpa$MessageExchangeDAOImpl;
    private transient Object pcDetachedState;

    public MessageExchangeDAOImpl() {
    }

    public MessageExchangeDAOImpl(char direction) {
        this._direction = direction;
        this._id = new UUID().toString();
    }

    public MessageDAO createMessage(QName type) {
        MessageDAOImpl ret = new MessageDAOImpl(type, this);
        return ret;
    }

    public QName getCallee() {
        return MessageExchangeDAOImpl.pcGet_callee(this) == null ? null : QName.valueOf(MessageExchangeDAOImpl.pcGet_callee(this));
    }

    public String getChannel() {
        return MessageExchangeDAOImpl.pcGet_channel(this);
    }

    public String getCorrelationId() {
        return MessageExchangeDAOImpl.pcGet_correlationId(this);
    }

    public String getCorrelationStatus() {
        return MessageExchangeDAOImpl.pcGet_correlationStatus(this);
    }

    public Date getCreateTime() {
        return MessageExchangeDAOImpl.pcGet_createTime(this);
    }

    public char getDirection() {
        return MessageExchangeDAOImpl.pcGet_direction(this);
    }

    public Element getEPR() {
        if (this._eprElement == null && MessageExchangeDAOImpl.pcGet_epr(this) != null && !"".equals(MessageExchangeDAOImpl.pcGet_epr(this))) {
            try {
                this._eprElement = DOMUtils.stringToDOM((String)MessageExchangeDAOImpl.pcGet_epr(this));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this._eprElement;
    }

    public QName getFault() {
        return MessageExchangeDAOImpl.pcGet_fault(this) == null ? null : QName.valueOf(MessageExchangeDAOImpl.pcGet_fault(this));
    }

    public String getFaultExplanation() {
        return MessageExchangeDAOImpl.pcGet_faultExplanation(this);
    }

    public ProcessInstanceDAO getInstance() {
        return MessageExchangeDAOImpl.pcGet_processInst(this);
    }

    public String getMessageExchangeId() {
        return MessageExchangeDAOImpl.pcGet_id(this).toString();
    }

    public String getOperation() {
        return MessageExchangeDAOImpl.pcGet_operation(this);
    }

    public PartnerLinkDAO getPartnerLink() {
        return MessageExchangeDAOImpl.pcGet_partnerLink(this);
    }

    public int getPartnerLinkModelId() {
        return MessageExchangeDAOImpl.pcGet_partnerLinkModelId(this);
    }

    public String getPattern() {
        return MessageExchangeDAOImpl.pcGet_pattern(this);
    }

    public QName getPortType() {
        return MessageExchangeDAOImpl.pcGet_portType(this) == null ? null : QName.valueOf(MessageExchangeDAOImpl.pcGet_portType(this));
    }

    public ProcessDAO getProcess() {
        return MessageExchangeDAOImpl.pcGet_process(this);
    }

    public boolean getPropagateTransactionFlag() {
        return MessageExchangeDAOImpl.pcGet_propagateTransactionFlag(this);
    }

    public String getProperty(String key) {
        for (MexProperty prop : MessageExchangeDAOImpl.pcGet_props(this)) {
            if (!prop.getPropertyKey().equals(key)) continue;
            return prop.getPropertyValue();
        }
        return null;
    }

    public Set<String> getPropertyNames() {
        HashSet<String> propNames = new HashSet<String>();
        for (MexProperty prop : MessageExchangeDAOImpl.pcGet_props(this)) {
            propNames.add(prop.getPropertyKey());
        }
        return propNames;
    }

    public MessageDAO getRequest() {
        return MessageExchangeDAOImpl.pcGet_request(this);
    }

    public MessageDAO getResponse() {
        return MessageExchangeDAOImpl.pcGet_response(this);
    }

    public String getStatus() {
        return MessageExchangeDAOImpl.pcGet_status(this);
    }

    public void setCallee(QName callee) {
        MessageExchangeDAOImpl.pcSet_callee(this, callee.toString());
    }

    public void setChannel(String channel) {
        MessageExchangeDAOImpl.pcSet_channel(this, channel);
    }

    public void setCorrelationId(String correlationId) {
        MessageExchangeDAOImpl.pcSet_correlationId(this, correlationId);
    }

    public void setCorrelationStatus(String cstatus) {
        MessageExchangeDAOImpl.pcSet_correlationStatus(this, cstatus);
    }

    public void setEPR(Element epr) {
        this._eprElement = epr;
        MessageExchangeDAOImpl.pcSet_epr(this, DOMUtils.domToString((Node)epr));
    }

    public void setFault(QName faultType) {
        MessageExchangeDAOImpl.pcSet_fault(this, faultType == null ? null : faultType.toString());
    }

    public void setFaultExplanation(String explanation) {
        if (explanation != null && explanation.length() > 255) {
            explanation = explanation.substring(0, 254);
        }
        MessageExchangeDAOImpl.pcSet_faultExplanation(this, explanation);
    }

    public void setInstance(ProcessInstanceDAO dao) {
        MessageExchangeDAOImpl.pcSet_processInst(this, (ProcessInstanceDAOImpl)dao);
    }

    public void setOperation(String opname) {
        MessageExchangeDAOImpl.pcSet_operation(this, opname);
    }

    public void setPartnerLink(PartnerLinkDAO plinkDAO) {
        MessageExchangeDAOImpl.pcSet_partnerLink(this, (PartnerLinkDAOImpl)plinkDAO);
    }

    public void setPartnerLinkModelId(int modelId) {
        MessageExchangeDAOImpl.pcSet_partnerLinkModelId(this, modelId);
    }

    public void setPattern(String pattern) {
        MessageExchangeDAOImpl.pcSet_pattern(this, pattern);
    }

    public void setPortType(QName porttype) {
        MessageExchangeDAOImpl.pcSet_portType(this, porttype.toString());
    }

    public void setProcess(ProcessDAO process) {
        MessageExchangeDAOImpl.pcSet_process(this, (ProcessDAOImpl)process);
    }

    public void setProperty(String key, String value) {
        MessageExchangeDAOImpl.pcGet_props(this).add(new MexProperty(key, value, this));
    }

    public void setRequest(MessageDAO msg) {
        MessageExchangeDAOImpl.pcSet_request(this, (MessageDAOImpl)msg);
    }

    public void setResponse(MessageDAO msg) {
        MessageExchangeDAOImpl.pcSet_response(this, (MessageDAOImpl)msg);
    }

    public void setStatus(String status) {
        MessageExchangeDAOImpl.pcSet_status(this, status);
    }

    public String getPipedMessageExchangeId() {
        return MessageExchangeDAOImpl.pcGet_pipedMessageExchangeId(this);
    }

    public void setPipedMessageExchangeId(String pipedMessageExchangeId) {
        MessageExchangeDAOImpl.pcSet_pipedMessageExchangeId(this, pipedMessageExchangeId);
    }

    void setCorrelationKeySet(CorrelationKeySet correlationKeySet) {
        MessageExchangeDAOImpl.pcSet_correlationKeys(this, correlationKeySet.toCanonicalString());
    }

    CorrelationKeySet getCorrelationKeySet() {
        return new CorrelationKeySet(MessageExchangeDAOImpl.pcGet_correlationKeys(this));
    }

    public CorrelationKey getCorrelationKey() {
        if (MessageExchangeDAOImpl.pcGet_correlationKeys(this) == null) {
            return null;
        }
        return (CorrelationKey)this.getCorrelationKeySet().iterator().next();
    }

    public void setCorrelationKey(CorrelationKey ckey) {
        MessageExchangeDAOImpl.pcSet_correlationKeys(this, ckey.toCanonicalString());
    }

    public void release(boolean doClean) {
        if (doClean) {
            this.deleteMessages();
        }
    }

    public void releasePremieMessages() {
    }

    public void deleteMessages() {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)"Deleting message on MEX release.");
        }
        this.getEM().remove((Object)this);
    }

    public CorrelatorDAOImpl getCorrelator() {
        return MessageExchangeDAOImpl.pcGet_correlator(this);
    }

    public void setCorrelator(CorrelatorDAOImpl correlator) {
        MessageExchangeDAOImpl.pcSet_correlator(this, correlator);
    }

    public int getSubscriberCount() {
        return MessageExchangeDAOImpl.pcGet_subscriberCount(this);
    }

    public void setSubscriberCount(int subscriberCount) {
        MessageExchangeDAOImpl.pcSet_subscriberCount(this, subscriberCount);
    }

    public void incrementSubscriberCount() {
        MessageExchangeDAOImpl messageExchangeDAOImpl = this;
        MessageExchangeDAOImpl.pcSet_subscriberCount(messageExchangeDAOImpl, MessageExchangeDAOImpl.pcGet_subscriberCount(messageExchangeDAOImpl) + 1);
    }

    public void release() {
    }

    public void setCreateTime(Date createTime) {
        MessageExchangeDAOImpl.pcSet_createTime(this, createTime);
    }

    public boolean lockPremieMessages() {
        return true;
    }

    static {
        pcFieldNames = new String[]{"_callee", "_channel", "_correlationId", "_correlationKeys", "_correlationStatus", "_correlator", "_createTime", "_direction", "_epr", "_fault", "_faultExplanation", "_id", "_operation", "_partnerLink", "_partnerLinkModelId", "_pattern", "_pipedMessageExchangeId", "_portType", "_process", "_processInst", "_propagateTransactionFlag", "_props", "_request", "_response", "_status", "_subscriberCount"};
        Class[] classArray = new Class[26];
        Class clazz = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = MessageExchangeDAOImpl.class$("java.lang.String"));
        classArray[0] = clazz;
        classArray[1] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = MessageExchangeDAOImpl.class$("java.lang.String"));
        classArray[2] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = MessageExchangeDAOImpl.class$("java.lang.String"));
        classArray[3] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = MessageExchangeDAOImpl.class$("java.lang.String"));
        classArray[4] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = MessageExchangeDAOImpl.class$("java.lang.String"));
        Class clazz2 = class$Lorg$apache$ode$dao$jpa$CorrelatorDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$CorrelatorDAOImpl : (class$Lorg$apache$ode$dao$jpa$CorrelatorDAOImpl = MessageExchangeDAOImpl.class$("org.apache.ode.dao.jpa.CorrelatorDAOImpl"));
        classArray[5] = clazz2;
        Class clazz3 = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = MessageExchangeDAOImpl.class$("java.util.Date"));
        classArray[6] = clazz3;
        classArray[7] = Character.TYPE;
        classArray[8] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = MessageExchangeDAOImpl.class$("java.lang.String"));
        classArray[9] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = MessageExchangeDAOImpl.class$("java.lang.String"));
        classArray[10] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = MessageExchangeDAOImpl.class$("java.lang.String"));
        classArray[11] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = MessageExchangeDAOImpl.class$("java.lang.String"));
        classArray[12] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = MessageExchangeDAOImpl.class$("java.lang.String"));
        Class clazz4 = class$Lorg$apache$ode$dao$jpa$PartnerLinkDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$PartnerLinkDAOImpl : (class$Lorg$apache$ode$dao$jpa$PartnerLinkDAOImpl = MessageExchangeDAOImpl.class$("org.apache.ode.dao.jpa.PartnerLinkDAOImpl"));
        classArray[13] = clazz4;
        classArray[14] = Integer.TYPE;
        classArray[15] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = MessageExchangeDAOImpl.class$("java.lang.String"));
        classArray[16] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = MessageExchangeDAOImpl.class$("java.lang.String"));
        classArray[17] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = MessageExchangeDAOImpl.class$("java.lang.String"));
        Class clazz5 = class$Lorg$apache$ode$dao$jpa$ProcessDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$ProcessDAOImpl : (class$Lorg$apache$ode$dao$jpa$ProcessDAOImpl = MessageExchangeDAOImpl.class$("org.apache.ode.dao.jpa.ProcessDAOImpl"));
        classArray[18] = clazz5;
        Class clazz6 = class$Lorg$apache$ode$dao$jpa$ProcessInstanceDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$ProcessInstanceDAOImpl : (class$Lorg$apache$ode$dao$jpa$ProcessInstanceDAOImpl = MessageExchangeDAOImpl.class$("org.apache.ode.dao.jpa.ProcessInstanceDAOImpl"));
        classArray[19] = clazz6;
        classArray[20] = Boolean.TYPE;
        Class clazz7 = class$Ljava$util$Collection != null ? class$Ljava$util$Collection : (class$Ljava$util$Collection = MessageExchangeDAOImpl.class$("java.util.Collection"));
        classArray[21] = clazz7;
        Class clazz8 = class$Lorg$apache$ode$dao$jpa$MessageDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$MessageDAOImpl : (class$Lorg$apache$ode$dao$jpa$MessageDAOImpl = MessageExchangeDAOImpl.class$("org.apache.ode.dao.jpa.MessageDAOImpl"));
        classArray[22] = clazz8;
        classArray[23] = class$Lorg$apache$ode$dao$jpa$MessageDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$MessageDAOImpl : (class$Lorg$apache$ode$dao$jpa$MessageDAOImpl = MessageExchangeDAOImpl.class$("org.apache.ode.dao.jpa.MessageDAOImpl"));
        classArray[24] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = MessageExchangeDAOImpl.class$("java.lang.String"));
        classArray[25] = Integer.TYPE;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 5, 26, 26, 26, 26, 26, 26, 26, 5, 26, 26, 26, 26, 5, 5, 26, 10, 5, 5, 26, 26};
        Class clazz9 = class$Lorg$apache$ode$dao$jpa$MessageExchangeDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$MessageExchangeDAOImpl : (class$Lorg$apache$ode$dao$jpa$MessageExchangeDAOImpl = MessageExchangeDAOImpl.class$("org.apache.ode.dao.jpa.MessageExchangeDAOImpl"));
        PCRegistry.register((Class)clazz9, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"MessageExchangeDAOImpl", (PersistenceCapable)new MessageExchangeDAOImpl());
    }

    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this._callee = null;
        this._channel = null;
        this._correlationId = null;
        this._correlationKeys = null;
        this._correlationStatus = null;
        this._correlator = null;
        this._createTime = null;
        this._direction = '\u0000';
        this._epr = null;
        this._fault = null;
        this._faultExplanation = null;
        this._id = null;
        this._operation = null;
        this._partnerLink = null;
        this._partnerLinkModelId = 0;
        this._pattern = null;
        this._pipedMessageExchangeId = null;
        this._portType = null;
        this._process = null;
        this._processInst = null;
        this._propagateTransactionFlag = false;
        this._props = null;
        this._request = null;
        this._response = null;
        this._status = null;
        this._subscriberCount = 0;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        MessageExchangeDAOImpl messageExchangeDAOImpl = new MessageExchangeDAOImpl();
        if (bl) {
            messageExchangeDAOImpl.pcClearFields();
        }
        messageExchangeDAOImpl.pcStateManager = stateManager;
        messageExchangeDAOImpl.pcCopyKeyFieldsFromObjectId(object);
        return messageExchangeDAOImpl;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        MessageExchangeDAOImpl messageExchangeDAOImpl = new MessageExchangeDAOImpl();
        if (bl) {
            messageExchangeDAOImpl.pcClearFields();
        }
        messageExchangeDAOImpl.pcStateManager = stateManager;
        return messageExchangeDAOImpl;
    }

    protected static int pcGetManagedFieldCount() {
        return 26;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this._callee = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this._channel = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this._correlationId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this._correlationKeys = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this._correlationStatus = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this._correlator = (CorrelatorDAOImpl)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this._createTime = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this._direction = this.pcStateManager.replaceCharField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this._epr = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this._fault = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this._faultExplanation = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this._id = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this._operation = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this._partnerLink = (PartnerLinkDAOImpl)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this._partnerLinkModelId = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this._pattern = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this._pipedMessageExchangeId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 17: {
                this._portType = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 18: {
                this._process = (ProcessDAOImpl)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 19: {
                this._processInst = (ProcessInstanceDAOImpl)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 20: {
                this._propagateTransactionFlag = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 21: {
                this._props = (Collection)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 22: {
                this._request = (MessageDAOImpl)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 23: {
                this._response = (MessageDAOImpl)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 24: {
                this._status = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 25: {
                this._subscriberCount = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this._callee);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this._channel);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this._correlationId);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this._correlationKeys);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this._correlationStatus);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this._correlator);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this._createTime);
                return;
            }
            case 7: {
                this.pcStateManager.providedCharField((PersistenceCapable)this, n, this._direction);
                return;
            }
            case 8: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this._epr);
                return;
            }
            case 9: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this._fault);
                return;
            }
            case 10: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this._faultExplanation);
                return;
            }
            case 11: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this._id);
                return;
            }
            case 12: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this._operation);
                return;
            }
            case 13: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this._partnerLink);
                return;
            }
            case 14: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this._partnerLinkModelId);
                return;
            }
            case 15: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this._pattern);
                return;
            }
            case 16: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this._pipedMessageExchangeId);
                return;
            }
            case 17: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this._portType);
                return;
            }
            case 18: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this._process);
                return;
            }
            case 19: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this._processInst);
                return;
            }
            case 20: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this._propagateTransactionFlag);
                return;
            }
            case 21: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this._props);
                return;
            }
            case 22: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this._request);
                return;
            }
            case 23: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this._response);
                return;
            }
            case 24: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this._status);
                return;
            }
            case 25: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this._subscriberCount);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(MessageExchangeDAOImpl messageExchangeDAOImpl, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this._callee = messageExchangeDAOImpl._callee;
                return;
            }
            case 1: {
                this._channel = messageExchangeDAOImpl._channel;
                return;
            }
            case 2: {
                this._correlationId = messageExchangeDAOImpl._correlationId;
                return;
            }
            case 3: {
                this._correlationKeys = messageExchangeDAOImpl._correlationKeys;
                return;
            }
            case 4: {
                this._correlationStatus = messageExchangeDAOImpl._correlationStatus;
                return;
            }
            case 5: {
                this._correlator = messageExchangeDAOImpl._correlator;
                return;
            }
            case 6: {
                this._createTime = messageExchangeDAOImpl._createTime;
                return;
            }
            case 7: {
                this._direction = messageExchangeDAOImpl._direction;
                return;
            }
            case 8: {
                this._epr = messageExchangeDAOImpl._epr;
                return;
            }
            case 9: {
                this._fault = messageExchangeDAOImpl._fault;
                return;
            }
            case 10: {
                this._faultExplanation = messageExchangeDAOImpl._faultExplanation;
                return;
            }
            case 11: {
                this._id = messageExchangeDAOImpl._id;
                return;
            }
            case 12: {
                this._operation = messageExchangeDAOImpl._operation;
                return;
            }
            case 13: {
                this._partnerLink = messageExchangeDAOImpl._partnerLink;
                return;
            }
            case 14: {
                this._partnerLinkModelId = messageExchangeDAOImpl._partnerLinkModelId;
                return;
            }
            case 15: {
                this._pattern = messageExchangeDAOImpl._pattern;
                return;
            }
            case 16: {
                this._pipedMessageExchangeId = messageExchangeDAOImpl._pipedMessageExchangeId;
                return;
            }
            case 17: {
                this._portType = messageExchangeDAOImpl._portType;
                return;
            }
            case 18: {
                this._process = messageExchangeDAOImpl._process;
                return;
            }
            case 19: {
                this._processInst = messageExchangeDAOImpl._processInst;
                return;
            }
            case 20: {
                this._propagateTransactionFlag = messageExchangeDAOImpl._propagateTransactionFlag;
                return;
            }
            case 21: {
                this._props = messageExchangeDAOImpl._props;
                return;
            }
            case 22: {
                this._request = messageExchangeDAOImpl._request;
                return;
            }
            case 23: {
                this._response = messageExchangeDAOImpl._response;
                return;
            }
            case 24: {
                this._status = messageExchangeDAOImpl._status;
                return;
            }
            case 25: {
                this._subscriberCount = messageExchangeDAOImpl._subscriberCount;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        MessageExchangeDAOImpl messageExchangeDAOImpl = (MessageExchangeDAOImpl)object;
        if (messageExchangeDAOImpl.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(messageExchangeDAOImpl, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public synchronized void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        StringId stringId = (StringId)object;
        fieldConsumer.storeStringField(11 + pcInheritedFieldCount, stringId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        StringId stringId = (StringId)object;
        this._id = stringId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$ode$dao$jpa$MessageExchangeDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$MessageExchangeDAOImpl : (class$Lorg$apache$ode$dao$jpa$MessageExchangeDAOImpl = MessageExchangeDAOImpl.class$("org.apache.ode.dao.jpa.MessageExchangeDAOImpl"));
        return new StringId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$ode$dao$jpa$MessageExchangeDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$MessageExchangeDAOImpl : (class$Lorg$apache$ode$dao$jpa$MessageExchangeDAOImpl = MessageExchangeDAOImpl.class$("org.apache.ode.dao.jpa.MessageExchangeDAOImpl"));
        return new StringId(clazz, this._id);
    }

    private static final String pcGet_callee(MessageExchangeDAOImpl messageExchangeDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            return messageExchangeDAOImpl._callee;
        }
        int n = pcInheritedFieldCount + 0;
        messageExchangeDAOImpl.pcStateManager.accessingField(n);
        return messageExchangeDAOImpl._callee;
    }

    private static final void pcSet_callee(MessageExchangeDAOImpl messageExchangeDAOImpl, String string) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            messageExchangeDAOImpl._callee = string;
            return;
        }
        messageExchangeDAOImpl.pcStateManager.settingStringField((PersistenceCapable)messageExchangeDAOImpl, pcInheritedFieldCount + 0, messageExchangeDAOImpl._callee, string, 0);
    }

    private static final String pcGet_channel(MessageExchangeDAOImpl messageExchangeDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            return messageExchangeDAOImpl._channel;
        }
        int n = pcInheritedFieldCount + 1;
        messageExchangeDAOImpl.pcStateManager.accessingField(n);
        return messageExchangeDAOImpl._channel;
    }

    private static final void pcSet_channel(MessageExchangeDAOImpl messageExchangeDAOImpl, String string) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            messageExchangeDAOImpl._channel = string;
            return;
        }
        messageExchangeDAOImpl.pcStateManager.settingStringField((PersistenceCapable)messageExchangeDAOImpl, pcInheritedFieldCount + 1, messageExchangeDAOImpl._channel, string, 0);
    }

    private static final String pcGet_correlationId(MessageExchangeDAOImpl messageExchangeDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            return messageExchangeDAOImpl._correlationId;
        }
        int n = pcInheritedFieldCount + 2;
        messageExchangeDAOImpl.pcStateManager.accessingField(n);
        return messageExchangeDAOImpl._correlationId;
    }

    private static final void pcSet_correlationId(MessageExchangeDAOImpl messageExchangeDAOImpl, String string) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            messageExchangeDAOImpl._correlationId = string;
            return;
        }
        messageExchangeDAOImpl.pcStateManager.settingStringField((PersistenceCapable)messageExchangeDAOImpl, pcInheritedFieldCount + 2, messageExchangeDAOImpl._correlationId, string, 0);
    }

    private static final String pcGet_correlationKeys(MessageExchangeDAOImpl messageExchangeDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            return messageExchangeDAOImpl._correlationKeys;
        }
        int n = pcInheritedFieldCount + 3;
        messageExchangeDAOImpl.pcStateManager.accessingField(n);
        return messageExchangeDAOImpl._correlationKeys;
    }

    private static final void pcSet_correlationKeys(MessageExchangeDAOImpl messageExchangeDAOImpl, String string) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            messageExchangeDAOImpl._correlationKeys = string;
            return;
        }
        messageExchangeDAOImpl.pcStateManager.settingStringField((PersistenceCapable)messageExchangeDAOImpl, pcInheritedFieldCount + 3, messageExchangeDAOImpl._correlationKeys, string, 0);
    }

    private static final String pcGet_correlationStatus(MessageExchangeDAOImpl messageExchangeDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            return messageExchangeDAOImpl._correlationStatus;
        }
        int n = pcInheritedFieldCount + 4;
        messageExchangeDAOImpl.pcStateManager.accessingField(n);
        return messageExchangeDAOImpl._correlationStatus;
    }

    private static final void pcSet_correlationStatus(MessageExchangeDAOImpl messageExchangeDAOImpl, String string) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            messageExchangeDAOImpl._correlationStatus = string;
            return;
        }
        messageExchangeDAOImpl.pcStateManager.settingStringField((PersistenceCapable)messageExchangeDAOImpl, pcInheritedFieldCount + 4, messageExchangeDAOImpl._correlationStatus, string, 0);
    }

    private static final CorrelatorDAOImpl pcGet_correlator(MessageExchangeDAOImpl messageExchangeDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            return messageExchangeDAOImpl._correlator;
        }
        int n = pcInheritedFieldCount + 5;
        messageExchangeDAOImpl.pcStateManager.accessingField(n);
        return messageExchangeDAOImpl._correlator;
    }

    private static final void pcSet_correlator(MessageExchangeDAOImpl messageExchangeDAOImpl, CorrelatorDAOImpl correlatorDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            messageExchangeDAOImpl._correlator = correlatorDAOImpl;
            return;
        }
        messageExchangeDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)messageExchangeDAOImpl, pcInheritedFieldCount + 5, (Object)messageExchangeDAOImpl._correlator, (Object)correlatorDAOImpl, 0);
    }

    private static final Date pcGet_createTime(MessageExchangeDAOImpl messageExchangeDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            return messageExchangeDAOImpl._createTime;
        }
        int n = pcInheritedFieldCount + 6;
        messageExchangeDAOImpl.pcStateManager.accessingField(n);
        return messageExchangeDAOImpl._createTime;
    }

    private static final void pcSet_createTime(MessageExchangeDAOImpl messageExchangeDAOImpl, Date date) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            messageExchangeDAOImpl._createTime = date;
            return;
        }
        messageExchangeDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)messageExchangeDAOImpl, pcInheritedFieldCount + 6, (Object)messageExchangeDAOImpl._createTime, (Object)date, 0);
    }

    private static final char pcGet_direction(MessageExchangeDAOImpl messageExchangeDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            return messageExchangeDAOImpl._direction;
        }
        int n = pcInheritedFieldCount + 7;
        messageExchangeDAOImpl.pcStateManager.accessingField(n);
        return messageExchangeDAOImpl._direction;
    }

    private static final void pcSet_direction(MessageExchangeDAOImpl messageExchangeDAOImpl, char c) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            messageExchangeDAOImpl._direction = c;
            return;
        }
        messageExchangeDAOImpl.pcStateManager.settingCharField((PersistenceCapable)messageExchangeDAOImpl, pcInheritedFieldCount + 7, messageExchangeDAOImpl._direction, c, 0);
    }

    private static final String pcGet_epr(MessageExchangeDAOImpl messageExchangeDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            return messageExchangeDAOImpl._epr;
        }
        int n = pcInheritedFieldCount + 8;
        messageExchangeDAOImpl.pcStateManager.accessingField(n);
        return messageExchangeDAOImpl._epr;
    }

    private static final void pcSet_epr(MessageExchangeDAOImpl messageExchangeDAOImpl, String string) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            messageExchangeDAOImpl._epr = string;
            return;
        }
        messageExchangeDAOImpl.pcStateManager.settingStringField((PersistenceCapable)messageExchangeDAOImpl, pcInheritedFieldCount + 8, messageExchangeDAOImpl._epr, string, 0);
    }

    private static final String pcGet_fault(MessageExchangeDAOImpl messageExchangeDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            return messageExchangeDAOImpl._fault;
        }
        int n = pcInheritedFieldCount + 9;
        messageExchangeDAOImpl.pcStateManager.accessingField(n);
        return messageExchangeDAOImpl._fault;
    }

    private static final void pcSet_fault(MessageExchangeDAOImpl messageExchangeDAOImpl, String string) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            messageExchangeDAOImpl._fault = string;
            return;
        }
        messageExchangeDAOImpl.pcStateManager.settingStringField((PersistenceCapable)messageExchangeDAOImpl, pcInheritedFieldCount + 9, messageExchangeDAOImpl._fault, string, 0);
    }

    private static final String pcGet_faultExplanation(MessageExchangeDAOImpl messageExchangeDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            return messageExchangeDAOImpl._faultExplanation;
        }
        int n = pcInheritedFieldCount + 10;
        messageExchangeDAOImpl.pcStateManager.accessingField(n);
        return messageExchangeDAOImpl._faultExplanation;
    }

    private static final void pcSet_faultExplanation(MessageExchangeDAOImpl messageExchangeDAOImpl, String string) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            messageExchangeDAOImpl._faultExplanation = string;
            return;
        }
        messageExchangeDAOImpl.pcStateManager.settingStringField((PersistenceCapable)messageExchangeDAOImpl, pcInheritedFieldCount + 10, messageExchangeDAOImpl._faultExplanation, string, 0);
    }

    private static final String pcGet_id(MessageExchangeDAOImpl messageExchangeDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            return messageExchangeDAOImpl._id;
        }
        int n = pcInheritedFieldCount + 11;
        messageExchangeDAOImpl.pcStateManager.accessingField(n);
        return messageExchangeDAOImpl._id;
    }

    private static final void pcSet_id(MessageExchangeDAOImpl messageExchangeDAOImpl, String string) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            messageExchangeDAOImpl._id = string;
            return;
        }
        messageExchangeDAOImpl.pcStateManager.settingStringField((PersistenceCapable)messageExchangeDAOImpl, pcInheritedFieldCount + 11, messageExchangeDAOImpl._id, string, 0);
    }

    private static final String pcGet_operation(MessageExchangeDAOImpl messageExchangeDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            return messageExchangeDAOImpl._operation;
        }
        int n = pcInheritedFieldCount + 12;
        messageExchangeDAOImpl.pcStateManager.accessingField(n);
        return messageExchangeDAOImpl._operation;
    }

    private static final void pcSet_operation(MessageExchangeDAOImpl messageExchangeDAOImpl, String string) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            messageExchangeDAOImpl._operation = string;
            return;
        }
        messageExchangeDAOImpl.pcStateManager.settingStringField((PersistenceCapable)messageExchangeDAOImpl, pcInheritedFieldCount + 12, messageExchangeDAOImpl._operation, string, 0);
    }

    private static final PartnerLinkDAOImpl pcGet_partnerLink(MessageExchangeDAOImpl messageExchangeDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            return messageExchangeDAOImpl._partnerLink;
        }
        int n = pcInheritedFieldCount + 13;
        messageExchangeDAOImpl.pcStateManager.accessingField(n);
        return messageExchangeDAOImpl._partnerLink;
    }

    private static final void pcSet_partnerLink(MessageExchangeDAOImpl messageExchangeDAOImpl, PartnerLinkDAOImpl partnerLinkDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            messageExchangeDAOImpl._partnerLink = partnerLinkDAOImpl;
            return;
        }
        messageExchangeDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)messageExchangeDAOImpl, pcInheritedFieldCount + 13, (Object)messageExchangeDAOImpl._partnerLink, (Object)partnerLinkDAOImpl, 0);
    }

    private static final int pcGet_partnerLinkModelId(MessageExchangeDAOImpl messageExchangeDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            return messageExchangeDAOImpl._partnerLinkModelId;
        }
        int n = pcInheritedFieldCount + 14;
        messageExchangeDAOImpl.pcStateManager.accessingField(n);
        return messageExchangeDAOImpl._partnerLinkModelId;
    }

    private static final void pcSet_partnerLinkModelId(MessageExchangeDAOImpl messageExchangeDAOImpl, int n) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            messageExchangeDAOImpl._partnerLinkModelId = n;
            return;
        }
        messageExchangeDAOImpl.pcStateManager.settingIntField((PersistenceCapable)messageExchangeDAOImpl, pcInheritedFieldCount + 14, messageExchangeDAOImpl._partnerLinkModelId, n, 0);
    }

    private static final String pcGet_pattern(MessageExchangeDAOImpl messageExchangeDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            return messageExchangeDAOImpl._pattern;
        }
        int n = pcInheritedFieldCount + 15;
        messageExchangeDAOImpl.pcStateManager.accessingField(n);
        return messageExchangeDAOImpl._pattern;
    }

    private static final void pcSet_pattern(MessageExchangeDAOImpl messageExchangeDAOImpl, String string) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            messageExchangeDAOImpl._pattern = string;
            return;
        }
        messageExchangeDAOImpl.pcStateManager.settingStringField((PersistenceCapable)messageExchangeDAOImpl, pcInheritedFieldCount + 15, messageExchangeDAOImpl._pattern, string, 0);
    }

    private static final String pcGet_pipedMessageExchangeId(MessageExchangeDAOImpl messageExchangeDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            return messageExchangeDAOImpl._pipedMessageExchangeId;
        }
        int n = pcInheritedFieldCount + 16;
        messageExchangeDAOImpl.pcStateManager.accessingField(n);
        return messageExchangeDAOImpl._pipedMessageExchangeId;
    }

    private static final void pcSet_pipedMessageExchangeId(MessageExchangeDAOImpl messageExchangeDAOImpl, String string) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            messageExchangeDAOImpl._pipedMessageExchangeId = string;
            return;
        }
        messageExchangeDAOImpl.pcStateManager.settingStringField((PersistenceCapable)messageExchangeDAOImpl, pcInheritedFieldCount + 16, messageExchangeDAOImpl._pipedMessageExchangeId, string, 0);
    }

    private static final String pcGet_portType(MessageExchangeDAOImpl messageExchangeDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            return messageExchangeDAOImpl._portType;
        }
        int n = pcInheritedFieldCount + 17;
        messageExchangeDAOImpl.pcStateManager.accessingField(n);
        return messageExchangeDAOImpl._portType;
    }

    private static final void pcSet_portType(MessageExchangeDAOImpl messageExchangeDAOImpl, String string) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            messageExchangeDAOImpl._portType = string;
            return;
        }
        messageExchangeDAOImpl.pcStateManager.settingStringField((PersistenceCapable)messageExchangeDAOImpl, pcInheritedFieldCount + 17, messageExchangeDAOImpl._portType, string, 0);
    }

    private static final ProcessDAOImpl pcGet_process(MessageExchangeDAOImpl messageExchangeDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            return messageExchangeDAOImpl._process;
        }
        int n = pcInheritedFieldCount + 18;
        messageExchangeDAOImpl.pcStateManager.accessingField(n);
        return messageExchangeDAOImpl._process;
    }

    private static final void pcSet_process(MessageExchangeDAOImpl messageExchangeDAOImpl, ProcessDAOImpl processDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            messageExchangeDAOImpl._process = processDAOImpl;
            return;
        }
        messageExchangeDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)messageExchangeDAOImpl, pcInheritedFieldCount + 18, (Object)messageExchangeDAOImpl._process, (Object)processDAOImpl, 0);
    }

    private static final ProcessInstanceDAOImpl pcGet_processInst(MessageExchangeDAOImpl messageExchangeDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            return messageExchangeDAOImpl._processInst;
        }
        int n = pcInheritedFieldCount + 19;
        messageExchangeDAOImpl.pcStateManager.accessingField(n);
        return messageExchangeDAOImpl._processInst;
    }

    private static final void pcSet_processInst(MessageExchangeDAOImpl messageExchangeDAOImpl, ProcessInstanceDAOImpl processInstanceDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            messageExchangeDAOImpl._processInst = processInstanceDAOImpl;
            return;
        }
        messageExchangeDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)messageExchangeDAOImpl, pcInheritedFieldCount + 19, (Object)messageExchangeDAOImpl._processInst, (Object)processInstanceDAOImpl, 0);
    }

    private static final boolean pcGet_propagateTransactionFlag(MessageExchangeDAOImpl messageExchangeDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            return messageExchangeDAOImpl._propagateTransactionFlag;
        }
        int n = pcInheritedFieldCount + 20;
        messageExchangeDAOImpl.pcStateManager.accessingField(n);
        return messageExchangeDAOImpl._propagateTransactionFlag;
    }

    private static final void pcSet_propagateTransactionFlag(MessageExchangeDAOImpl messageExchangeDAOImpl, boolean bl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            messageExchangeDAOImpl._propagateTransactionFlag = bl;
            return;
        }
        messageExchangeDAOImpl.pcStateManager.settingBooleanField((PersistenceCapable)messageExchangeDAOImpl, pcInheritedFieldCount + 20, messageExchangeDAOImpl._propagateTransactionFlag, bl, 0);
    }

    private static final Collection pcGet_props(MessageExchangeDAOImpl messageExchangeDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            return messageExchangeDAOImpl._props;
        }
        int n = pcInheritedFieldCount + 21;
        messageExchangeDAOImpl.pcStateManager.accessingField(n);
        return messageExchangeDAOImpl._props;
    }

    private static final void pcSet_props(MessageExchangeDAOImpl messageExchangeDAOImpl, Collection collection) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            messageExchangeDAOImpl._props = collection;
            return;
        }
        messageExchangeDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)messageExchangeDAOImpl, pcInheritedFieldCount + 21, messageExchangeDAOImpl._props, (Object)collection, 0);
    }

    private static final MessageDAOImpl pcGet_request(MessageExchangeDAOImpl messageExchangeDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            return messageExchangeDAOImpl._request;
        }
        int n = pcInheritedFieldCount + 22;
        messageExchangeDAOImpl.pcStateManager.accessingField(n);
        return messageExchangeDAOImpl._request;
    }

    private static final void pcSet_request(MessageExchangeDAOImpl messageExchangeDAOImpl, MessageDAOImpl messageDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            messageExchangeDAOImpl._request = messageDAOImpl;
            return;
        }
        messageExchangeDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)messageExchangeDAOImpl, pcInheritedFieldCount + 22, (Object)messageExchangeDAOImpl._request, (Object)messageDAOImpl, 0);
    }

    private static final MessageDAOImpl pcGet_response(MessageExchangeDAOImpl messageExchangeDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            return messageExchangeDAOImpl._response;
        }
        int n = pcInheritedFieldCount + 23;
        messageExchangeDAOImpl.pcStateManager.accessingField(n);
        return messageExchangeDAOImpl._response;
    }

    private static final void pcSet_response(MessageExchangeDAOImpl messageExchangeDAOImpl, MessageDAOImpl messageDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            messageExchangeDAOImpl._response = messageDAOImpl;
            return;
        }
        messageExchangeDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)messageExchangeDAOImpl, pcInheritedFieldCount + 23, (Object)messageExchangeDAOImpl._response, (Object)messageDAOImpl, 0);
    }

    private static final String pcGet_status(MessageExchangeDAOImpl messageExchangeDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            return messageExchangeDAOImpl._status;
        }
        int n = pcInheritedFieldCount + 24;
        messageExchangeDAOImpl.pcStateManager.accessingField(n);
        return messageExchangeDAOImpl._status;
    }

    private static final void pcSet_status(MessageExchangeDAOImpl messageExchangeDAOImpl, String string) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            messageExchangeDAOImpl._status = string;
            return;
        }
        messageExchangeDAOImpl.pcStateManager.settingStringField((PersistenceCapable)messageExchangeDAOImpl, pcInheritedFieldCount + 24, messageExchangeDAOImpl._status, string, 0);
    }

    private static final int pcGet_subscriberCount(MessageExchangeDAOImpl messageExchangeDAOImpl) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            return messageExchangeDAOImpl._subscriberCount;
        }
        int n = pcInheritedFieldCount + 25;
        messageExchangeDAOImpl.pcStateManager.accessingField(n);
        return messageExchangeDAOImpl._subscriberCount;
    }

    private static final void pcSet_subscriberCount(MessageExchangeDAOImpl messageExchangeDAOImpl, int n) {
        if (messageExchangeDAOImpl.pcStateManager == null) {
            messageExchangeDAOImpl._subscriberCount = n;
            return;
        }
        messageExchangeDAOImpl.pcStateManager.settingIntField((PersistenceCapable)messageExchangeDAOImpl, pcInheritedFieldCount + 25, messageExchangeDAOImpl._subscriberCount, n, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

