/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jacob.vpu;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.jacob.Channel;
import org.apache.ode.jacob.ChannelListener;
import org.apache.ode.jacob.IndexedObject;
import org.apache.ode.jacob.JacobObject;
import org.apache.ode.jacob.soup.Comm;
import org.apache.ode.jacob.soup.CommChannel;
import org.apache.ode.jacob.soup.CommGroup;
import org.apache.ode.jacob.soup.CommRecv;
import org.apache.ode.jacob.soup.CommSend;
import org.apache.ode.jacob.soup.Continuation;
import org.apache.ode.jacob.soup.ExecutionQueue;
import org.apache.ode.jacob.soup.ExecutionQueueObject;
import org.apache.ode.jacob.soup.ReplacementMap;
import org.apache.ode.jacob.vpu.ChannelFactory;
import org.apache.ode.utils.CollectionUtils;
import org.apache.ode.utils.ObjectPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionQueueImpl
implements ExecutionQueue {
    private static final Log __log = LogFactory.getLog(ExecutionQueueImpl.class);
    private ClassLoader _classLoader;
    public static ConcurrentHashMap<String, ObjectStreamClass> _classDescriptors = new ConcurrentHashMap();
    private Set<Continuation> _reactions = new HashSet<Continuation>();
    private Map<Integer, ChannelFrame> _channels = new HashMap<Integer, ChannelFrame>();
    private int _currentCycle;
    private int _objIdCounter;
    private ExecutionQueueStatistics _statistics = new ExecutionQueueStatistics();
    private ReplacementMap _replacementMap;
    private Serializable _gdata;
    private Map<Object, LinkedList<IndexedObject>> _index = new HashMap<Object, LinkedList<IndexedObject>>();

    public ExecutionQueueImpl(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    @Override
    public void setReplacementMap(ReplacementMap replacementMap) {
        this._replacementMap = replacementMap;
    }

    public Map<Object, LinkedList<IndexedObject>> getIndex() {
        return this._index;
    }

    @Override
    public void add(CommChannel channel) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"add", (Object[])new Object[]{"channel", channel}));
        }
        this.verifyNew(channel);
        ChannelFrame cframe = new ChannelFrame(channel.getType(), ++this._objIdCounter, channel.getType().getName(), channel.getDescription());
        this._channels.put(cframe.getId(), cframe);
        this.assignId(channel, cframe.getId());
    }

    @Override
    public void enqueueReaction(Continuation continuation) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"enqueueReaction", (Object[])new Object[]{"continuation", continuation}));
        }
        this.verifyNew(continuation);
        this._reactions.add(continuation);
    }

    @Override
    public Continuation dequeueReaction() {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"dequeueReaction", (Object[])CollectionUtils.EMPTY_OBJECT_ARRAY));
        }
        Continuation continuation = null;
        if (!this._reactions.isEmpty()) {
            Iterator<Continuation> it = this._reactions.iterator();
            continuation = it.next();
            it.remove();
        }
        return continuation;
    }

    @Override
    public void add(CommGroup group) {
        Comm comm;
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"add", (Object[])new Object[]{"group", group}));
        }
        this.verifyNew(group);
        CommGroupFrame commGroupFrame = new CommGroupFrame(group.isReplicated());
        Iterator<Comm> i = group.getElements();
        while (i.hasNext()) {
            comm = i.next();
            ChannelFrame chnlFrame = this.findChannelFrame(comm.getChannel().getId());
            if (comm instanceof CommSend) {
                if (chnlFrame.replicatedSend) {
                    throw new IllegalStateException("Send attempted on channel containing replicated send! Channel= " + comm.getChannel());
                }
                if (group.isReplicated()) {
                    chnlFrame.replicatedSend = true;
                }
                CommSend commSend = (CommSend)comm;
                MessageFrame mframe = new MessageFrame(commGroupFrame, chnlFrame, commSend.getMethod().getName(), commSend.getArgs());
                commGroupFrame.commFrames.add(mframe);
                chnlFrame.msgFrames.add(mframe);
                continue;
            }
            if (!(comm instanceof CommRecv)) continue;
            if (chnlFrame.replicatedRecv) {
                throw new IllegalStateException("Receive attempted on channel containing replicated receive! Channel= " + comm.getChannel());
            }
            if (group.isReplicated()) {
                chnlFrame.replicatedRecv = true;
            }
            CommRecv commRecv = (CommRecv)comm;
            ObjectFrame oframe = new ObjectFrame(commGroupFrame, chnlFrame, commRecv.getContinuation());
            commGroupFrame.commFrames.add(oframe);
            chnlFrame.objFrames.add(oframe);
        }
        i = group.getElements();
        while (i.hasNext()) {
            comm = i.next();
            this.matchCommunications(comm.getChannel());
        }
    }

    private ChannelFrame findChannelFrame(Object id) {
        ChannelFrame chnlFrame = this._channels.get(id);
        if (chnlFrame == null) {
            throw new IllegalArgumentException("No such channel; id=" + id);
        }
        return chnlFrame;
    }

    @Override
    public int cycle() {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"cycle", (Object[])CollectionUtils.EMPTY_OBJECT_ARRAY));
        }
        return ++this._currentCycle;
    }

    @Override
    public String createExport(CommChannel channel) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"createExport", (Object[])new Object[]{"channel", channel}));
        }
        ChannelFrame cframe = this.findChannelFrame(channel.getId());
        ++cframe.refCount;
        return channel.getId().toString();
    }

    @Override
    public CommChannel consumeExport(String exportId) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"consumeExport", (Object[])new Object[]{"exportId", exportId}));
        }
        Integer id = Integer.valueOf(exportId);
        ChannelFrame cframe = this.findChannelFrame(id);
        --cframe.refCount;
        CommChannel commChannel = new CommChannel(cframe.type);
        commChannel.setId(id);
        commChannel.setDescription("EXPORTED CHANNEL");
        return commChannel;
    }

    @Override
    public boolean hasReactions() {
        return !this._reactions.isEmpty();
    }

    @Override
    public void flush() {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"flush", (Object[])CollectionUtils.EMPTY_OBJECT_ARRAY));
        }
    }

    public void read(InputStream iis) throws IOException, ClassNotFoundException {
        int i;
        this._channels.clear();
        this._reactions.clear();
        this._index.clear();
        ExecutionQueueInputStream sis = new ExecutionQueueInputStream(iis);
        this._objIdCounter = sis.readInt();
        this._currentCycle = sis.readInt();
        int reactions = sis.readInt();
        for (int i2 = 0; i2 < reactions; ++i2) {
            JacobObject closure = (JacobObject)sis.readObject();
            String methodName = sis.readUTF();
            Method method = closure.getMethod(methodName);
            int numArgs = sis.readInt();
            Object[] args = new Object[numArgs];
            for (int j = 0; j < numArgs; ++j) {
                args[j] = sis.readObject();
            }
            this._reactions.add(new Continuation(closure, method, args));
        }
        int numChannels = sis.readInt();
        for (i = 0; i < numChannels; ++i) {
            int objFrames = sis.readInt();
            for (int j = 0; j < objFrames; ++j) {
                sis.readObject();
            }
            int msgFrames = sis.readInt();
            for (int j = 0; j < msgFrames; ++j) {
                sis.readObject();
            }
        }
        numChannels = sis.readInt();
        for (i = 0; i < numChannels; ++i) {
            ChannelFrame cframe = (ChannelFrame)sis.readObject();
            this._channels.put(cframe.getId(), cframe);
        }
        this._gdata = (Serializable)sis.readObject();
        sis.close();
    }

    private void index(IndexedObject object) {
        LinkedList<IndexedObject> vals = this._index.get(object.getKey());
        if (vals == null) {
            vals = new LinkedList();
            this._index.put(object.getKey(), vals);
        }
        vals.add(object);
    }

    public void write(OutputStream oos) throws IOException {
        this.flush();
        ExecutionQueueOutputStream sos = new ExecutionQueueOutputStream(oos);
        sos.writeInt(this._objIdCounter);
        sos.writeInt(this._currentCycle);
        sos.writeInt(this._reactions.size());
        for (Continuation c : this._reactions) {
            sos.writeObject(c.getClosure());
            sos.writeUTF(c.getMethod().getName());
            sos.writeInt(c.getArgs() == null ? 0 : c.getArgs().length);
            for (int j = 0; c.getArgs() != null && j < c.getArgs().length; ++j) {
                sos.writeObject(c.getArgs()[j]);
            }
        }
        sos.writeInt(this._channels.values().size());
        for (ChannelFrame cframe : this._channels.values()) {
            sos.writeInt(cframe.objFrames.size());
            Iterator<CommFrame> j = cframe.objFrames.iterator();
            while (j.hasNext()) {
                sos.writeObject(j.next());
            }
            sos.writeInt(cframe.msgFrames.size());
            j = cframe.msgFrames.iterator();
            while (j.hasNext()) {
                sos.writeObject(j.next());
            }
        }
        Set<Object> referencedChannels = sos.getSerializedChannels();
        Iterator<ChannelFrame> i = this._channels.values().iterator();
        while (i.hasNext()) {
            ChannelFrame cframe = i.next();
            if (referencedChannels.contains(cframe.id) || cframe.refCount > 0) continue;
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("GC Channel: " + cframe));
            }
            i.remove();
        }
        sos.writeInt(this._channels.values().size());
        for (ChannelFrame cframe : this._channels.values()) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Writing Channel: " + cframe));
            }
            sos.writeObject(cframe);
        }
        sos.writeObject(this._gdata);
        sos.close();
    }

    @Override
    public boolean isComplete() {
        if (!this._reactions.isEmpty()) {
            return false;
        }
        Iterator<ChannelFrame> i = this._channels.values().iterator();
        while (i.hasNext()) {
            if (i.next().refCount <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void dumpState(PrintStream ps) {
        ps.print(this.toString());
        ps.println(" state dump:");
        ps.println("-- GENERAL INFO");
        ps.println("   Current Cycle          : " + this._currentCycle);
        ps.println("   Num. Reactions  : " + this._reactions.size());
        this._statistics.printStatistics(ps);
        if (!this._reactions.isEmpty()) {
            ps.println("-- REACTIONS");
            int cnt = 0;
            for (Continuation continuation : this._reactions) {
                ps.println("   #" + ++cnt + ":  " + continuation.toString());
            }
        }
    }

    private void matchCommunications(CommChannel channel) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"matchCommunications", (Object[])new Object[]{"channel", channel}));
        }
        ChannelFrame cframe = this._channels.get(channel.getId());
        while (cframe != null && !cframe.msgFrames.isEmpty() && !cframe.objFrames.isEmpty()) {
            MessageFrame mframe = cframe.msgFrames.iterator().next();
            ObjectFrame oframe = cframe.objFrames.iterator().next();
            Continuation continuation = new Continuation(oframe._continuation, oframe._continuation.getMethod(mframe.method), mframe.args);
            if (__log.isInfoEnabled()) {
                continuation.setDescription(channel + " ? {...} | " + channel + " ! " + mframe.method + "(...)");
            }
            this.enqueueReaction(continuation);
            if (!mframe.commGroupFrame.replicated) {
                this.removeCommGroup(mframe.commGroupFrame);
            }
            if (oframe.commGroupFrame.replicated) continue;
            this.removeCommGroup(oframe.commGroupFrame);
        }
    }

    private void verifyNew(ExecutionQueueObject so) throws IllegalArgumentException {
        if (so.getId() != null) {
            throw new IllegalArgumentException("The object " + so + " is not new!");
        }
    }

    private void assignId(ExecutionQueueObject so, Object id) {
        so.setId(id);
    }

    private void removeCommGroup(CommGroupFrame groupFrame) {
        for (CommFrame frame : groupFrame.commFrames) {
            if (frame instanceof ObjectFrame) {
                assert (frame.channelFrame.objFrames.contains(frame));
                frame.channelFrame.objFrames.remove(frame);
                continue;
            }
            assert (frame instanceof MessageFrame);
            assert (frame.channelFrame.msgFrames.contains(frame));
            frame.channelFrame.msgFrames.remove(frame);
        }
    }

    public void setGlobalData(Serializable data) {
        this._gdata = data;
    }

    public Serializable getGlobalData() {
        return this._gdata;
    }

    private static final class ExecutionQueueStatistics {
        public long cloneClosureTimeMs;
        public long cloneClosureBytes;
        public long cloneClousreCount;
        public long cloneClosureReadTimeMs;

        private ExecutionQueueStatistics() {
        }

        public void printStatistics(PrintStream ps) {
            Field[] fields = this.getClass().getFields();
            for (int i = 0; i < fields.length; ++i) {
                ps.print(fields[i].getName());
                ps.print(" = ");
                try {
                    ps.println(fields[i].get(this));
                    continue;
                }
                catch (Exception ex) {
                    ps.println(ex.toString());
                }
            }
        }
    }

    private static final class ChannelRef
    implements Externalizable {
        private Class _type;
        private Integer _id;

        private ChannelRef(Class type, Integer id) {
            this._type = type;
            this._id = id;
        }

        public ChannelRef() {
        }

        public boolean equals(Object obj) {
            return ((ChannelRef)obj)._id.equals(this._id);
        }

        public int hashCode() {
            return this._id.hashCode();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this._type);
            out.writeInt(this._id);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this._type = (Class)in.readObject();
            this._id = in.readInt();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExecutionQueueInputStream
    extends ObjectInputStream {
        private Set<CommChannel> _deserializedChannels;

        public ExecutionQueueInputStream(InputStream in) throws IOException {
            super(new GZIPInputStream(in));
            this._deserializedChannels = new HashSet<CommChannel>();
            this.enableResolveObject(true);
        }

        public Set<CommChannel> getSerializedChannels() {
            return this._deserializedChannels;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            return Class.forName(desc.getName(), true, ExecutionQueueImpl.this._classLoader);
        }

        @Override
        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            boolean ser = this.readBoolean();
            if (ser) {
                String clsName = this.readUTF();
                ObjectStreamClass cached = _classDescriptors.get(clsName);
                if (cached == null) {
                    cached = ObjectStreamClass.lookup(Class.forName(clsName, true, ExecutionQueueImpl.this._classLoader));
                    _classDescriptors.put(clsName, cached);
                }
                return cached;
            }
            return super.readClassDescriptor();
        }

        @Override
        protected Object resolveObject(Object obj) throws IOException {
            Object resolved;
            if (obj instanceof ChannelRef) {
                ChannelRef oref = (ChannelRef)obj;
                CommChannel channel = new CommChannel(oref._type);
                channel.setId(oref._id);
                this._deserializedChannels.add(channel);
                resolved = ChannelFactory.createChannel(channel, channel.getType());
            } else if (ExecutionQueueImpl.this._replacementMap != null && ExecutionQueueImpl.this._replacementMap.isReplacement(obj)) {
                resolved = ExecutionQueueImpl.this._replacementMap.getOriginal(obj);
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("ReplacementMap: getOriginal(" + obj + ") = " + resolved));
                }
            } else {
                resolved = obj;
            }
            if (resolved != null && resolved instanceof IndexedObject) {
                ExecutionQueueImpl.this.index((IndexedObject)resolved);
            }
            return resolved;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExecutionQueueOutputStream
    extends ObjectOutputStream {
        private Set<Object> _serializedChannels;

        public ExecutionQueueOutputStream(OutputStream outputStream) throws IOException {
            super(new GZIPOutputStream(outputStream));
            this._serializedChannels = new HashSet<Object>();
            this.enableReplaceObject(true);
        }

        public Set<Object> getSerializedChannels() {
            return this._serializedChannels;
        }

        @Override
        protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
            if (Serializable.class.isAssignableFrom(desc.forClass())) {
                this.writeBoolean(true);
                this.writeUTF(desc.getName());
            } else {
                this.writeBoolean(false);
                super.writeClassDescriptor(desc);
            }
        }

        @Override
        protected Object replaceObject(Object obj) throws IOException {
            if (!Serializable.class.isAssignableFrom(obj.getClass())) {
                return null;
            }
            if (obj instanceof Channel) {
                CommChannel commChannel = (CommChannel)ChannelFactory.getBackend((Channel)obj);
                this._serializedChannels.add(commChannel.getId());
                return new ChannelRef(commChannel.getType(), (Integer)commChannel.getId());
            }
            if (ExecutionQueueImpl.this._replacementMap != null && ExecutionQueueImpl.this._replacementMap.isReplaceable(obj)) {
                Object replacement = ExecutionQueueImpl.this._replacementMap.getReplacement(obj);
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("ReplacmentMap: getReplacement(" + obj + ") = " + replacement));
                }
                return replacement;
            }
            return obj;
        }
    }

    private static class MessageFrame
    extends CommFrame
    implements Externalizable {
        private static final long serialVersionUID = -1112437852498126297L;
        String method;
        Object[] args;

        public MessageFrame() {
        }

        public MessageFrame(CommGroupFrame commFrame, ChannelFrame channelFrame, String method, Object[] args) {
            super(commFrame, channelFrame);
            this.method = method;
            this.args = args == null ? CollectionUtils.EMPTY_CLASS_ARRAY : args;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.method = in.readUTF();
            int numArgs = in.readInt();
            this.args = new Object[numArgs];
            for (int i = 0; i < numArgs; ++i) {
                this.args[i] = in.readObject();
            }
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeUTF(this.method);
            out.writeInt(this.args.length);
            for (int i = 0; i < this.args.length; ++i) {
                out.writeObject(this.args[i]);
            }
        }
    }

    private static class ObjectFrame
    extends CommFrame
    implements Externalizable {
        private static final long serialVersionUID = -7212430608484116919L;
        ChannelListener _continuation;

        public ObjectFrame() {
        }

        public ObjectFrame(CommGroupFrame commGroupFrame, ChannelFrame channelFrame, ChannelListener continuation) {
            super(commGroupFrame, channelFrame);
            this._continuation = continuation;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this._continuation = (ChannelListener)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeObject(this._continuation);
        }
    }

    private static class CommFrame
    implements Externalizable {
        CommGroupFrame commGroupFrame;
        ChannelFrame channelFrame;

        public CommFrame() {
        }

        CommFrame(CommGroupFrame commGroupFrame, ChannelFrame channelFrame) {
            this.commGroupFrame = commGroupFrame;
            this.channelFrame = channelFrame;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.commGroupFrame = (CommGroupFrame)in.readObject();
            this.channelFrame = (ChannelFrame)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.commGroupFrame);
            out.writeObject(this.channelFrame);
        }
    }

    private static class CommGroupFrame
    implements Serializable {
        boolean replicated;
        public Set<CommFrame> commFrames = new HashSet<CommFrame>();

        public CommGroupFrame(boolean replicated) {
            this.replicated = replicated;
        }
    }

    private static class ChannelFrame
    implements Externalizable {
        Class type;
        int id;
        int refCount;
        boolean replicatedSend;
        boolean replicatedRecv;
        Set<ObjectFrame> objFrames = new HashSet<ObjectFrame>();
        Set<MessageFrame> msgFrames = new HashSet<MessageFrame>();
        public String description;

        public ChannelFrame() {
        }

        public ChannelFrame(Class type, int id, String name, String description) {
            this.type = type;
            this.id = id;
            this.description = description;
        }

        public Integer getId() {
            return this.id;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int i;
            this.type = (Class)in.readObject();
            this.id = in.readInt();
            this.description = in.readUTF();
            this.refCount = in.readInt();
            this.replicatedSend = in.readBoolean();
            this.replicatedRecv = in.readBoolean();
            int cnt = in.readInt();
            for (i = 0; i < cnt; ++i) {
                this.objFrames.add((ObjectFrame)in.readObject());
            }
            cnt = in.readInt();
            for (i = 0; i < cnt; ++i) {
                this.msgFrames.add((MessageFrame)in.readObject());
            }
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.type);
            out.writeInt(this.id);
            out.writeUTF(this.description == null ? "" : this.description);
            out.writeInt(this.refCount);
            out.writeBoolean(this.replicatedSend);
            out.writeBoolean(this.replicatedRecv);
            out.writeInt(this.objFrames.size());
            Iterator<CommFrame> i = this.objFrames.iterator();
            while (i.hasNext()) {
                out.writeObject(i.next());
            }
            out.writeInt(this.msgFrames.size());
            i = this.msgFrames.iterator();
            while (i.hasNext()) {
                out.writeObject(i.next());
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(32);
            buf.append("{CFRAME ");
            buf.append(this.type.getSimpleName());
            buf.append(':');
            buf.append(this.description);
            buf.append('#');
            buf.append(this.id);
            buf.append(" refCount=");
            buf.append(this.refCount);
            buf.append(", msgs=");
            buf.append(this.msgFrames.size());
            if (this.replicatedSend) {
                buf.append("R");
            }
            buf.append(", objs=");
            buf.append(this.objFrames.size());
            if (this.replicatedRecv) {
                buf.append("R");
            }
            buf.append("}");
            return buf.toString();
        }
    }
}

