/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.ra;

import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.apache.ode.ra.ConnectionEventListenerSupport;
import org.apache.ode.ra.OdeConnectionImpl;
import org.apache.ode.ra.transports.OdeTransportPipe;

class OdeManagedConnectionImpl
implements ManagedConnection {
    private final List<OdeConnectionImpl> _connections = new ArrayList<OdeConnectionImpl>();
    private final ConnectionEventListenerSupport _eventListenerSupport = new ConnectionEventListenerSupport();
    private OdeConnectionImpl _activeConnection;
    private PrintWriter _logWriter;
    private OdeTransportPipe _transportPipe;
    private Class<?>[] _connectionClasses;

    OdeManagedConnectionImpl() {
    }

    public OdeManagedConnectionImpl(OdeTransportPipe pipe, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        String[] classNames;
        this._transportPipe = pipe;
        try {
            classNames = this._transportPipe.getConnectionClassNames();
        }
        catch (RemoteException e1) {
            throw new ResourceException("Unable to obtain interface names from server.", (Throwable)e1);
        }
        this._connectionClasses = new Class[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            try {
                this._connectionClasses[i] = Class.forName(classNames[i]);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new ResourceException("Connection class " + classNames[i] + " could not be found in classpath.");
            }
        }
    }

    public void associateConnection(Object o) throws ResourceException {
        if (this._activeConnection != null) {
            this._activeConnection.associate(null);
        }
        this._activeConnection = null;
        this._activeConnection = (OdeConnectionImpl)o;
        this._activeConnection.associate(this);
    }

    public void cleanup() throws ResourceException {
        if (this._activeConnection != null) {
            this._activeConnection.associate(null);
        }
        this._activeConnection = null;
        this._connections.clear();
    }

    public void destroy() throws ResourceException {
        this.cleanup();
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        OdeConnectionImpl conn = new OdeConnectionImpl(subject, connectionRequestInfo);
        this._connections.add(conn);
        this._activeConnection = conn;
        conn.associate(this);
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), this._connectionClasses, (InvocationHandler)conn);
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new ResourceException("Not supported.");
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        throw new ResourceException("Not supported.");
    }

    public XAResource getXAResource() throws ResourceException {
        throw new ResourceException("Not supported.");
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this._eventListenerSupport.addListener(connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this._eventListenerSupport.removeListener(connectionEventListener);
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this._logWriter;
    }

    public void setLogWriter(PrintWriter logWriter) throws ResourceException {
        this._logWriter = logWriter;
    }

    void connectionClosed(OdeConnectionImpl odeConnection) {
        this._eventListenerSupport.connectionClosed(new ConnectionEvent((ManagedConnection)this, 1));
    }

    OdeTransportPipe getTransport() {
        return this._transportPipe;
    }
}

