/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.ra;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashSet;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.LocalTransaction;
import javax.resource.cci.ResultSetInfo;
import javax.resource.spi.ConnectionRequestInfo;
import javax.security.auth.Subject;
import org.apache.ode.ra.OdeConnectionException;
import org.apache.ode.ra.OdeManagedConnectionImpl;
import org.apache.ode.utils.ObjectPrinter;
import org.apache.ode.utils.Reflect;

class OdeConnectionImpl
implements InvocationHandler,
Connection {
    private OdeManagedConnectionImpl _managedConnection;
    private HashSet<Method> _myMethods = new HashSet();

    public OdeConnectionImpl(Subject subject, ConnectionRequestInfo connectionRequestInfo) {
        for (Method m : Connection.class.getMethods()) {
            this._myMethods.add(m);
        }
    }

    public void close() throws ResourceException {
        this.mc().connectionClosed(this);
    }

    public Interaction createInteraction() throws ResourceException {
        throw new ResourceException("Unsupported.");
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new ResourceException("Unsupported.");
    }

    public ConnectionMetaData getMetaData() throws ResourceException {
        throw new ResourceException("Unsupported.");
    }

    public ResultSetInfo getResultSetInfo() throws ResourceException {
        throw new ResourceException("Unsupported.");
    }

    void associate(OdeManagedConnectionImpl mconn) {
        this._managedConnection = mconn;
    }

    private final OdeManagedConnectionImpl mc() throws ResourceException {
        if (this._managedConnection == null) {
            throw new OdeConnectionException("Not connected.");
        }
        return this._managedConnection;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this._myMethods.contains(method)) {
            try {
                return method.invoke((Object)this, args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
        }
        try {
            String methodSig = Reflect.generateMethodSignature((Method)method);
            return this.mc().getTransport().invokeConnectionMethod(methodSig, args);
        }
        catch (RuntimeException pe) {
            pe.printStackTrace();
            throw new OdeConnectionException("Unexpected RuntimeException", pe);
        }
        catch (RemoteException re) {
            re.printStackTrace();
            throw new OdeConnectionException("Unexpected RemoteException.", re);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    public String toString() {
        return ObjectPrinter.toString((Object)this, (Object[])new Object[0]);
    }
}

