/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.ra;

import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import org.apache.ode.ra.OdeConnectionFactoryImpl;
import org.apache.ode.ra.OdeConnectionManager;
import org.apache.ode.ra.OdeConnectionRequestInfo;
import org.apache.ode.ra.OdeManagedConnectionImpl;
import org.apache.ode.ra.transports.OdeTransport;
import org.apache.ode.ra.transports.rmi.RMITransport;

public class OdeManagedConnectionFactory
implements ManagedConnectionFactory {
    private static final long serialVersionUID = 1L;
    private PrintWriter _logWriter;
    private OdeConnectionRequestInfo _defaultCRI = new OdeConnectionRequestInfo(null, "");

    public OdeManagedConnectionFactory() {
        try {
            this.setTransport(RMITransport.class.getName());
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
    }

    public void setTransport(String transportClassName) throws ResourceException {
        try {
            Class<?> tclass = Class.forName(transportClassName);
            this._defaultCRI.transport = (OdeTransport)tclass.newInstance();
        }
        catch (IllegalAccessException e) {
            ResourceException re = new ResourceException("Class-access error for transport class \"" + transportClassName + "\". ", (Throwable)e);
            throw re;
        }
        catch (InstantiationException e) {
            ResourceException re = new ResourceException("Error instantiating transport class \"" + transportClassName + "\". ", (Throwable)e);
            throw re;
        }
        catch (ClassNotFoundException e) {
            ResourceException re = new ResourceException("Transport class \"" + transportClassName + "\" not found in class path. ", (Throwable)e);
            throw re;
        }
    }

    public void setURL(String url) throws ResourceException {
        this._defaultCRI.url = url;
    }

    public void setProperty(String key, String val) throws ResourceException {
        if (key.equals("URL")) {
            this.setURL(val);
        } else if (key.equals("Transport")) {
            this.setTransport(val);
        } else {
            this._defaultCRI.properties.setProperty(key, val);
        }
    }

    public Object createConnectionFactory() throws ResourceException {
        return new OdeConnectionFactoryImpl(this, new OdeConnectionManager());
    }

    public Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        return new OdeConnectionFactoryImpl(this, connectionManager);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        OdeConnectionRequestInfo cri = (OdeConnectionRequestInfo)(connectionRequestInfo != null ? connectionRequestInfo : this._defaultCRI);
        if (cri.transport == null) {
            throw new ResourceException("No transport.");
        }
        try {
            return new OdeManagedConnectionImpl(cri.transport.createPipe(cri.url, cri.properties), subject, connectionRequestInfo);
        }
        catch (RemoteException ex) {
            ResourceException re = new ResourceException("Unable to create connection: " + ex.getMessage(), (Throwable)ex);
            throw re;
        }
    }

    public ManagedConnection matchManagedConnections(Set candidates, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        return null;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this._logWriter;
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this._logWriter = printWriter;
    }
}

