/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.config.samples.standalone;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.config.ConfigProviderFactory;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.config.samples.ParentConfiguration;

public class Application {
    private static final Logger logger = LoggerFactory.getLogger(Application.class);
    private static final String FILE_FOLDER = "resources";
    private static final String FILE_NAME = "deployment.yaml";

    public static void main(String[] args) {
        Application.copyFilesToPWD();
        Path deploymentConfigPath = Paths.get(FILE_FOLDER, "conf", FILE_NAME);
        try {
            ConfigProvider configProvider = ConfigProviderFactory.getConfigProvider((Path)deploymentConfigPath);
            ParentConfiguration parentConfiguration = (ParentConfiguration)configProvider.getConfigurationObject(ParentConfiguration.class);
            logger.info("Parent configuration - {}", (Object)parentConfiguration);
        }
        catch (ConfigurationException e) {
            logger.error("Error in getting configuration", (Throwable)e);
        }
    }

    private static void copyFilesToPWD() {
        Throwable throwable;
        Path deploymentYamlPath = Paths.get("conf", FILE_NAME);
        Path masterKeysPaths = Paths.get("conf", "master-keys.yaml");
        Path secretPropertiesPath = Paths.get("conf", "secrets.properties");
        Path jksResourcePath = Paths.get("security", "wso2carbon.jks");
        try {
            Files.createDirectories(Paths.get(FILE_FOLDER, "conf"), new FileAttribute[0]);
            Files.createDirectories(Paths.get(FILE_FOLDER, "security"), new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.error("Error occurred in creating directories", (Throwable)e);
        }
        if (Files.notExists(Paths.get(FILE_FOLDER, deploymentYamlPath.toString()), new LinkOption[0])) {
            try {
                throwable = null;
                try (InputStream deploymentYamlInputStream = Application.getResourceInputStream(deploymentYamlPath).orElseThrow(() -> new IOException("Error in copying deployment.yaml"));){
                    Files.copy(deploymentYamlInputStream, Paths.get(FILE_FOLDER, deploymentYamlPath.toString()), new CopyOption[0]);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException e) {
                logger.error("Error occurred in copying files", (Throwable)e);
            }
        }
        if (Files.notExists(Paths.get(FILE_FOLDER, masterKeysPaths.toString()), new LinkOption[0])) {
            try {
                throwable = null;
                try (InputStream masterKeyInputStream = Application.getResourceInputStream(masterKeysPaths).orElseThrow(() -> new IOException("Error in copying master-keys.yaml"));){
                    Files.copy(masterKeyInputStream, Paths.get(FILE_FOLDER, masterKeysPaths.toString()), new CopyOption[0]);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (IOException e) {
                logger.error("Error occurred in copying files", (Throwable)e);
            }
        }
        if (Files.notExists(Paths.get(FILE_FOLDER, secretPropertiesPath.toString()), new LinkOption[0])) {
            try {
                throwable = null;
                try (InputStream secretPropertiesInputStream = Application.getResourceInputStream(secretPropertiesPath).orElseThrow(() -> new IOException("Error in copying secrets.properties"));){
                    Files.copy(secretPropertiesInputStream, Paths.get(FILE_FOLDER, secretPropertiesPath.toString()), new CopyOption[0]);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            catch (IOException e) {
                logger.error("Error occurred in copying files", (Throwable)e);
            }
        }
        if (Files.notExists(Paths.get(FILE_FOLDER, jksResourcePath.toString()), new LinkOption[0])) {
            try {
                throwable = null;
                try (InputStream jksInputStream = Application.getResourceInputStream(jksResourcePath).orElseThrow(() -> new IOException("Error in copying file wso2carbon.jks"));){
                    Files.copy(jksInputStream, Paths.get(FILE_FOLDER, jksResourcePath.toString()), new CopyOption[0]);
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            catch (IOException e) {
                logger.error("Error occurred in copying files", (Throwable)e);
            }
        }
    }

    private static Optional<InputStream> getResourceInputStream(Path resourcePaths) {
        InputStream inputStream = Application.class.getClassLoader().getResourceAsStream(resourcePaths.toString());
        return Optional.ofNullable(inputStream);
    }
}

