/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.java2wsdl;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.java2wsdl.Java2WSDLCodegenEngine;
import org.apache.ws.java2wsdl.utils.Java2WSDLCommandLineOption;
import org.apache.ws.java2wsdl.utils.Java2WSDLCommandLineOptionParser;
import org.apache.ws.java2wsdl.utils.Java2WSDLOptionsValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Java2WSDL {
    private static Log log = LogFactory.getLog(Java2WSDL.class);

    private String java2wsdl(String[] options) throws AxisFault {
        File[] files;
        String uuid = String.valueOf((double)System.currentTimeMillis() + Math.random());
        String wsdlOutputDir = MessageContext.getCurrentMessageContext().getConfigurationContext().getProperty("WORK_DIR") + File.separator + "tools_wsdlview" + File.separator + uuid + File.separator;
        ArrayList<String> optionsList = new ArrayList<String>();
        boolean isXCAvailable = false;
        String xcValue = "";
        for (String option : options) {
            if (option.equalsIgnoreCase("-xc")) {
                isXCAvailable = true;
                continue;
            }
            if (isXCAvailable) {
                xcValue = option;
                isXCAvailable = false;
                continue;
            }
            optionsList.add(option);
        }
        optionsList.add("-o");
        optionsList.add(wsdlOutputDir);
        optionsList.add("-of");
        optionsList.add(uuid + ".xml");
        this.parseXC(xcValue, optionsList);
        String[] args = optionsList.toArray(new String[optionsList.size()]);
        Java2WSDLCommandLineOptionParser commandLineOptionParser = new Java2WSDLCommandLineOptionParser(args);
        try {
            Map allOptions = commandLineOptionParser.getAllOptions();
            List list = commandLineOptionParser.getInvalidOptions(new Java2WSDLOptionsValidator());
            if (list.size() > 0) {
                String faultOptions = "";
                for (Object aList : list) {
                    Java2WSDLCommandLineOption commandLineOption = (Java2WSDLCommandLineOption)aList;
                    String optionValue = commandLineOption.getOptionValue();
                    faultOptions = faultOptions + "Invalid input for [ " + commandLineOption.getOptionType() + (optionValue != null ? " : " + optionValue + " ]" : " ]") + "\n";
                }
                log.error((Object)faultOptions);
                throw new AxisFault(faultOptions);
            }
            new Java2WSDLCodegenEngine(allOptions).generate();
        }
        catch (Exception e) {
            String rootMsg = Java2WSDL.class.getName() + " Exception has occured.";
            Throwable throwable = e.getCause();
            if (throwable != null) {
                String tmpMsg = throwable.toString();
                if (tmpMsg.indexOf("org.apache.axis2.AxisFault") > -1) {
                    tmpMsg = "Please provide the correct inputs to either -p2n or -xc";
                    log.error((Object)tmpMsg, throwable);
                    throw new AxisFault(tmpMsg);
                }
                log.error((Object)rootMsg, throwable);
                throw new AxisFault(throwable.toString());
            }
            String tmpMsg = e.toString();
            if (tmpMsg.indexOf("java.lang.StringIndexOutOfBoundsException") > -1) {
                tmpMsg = "Please provide the correct inputs to either -p2n or -xc";
                log.error((Object)tmpMsg, (Throwable)e);
                throw new AxisFault(tmpMsg);
            }
            log.error((Object)rootMsg, (Throwable)e);
            throw AxisFault.makeFault((Throwable)e);
        }
        Hashtable<String, String> fileResourcesMap = (Hashtable<String, String>)MessageContext.getCurrentMessageContext().getConfigurationContext().getProperty("file.resource.map");
        if (fileResourcesMap == null) {
            fileResourcesMap = new Hashtable<String, String>();
            MessageContext.getCurrentMessageContext().getConfigurationContext().setProperty("file.resource.map", fileResourcesMap);
        }
        if ((files = new File(wsdlOutputDir).listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.getName().endsWith(".xml");
            }
        })) != null && files[0] != null && files[0].getAbsoluteFile() != null) {
            fileResourcesMap.put(uuid, files[0].getAbsoluteFile().getAbsolutePath());
        }
        return "../../filedownload?id=" + uuid;
    }

    public String java2wsdlWithResources(String[] options, String[] uuids) throws AxisFault {
        ClassLoader prevCl = Thread.currentThread().getContextClassLoader();
        try {
            URL[] urls = new URL[uuids.length];
            for (int i = 0; i < uuids.length; ++i) {
                urls[i] = new File(uuids[i]).toURL();
            }
            URLClassLoader newCl = URLClassLoader.newInstance(urls, prevCl);
            Thread.currentThread().setContextClassLoader(newCl);
            String string = this.java2wsdl(options);
            return string;
        }
        catch (MalformedURLException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevCl);
        }
    }

    private void parseXC(String value, ArrayList<String> options) {
        String[] tokens;
        if (value == null || value.length() == 0) {
            return;
        }
        for (String token : tokens = value.split(",")) {
            if (token == null || token.length() == 0) continue;
            options.add("-xc");
            options.add(token);
        }
    }
}

