/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.localentry.service;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.wso2.carbon.localentry.LocalEntryAdminException;

public abstract class AbstractESBAdmin {
    public static final String LOGGED = "logged";

    public AxisConfiguration getAxisConfig() {
        return MessageContext.getCurrentMessageContext().getConfigurationContext().getAxisConfiguration();
    }

    public ConfigurationContext getConfigContext() {
        return MessageContext.getCurrentMessageContext().getConfigurationContext();
    }

    public SynapseConfiguration getSynapseConfiguration() throws LocalEntryAdminException {
        Parameter synapseConfigParam = this.getAxisConfig().getParameter("synapse.config");
        if (synapseConfigParam == null) {
            throw new LocalEntryAdminException("Unable to find the Synapse configuration from the loaded Axis2 configuration");
        }
        return (SynapseConfiguration)synapseConfigParam.getValue();
    }

    public SynapseEnvironment getSynapseEnvironment() throws LocalEntryAdminException {
        Parameter synapseEnvParam = this.getAxisConfig().getParameter("synapse.env");
        if (synapseEnvParam == null) {
            throw new LocalEntryAdminException("Unable to find the Synapse Environment from the loaded Axis2 configuration");
        }
        return (SynapseEnvironment)synapseEnvParam.getValue();
    }

    protected void handleFault(Log log, String message, Exception e) throws LocalEntryAdminException {
        if (e == null) {
            AxisFault af = new AxisFault(message);
            log.error((Object)message, (Throwable)af);
            throw new LocalEntryAdminException(message, e);
        }
        message = message + " :: " + e.getMessage();
        log.error((Object)message, (Throwable)e);
        throw new LocalEntryAdminException(message, e);
    }

    protected void handleException(Log log, String message, Exception e) throws LocalEntryAdminException {
        log.error((Object)message, (Throwable)e);
        throw new LocalEntryAdminException(message, e);
    }
}

