/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.localentry.service;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.llom.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.EntrySerializer;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.wso2.carbon.localentry.LocalEntryAdminException;
import org.wso2.carbon.localentry.dos.EntryData;
import org.wso2.carbon.localentry.service.AbstractESBAdmin;

public class LocalEntryAdmin
extends AbstractESBAdmin {
    private static final Log log = LogFactory.getLog(LocalEntryAdmin.class);

    public EntryData[] entryData() throws LocalEntryAdminException {
        SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
        Map gloabalEntiesMap = synapseConfiguration.getDefinedEntries();
        ArrayList<EntryData> globalEntryList = new ArrayList<EntryData>();
        Iterator ite = gloabalEntiesMap.entrySet().iterator();
        while (ite.hasNext()) {
            String s;
            EntryData data = new EntryData();
            Map.Entry entry = ite.next();
            String key = (String)entry.getKey();
            if (SynapseConstants.SERVER_IP.equals(key) || SynapseConstants.SERVER_HOST.equals(key) || !(entry.getValue() instanceof Entry)) continue;
            Entry value = (Entry)entry.getValue();
            data.setName(key);
            switch (value.getType()) {
                case 3: {
                    data.setType("Registry Key");
                    break;
                }
                case 0: {
                    data.setType("Inline Text");
                    break;
                }
                case 1: {
                    data.setType("Inline XML");
                    break;
                }
                case 2: {
                    data.setType("Source URL");
                    break;
                }
                default: {
                    data.setType("Unknown");
                }
            }
            if (value.getValue() instanceof String) {
                s = (String)value.getValue();
                data.setValue(s);
            } else if (value.getType() == 2) {
                s = value.getSrc().toString();
                data.setValue(s);
            } else if (value.getType() == 3) {
                data.setValue(value.getKey());
            } else {
                data.setValue(value.getValue().toString());
            }
            globalEntryList.add(data);
        }
        Collections.sort(globalEntryList, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((EntryData)o1).getName().compareToIgnoreCase(((EntryData)o2).getName());
            }
        });
        return globalEntryList.toArray(new EntryData[globalEntryList.size()]);
    }

    public boolean addEntry(String ele) throws LocalEntryAdminException {
        try {
            OMElement elem = null;
            try {
                elem = AXIOMUtil.stringToOM((String)ele);
            }
            catch (XMLStreamException e) {
                return false;
            }
            if (elem.getQName().getLocalPart().equals(XMLConfigConstants.ENTRY_ELT.getLocalPart())) {
                String entryName = elem.getAttributeValue(new QName("name"));
                this.assertNameEmpty(entryName);
                entryName = entryName.trim();
                log.debug((Object)("Adding local entry with name : " + entryName));
                if (this.getSynapseConfiguration().getLocalRegistry().containsKey(entryName)) {
                    this.handleFault(log, "The name " + entryName + " is already used within the configuration", null);
                } else {
                    OMAttribute name = elem.getAttribute(new QName("", "name"));
                    if (name == null) {
                        this.handleFault(log, "Unable to add local entry. Cannot find the name", null);
                    } else {
                        Entry entry = new Entry();
                        entry.setKey(name.getAttributeValue());
                        String value = elem.getAttributeValue(new QName("", "value"));
                        String src = elem.getAttributeValue(new QName("", "src"));
                        String key = elem.getAttributeValue(new QName("", "key"));
                        int type = Integer.parseInt(elem.getAttributeValue(new QName("", "type")));
                        OMElement content = elem.getFirstElement();
                        if (type == 2) {
                            entry.setType(2);
                            try {
                                entry.setSrc(new URL(src));
                            }
                            catch (MalformedURLException e) {
                                this.handleFault(log, "Invalid URL : " + src + "", e);
                            }
                        } else if (type == 3) {
                            entry.setType(3);
                            entry.setKey(key);
                        } else if (type == 1) {
                            entry.setType(1);
                            entry.setValue((Object)content);
                        } else if (type == 0) {
                            entry.setType(0);
                            entry.setValue((Object)elem.getText());
                        } else {
                            this.handleFault(log, "Unable to add local entry. Invalid definition", null);
                        }
                        this.getSynapseConfiguration().addEntry(entryName, entry);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Local registry entry : " + entryName + " added to the configuration"));
                }
                return true;
            }
            this.handleFault(log, "Error adding local entry. Invalid definition", null);
        }
        catch (SynapseException syne) {
            this.handleFault(log, "Unable to add local entry ", (Exception)((Object)syne));
        }
        catch (OMException e) {
            this.handleException(log, "Unable to add local entry. Invalid XML ", (Exception)((Object)e));
        }
        return false;
    }

    public boolean saveEntry(String ele) throws LocalEntryAdminException {
        try {
            OMElement elem = null;
            try {
                elem = AXIOMUtil.stringToOM((String)ele);
            }
            catch (XMLStreamException e) {
                return false;
            }
            Entry entry = new Entry();
            if (elem == null) {
                this.handleFault(log, "Unable to save local entry. Null definition", null);
            }
            OMAttribute name = elem.getAttribute(new QName("", "name"));
            String nameValue = null;
            if (name != null && name.getAttributeValue() != null) {
                nameValue = name.getAttributeValue().trim();
            }
            if (nameValue != null) {
                log.debug((Object)("Saving local entry with name : " + nameValue));
                nameValue = nameValue.trim();
                if (this.getSynapseConfiguration().getEntry(nameValue) == null) {
                    this.handleFault(log, "Unable to update local entry. Non existent", null);
                } else {
                    this.getSynapseConfiguration().removeEntry(nameValue);
                    entry.setKey(nameValue);
                    String value = elem.getAttributeValue(new QName("", "value"));
                    String src = elem.getAttributeValue(new QName("", "src"));
                    String key = elem.getAttributeValue(new QName("", "key"));
                    int type = Integer.parseInt(elem.getAttributeValue(new QName("", "type")));
                    OMElement content = elem.getFirstElement();
                    if (type == 2) {
                        entry.setType(2);
                        try {
                            entry.setSrc(new URL(src));
                        }
                        catch (MalformedURLException e) {
                            this.handleFault(log, "Invalid URL : " + src + " used in local entry definition : " + nameValue, e);
                        }
                    } else if (type == 3) {
                        entry.setType(3);
                        entry.setKey(key);
                    } else if (type == 1) {
                        entry.setType(1);
                        entry.setValue((Object)content);
                    } else if (type == 0) {
                        entry.setType(0);
                        entry.setValue((Object)elem.getText());
                    } else {
                        this.handleFault(log, "Unable to add local entry : " + nameValue + ". Unknown entry type", null);
                    }
                    this.getSynapseConfiguration().addEntry(nameValue, entry);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Added local entry : " + nameValue + " into the configuration"));
                    }
                }
            }
        }
        catch (SynapseException syne) {
            this.handleFault(log, "Unable to add local entry ", (Exception)((Object)syne));
        }
        catch (OMException e) {
            this.handleException(log, "Unable to add local entry.Invalid XML ", (Exception)((Object)e));
        }
        return true;
    }

    public OMElement getEntry(String entryName) throws LocalEntryAdminException {
        SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
        this.assertNameEmpty(entryName);
        entryName = entryName.trim();
        if (synapseConfiguration.getEntry(entryName) != null) {
            OMElement elem = EntrySerializer.serializeEntry((Entry)synapseConfiguration.getEntryDefinition(entryName), null);
            OMFactory fac = elem.getOMFactory();
            OMNamespace nullNS = fac.createOMNamespace("", "ns3");
            elem.declareNamespace(nullNS);
            if (elem.getAttribute(new QName("", "key")) != null) {
                if (elem.getAttribute(new QName("", "src")) != null) {
                    elem.addAttribute("type", Integer.toString(2), nullNS);
                } else if (elem.getFirstOMChild() instanceof OMText) {
                    elem.addAttribute("type", Integer.toString(0), nullNS);
                } else if (elem.getFirstOMChild() instanceof OMElement) {
                    elem.addAttribute("type", Integer.toString(1), nullNS);
                }
                return elem;
            }
            this.handleFault(log, "Unable to fetch local entry. Key missing", null);
        } else {
            this.handleFault(log, "Entry with the key " + entryName + " does not exist", null);
        }
        return null;
    }

    public boolean deleteEntry(String entryName) throws LocalEntryAdminException {
        try {
            this.assertNameEmpty(entryName);
            log.debug((Object)("Deleting local entry with name : " + entryName));
            entryName = entryName.trim();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            synapseConfiguration.removeEntry(entryName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleted local entry named : " + entryName));
            }
            return true;
        }
        catch (SynapseException syne) {
            this.handleFault(log, "Unable to delete the local entry : " + entryName, (Exception)((Object)syne));
            return false;
        }
    }

    public String[] getEntryNames() throws LocalEntryAdminException {
        SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
        Map gloabalEntriesMap = synapseConfiguration.getLocalRegistry();
        ArrayList<String> propKeys = new ArrayList<String>();
        for (Object entryValue : gloabalEntriesMap.values()) {
            String key;
            if (!(entryValue instanceof Entry) || SynapseConstants.SERVER_IP.equals(key = ((Entry)entryValue).getKey()) || SynapseConstants.SERVER_HOST.equals(key)) continue;
            propKeys.add(key);
        }
        return propKeys.toArray(new String[propKeys.size()]);
    }

    public String getEntryNamesString() throws LocalEntryAdminException {
        SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
        Map gloabalEntriesMap = synapseConfiguration.getLocalRegistry();
        ArrayList<String> sequenceList = new ArrayList<String>();
        ArrayList<String> endpointList = new ArrayList<String>();
        ArrayList<String> entryList = new ArrayList<String>();
        StringBuffer entrySb = new StringBuffer();
        StringBuffer endpointSb = new StringBuffer();
        StringBuffer sequenceSb = new StringBuffer();
        for (Object entryValue : gloabalEntriesMap.values()) {
            String key;
            Entry entry;
            String name;
            if (entryValue instanceof Endpoint) {
                Endpoint endpoint = (Endpoint)entryValue;
                name = endpoint.getName();
                if (name == null) continue;
                endpointList.add(name);
                continue;
            }
            if (entryValue instanceof SequenceMediator) {
                SequenceMediator sequenceMediator = (SequenceMediator)entryValue;
                name = sequenceMediator.getName();
                if (name == null) continue;
                sequenceList.add(name);
                continue;
            }
            if (!(entryValue instanceof Entry) || (entry = (Entry)entryValue).isDynamic() || entry.isRemote() || SynapseConstants.SERVER_IP.equals(key = entry.getKey()) || SynapseConstants.SERVER_HOST.equals(key)) continue;
            entryList.add(key);
        }
        if (!sequenceList.isEmpty()) {
            Collections.sort(sequenceList, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((String)o1).compareToIgnoreCase((String)o2);
                }
            });
            for (String name : sequenceList) {
                if (name == null) continue;
                sequenceSb.append("[Sequence]-" + name + " ");
            }
        }
        if (!entryList.isEmpty()) {
            Collections.sort(entryList, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((String)o1).compareToIgnoreCase((String)o2);
                }
            });
            for (String name : entryList) {
                if (name == null) continue;
                entrySb.append("[Entry]-" + name + " ");
            }
        }
        if (!endpointList.isEmpty()) {
            Collections.sort(endpointList, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((String)o1).compareToIgnoreCase((String)o2);
                }
            });
            for (String name : endpointList) {
                if (name == null) continue;
                endpointSb.append("[Enpoint]-" + name + " ");
            }
        }
        return endpointSb.toString() + entrySb.toString() + sequenceSb.toString();
    }

    private void assertNameEmpty(String entryName) throws LocalEntryAdminException {
        if (entryName == null || "".equals(entryName)) {
            this.handleFault(log, "Entry name cannot be empty", null);
        }
    }
}

