/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.clients.inbound.endpoint;

import java.rmi.RemoteException;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.inbound.stub.InboundAdminInboundManagementException;
import org.wso2.carbon.inbound.stub.InboundAdminStub;
import org.wso2.carbon.inbound.stub.types.carbon.InboundEndpointDTO;
import org.wso2.carbon.inbound.stub.types.carbon.ParameterDTO;
import org.wso2.esb.integration.common.clients.client.utils.AuthenticateStub;

public class InboundAdminClient {
    private static final Log log = LogFactory.getLog(InboundAdminClient.class);
    private final String serviceName = "InboundAdmin";
    private InboundAdminStub endpointAdminStub;

    public InboundAdminClient(String backEndUrl, String sessionCookie) throws AxisFault {
        String endPoint = backEndUrl + "InboundAdmin";
        this.endpointAdminStub = new InboundAdminStub(endPoint);
        AuthenticateStub.authenticateStub(sessionCookie, (Stub)this.endpointAdminStub);
    }

    public InboundAdminClient(String backEndUrl, String userName, String password) throws AxisFault {
        String endPoint = backEndUrl + "InboundAdmin";
        this.endpointAdminStub = new InboundAdminStub(endPoint);
        AuthenticateStub.authenticateStub(userName, password, (Stub)this.endpointAdminStub);
    }

    public InboundEndpointDTO[] getAllInboundEndpointNames() throws RemoteException, InboundAdminInboundManagementException {
        try {
            return this.endpointAdminStub.getAllInboundEndpointNames();
        }
        catch (RemoteException e) {
            throw new RemoteException("Exception occurred when get endpoint names in InboundAdminClient", e);
        }
        catch (InboundAdminInboundManagementException e) {
            throw new InboundAdminInboundManagementException("Exception occurred when get endpoint names in InboundAdminClient", (Throwable)e);
        }
    }

    public InboundEndpointDTO getInboundEndpointbyName(String endointName) throws RemoteException, InboundAdminInboundManagementException {
        try {
            return this.endpointAdminStub.getInboundEndpointbyName(endointName);
        }
        catch (RemoteException e) {
            throw new RemoteException("Exception occurred when get endpoint names in InboundAdminClient", e);
        }
        catch (InboundAdminInboundManagementException e) {
            throw new InboundAdminInboundManagementException("InboundAdminInboundManagementException occurred when getting Inbound Endpoint by name", (Throwable)e);
        }
    }

    public void addInboundEndpoint(String name, String sequence, String onError, String protocol, String classImpl, Map<String, String> paramsMap) throws RemoteException, InboundAdminInboundManagementException {
        try {
            ParameterDTO[] parameterDTOs = null;
            if (paramsMap != null) {
                parameterDTOs = new ParameterDTO[paramsMap.size()];
                int count = 0;
                for (String key : paramsMap.keySet()) {
                    parameterDTOs[count] = new ParameterDTO();
                    parameterDTOs[count].setName(key);
                    parameterDTOs[count].setValue(paramsMap.get(key));
                    ++count;
                }
            }
            this.endpointAdminStub.addInboundEndpoint(name, sequence, onError, protocol, classImpl, "false", parameterDTOs);
        }
        catch (RemoteException e) {
            throw new RemoteException("Remote Exception occurred when addInboundEndpoint" + name, e);
        }
        catch (InboundAdminInboundManagementException e) {
            throw new InboundAdminInboundManagementException("InboundAdminInboundManagementException  when add inbound endpoint " + name + " InboundAdmin Client", (Throwable)e);
        }
    }

    public void addInboundEndpoint(String element) throws RemoteException, InboundAdminInboundManagementException {
        try {
            this.endpointAdminStub.addInboundEndpointFromXMLString(element);
        }
        catch (RemoteException e) {
            throw new RemoteException("RemoteException when add inbound endpoint InboundAdmin Client", e);
        }
    }

    public void updateInboundEndpoint(String name, String sequence, String onError, String protocol, String classImpl, Map<String, String> paramsMap) throws RemoteException, InboundAdminInboundManagementException {
        try {
            ParameterDTO[] parameterDTOs = null;
            if (paramsMap != null) {
                parameterDTOs = new ParameterDTO[paramsMap.size()];
                int count = 0;
                for (String key : paramsMap.keySet()) {
                    parameterDTOs[count] = new ParameterDTO();
                    parameterDTOs[count].setName(key);
                    parameterDTOs[count].setValue(paramsMap.get(key));
                    ++count;
                }
            }
            this.endpointAdminStub.updateInboundEndpoint(name, sequence, onError, protocol, classImpl, "false", parameterDTOs);
        }
        catch (RemoteException e) {
            throw new RemoteException("RemoteException occurred when update inbound endpoint " + name + " InboundAdmin Client", e);
        }
        catch (InboundAdminInboundManagementException e) {
            throw new InboundAdminInboundManagementException("InboundAdminInboundManagementException when update inbound endpoint InboundAdmin Client", (Throwable)e);
        }
    }

    public void removeInboundEndpoint(String name) throws RemoteException, InboundAdminInboundManagementException {
        try {
            this.endpointAdminStub.removeInboundEndpoint(name);
        }
        catch (RemoteException e) {
            throw new RemoteException("RemoteException when removing inbound endpoint " + name + " InboundAdmin Client", e);
        }
        catch (InboundAdminInboundManagementException e) {
            throw new InboundAdminInboundManagementException("InboundAdminInboundManagementException when removing inbound endpoint " + name + " InboundAdmin Client", (Throwable)e);
        }
    }
}

