/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.synapse.SynapseException;
import org.awaitility.Awaitility;
import org.json.JSONObject;
import org.testng.Assert;
import org.wso2.carbon.application.mgt.synapse.stub.ExceptionException;
import org.wso2.carbon.application.mgt.synapse.stub.types.carbon.SynapseApplicationMetadata;
import org.wso2.carbon.authenticator.stub.LoginAuthenticationExceptionException;
import org.wso2.carbon.automation.engine.configurations.UrlGenerationUtil;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.DefaultInstance;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.context.beans.ContextUrls;
import org.wso2.carbon.automation.engine.context.beans.Instance;
import org.wso2.carbon.automation.engine.context.beans.Tenant;
import org.wso2.carbon.automation.engine.context.beans.User;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.endpoint.stub.types.EndpointAdminEndpointAdminException;
import org.wso2.carbon.integration.common.admin.client.CarbonAppUploaderClient;
import org.wso2.carbon.integration.common.admin.client.SecurityAdminServiceClient;
import org.wso2.carbon.integration.common.utils.LoginLogoutClient;
import org.wso2.carbon.integration.common.utils.exceptions.AutomationUtilException;
import org.wso2.carbon.localentry.stub.types.LocalEntryAdminException;
import org.wso2.carbon.mediation.library.stub.MediationLibraryAdminServiceException;
import org.wso2.carbon.mediation.library.stub.types.carbon.LibraryInfo;
import org.wso2.carbon.mediation.library.stub.upload.types.carbon.LibraryFileItem;
import org.wso2.carbon.rest.api.stub.RestApiAdminAPIException;
import org.wso2.carbon.security.mgt.stub.config.SecurityAdminServiceSecurityConfigExceptionException;
import org.wso2.carbon.sequences.stub.types.SequenceEditorException;
import org.wso2.esb.integration.common.clients.application.mgt.SynapseApplicationAdminClient;
import org.wso2.esb.integration.common.clients.mediation.SynapseConfigAdminClient;
import org.wso2.esb.integration.common.utils.ESBTestCaseUtils;
import org.wso2.esb.integration.common.utils.EndpointGenerator;
import org.wso2.esb.integration.common.utils.ServiceDeploymentUtil;
import org.wso2.esb.integration.common.utils.clients.SimpleHttpClient;
import org.wso2.esb.integration.common.utils.clients.stockquoteclient.StockQuoteClient;
import org.wso2.esb.integration.common.utils.common.TestConfigurationProvider;
import org.xml.sax.SAXException;

public abstract class ESBIntegrationTest {
    private static final String synapsePathFormBaseUri = File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "synapse-configs" + File.separator + "default" + File.separator + "synapse.xml";
    protected Log log = LogFactory.getLog(this.getClass());
    protected StockQuoteClient axis2Client;
    protected ContextUrls contextUrls = new ContextUrls();
    protected String sessionCookie;
    protected OMElement synapseConfiguration = null;
    protected ESBTestCaseUtils esbUtils;
    protected AutomationContext context;
    protected Tenant tenantInfo;
    protected User userInfo;
    protected TestUserMode userMode;
    private List<String> proxyServicesList = null;
    private List<String> sequencesList = null;
    private List<String> endpointsList = null;
    private List<String> localEntryList = null;
    private List<String> messageProcessorsList = null;
    private List<String> messageStoresList = null;
    private List<String> sequenceTemplateList = null;
    private List<String> apiList = null;
    private List<String> priorityExecutorList = null;
    private List<String[]> scheduledTaskList = null;
    private List<String> inboundEndpointList = null;
    protected static final int DEFAULT_INTERNAL_API_HTTPS_PORT = 9154;
    protected String hostName = null;
    protected int portOffset;
    protected final int DEFAULT_TIMEOUT = 60;
    protected boolean isManagementApiAvailable = false;

    protected void init(String tenantName, String userName) throws Exception {
        this.axis2Client = new StockQuoteClient();
        DefaultInstance defaultInstance = new DefaultInstance();
        String instanceName = defaultInstance.getDefaultManager("ESB");
        this.context = new AutomationContext("ESB", instanceName, tenantName, userName);
        this.contextUrls = this.context.getContextUrls();
        this.esbUtils = new ESBTestCaseUtils();
        this.tenantInfo = this.context.getContextTenant();
        this.userInfo = this.tenantInfo.getContextUser();
    }

    protected void init() throws Exception {
        this.axis2Client = new StockQuoteClient();
        this.context = new AutomationContext();
        this.contextUrls = this.context.getContextUrls();
        this.esbUtils = new ESBTestCaseUtils();
        this.hostName = UrlGenerationUtil.getManagerHost((Instance)this.context.getInstance());
        this.portOffset = Integer.parseInt(System.getProperty("port.offset"));
        this.isManagementApiAvailable = false;
    }

    protected void initLight() {
        this.hostName = "localhost";
        this.portOffset = Integer.parseInt(System.getProperty("port.offset"));
        this.isManagementApiAvailable = false;
    }

    public String getHostname() {
        return this.hostName;
    }

    public int getPortOffset() {
        return this.portOffset;
    }

    protected void cleanup() throws Exception {
    }

    protected String getMainSequenceURL() {
        String mainSequenceUrl = this.contextUrls.getServiceUrl();
        if (mainSequenceUrl.endsWith("/services")) {
            mainSequenceUrl = mainSequenceUrl.replace("/services", "");
        }
        if (!mainSequenceUrl.endsWith("/")) {
            mainSequenceUrl = mainSequenceUrl + "/";
        }
        return mainSequenceUrl;
    }

    protected String getProxyServiceURLHttp(String proxyServiceName) {
        return this.contextUrls.getServiceUrl() + "/" + proxyServiceName;
    }

    protected String getApiInvocationURL(String apiName) {
        return this.getMainSequenceURL() + apiName;
    }

    protected String getProxyServiceURLHttps(String proxyServiceName) {
        return this.contextUrls.getSecureServiceUrl() + "/" + proxyServiceName;
    }

    protected void loadSampleESBConfiguration(int sampleNo) throws Exception {
        OMElement synapseSample = this.esbUtils.loadESBSampleConfiguration(sampleNo);
        this.updateESBConfiguration(synapseSample);
    }

    protected OMElement loadSampleESBConfigurationWithoutApply(int sampleNo) throws Exception {
        return this.esbUtils.loadESBSampleConfiguration(sampleNo);
    }

    protected void loadESBConfigurationFromClasspath(String relativeFilePath) throws Exception {
    }

    protected void deleteLibrary(String fullQualifiedName) throws MediationLibraryAdminServiceException, RemoteException {
        this.esbUtils.deleteLibrary(this.contextUrls.getBackEndUrl(), this.sessionCookie, fullQualifiedName);
    }

    protected String[] getAllImports() throws RemoteException {
        return this.esbUtils.getAllImports(this.contextUrls.getBackEndUrl(), this.sessionCookie);
    }

    protected void updateESBConfiguration(OMElement synapseConfig) throws Exception {
    }

    protected void addProxyService(OMElement proxyConfig) throws Exception {
        String proxyName = proxyConfig.getAttributeValue(new QName("name"));
        if (this.esbUtils.isProxyServiceExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, proxyName)) {
            this.esbUtils.deleteProxyService(this.contextUrls.getBackEndUrl(), this.sessionCookie, proxyName);
        }
        if (this.proxyServicesList == null) {
            this.proxyServicesList = new ArrayList<String>();
        }
        this.proxyServicesList.add(proxyName);
        this.esbUtils.addProxyService(this.contextUrls.getBackEndUrl(), this.sessionCookie, this.setEndpoints(proxyConfig));
    }

    protected void addInboundEndpoint(OMElement inboundEndpoint) throws Exception {
        String inboundName = inboundEndpoint.getAttributeValue(new QName("name"));
        if (this.inboundEndpointList == null) {
            this.inboundEndpointList = new ArrayList<String>();
        }
        this.inboundEndpointList.add(inboundName);
        this.esbUtils.addInboundEndpoint(this.contextUrls.getBackEndUrl(), this.sessionCookie, inboundEndpoint);
    }

    protected boolean isInboundEndpointDeployed(OMElement inboundEndpoint) throws Exception {
        String inboundName = inboundEndpoint.getAttributeValue(new QName("name"));
        return this.esbUtils.isInboundEndpointExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, inboundName);
    }

    protected void isInboundUndeployed(String inboundEndpoint) throws Exception {
        try {
            this.esbUtils.isInboundEndpointUndeployed(this.contextUrls.getBackEndUrl(), this.sessionCookie, inboundEndpoint);
        }
        catch (Exception e) {
            throw new Exception("Error when adding InboundEndpoint", e);
        }
    }

    protected void updateInboundEndpoint(OMElement inboundEndpoint) throws Exception {
        try {
            this.esbUtils.updateInboundEndpoint(this.contextUrls.getBackEndUrl(), this.sessionCookie, inboundEndpoint);
        }
        catch (Exception e) {
            throw new Exception("Error when adding InboundEndpoint", e);
        }
    }

    protected void isProxyNotDeployed(String proxyServiceName) throws Exception {
        Assert.assertFalse((boolean)this.esbUtils.isProxyDeployed(this.contextUrls.getBackEndUrl(), this.sessionCookie, proxyServiceName), (String)"Proxy Deployment failed or time out");
    }

    private void deleteInboundEndpoints() throws Exception {
        if (this.inboundEndpointList != null) {
            for (String inboundEPName : this.inboundEndpointList) {
                try {
                    if (!this.esbUtils.isInboundEndpointExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, inboundEPName)) continue;
                    this.esbUtils.deleteInboundEndpointDeployed(this.contextUrls.getBackEndUrl(), this.sessionCookie, inboundEPName);
                }
                catch (Exception e) {
                    Assert.fail((String)("while undeploying Inbound Endpoint. " + e.getMessage()));
                }
            }
            this.inboundEndpointList.clear();
        }
    }

    protected void deleteInboundEndpoint(String name) throws Exception {
        this.esbUtils.deleteInboundEndpointDeployed(this.contextUrls.getBackEndUrl(), this.sessionCookie, name);
        Assert.assertTrue((boolean)this.esbUtils.isInboundEndpointUndeployed(this.contextUrls.getBackEndUrl(), this.sessionCookie, name), (String)"Inbound Deletion failed");
        if (this.inboundEndpointList != null && this.inboundEndpointList.contains(name)) {
            this.inboundEndpointList.remove(name);
        }
    }

    protected void deleteInboundEndpointFromName(String name) throws Exception {
        try {
            this.esbUtils.deleteInboundEndpointDeployed(this.contextUrls.getBackEndUrl(), this.sessionCookie, name);
        }
        catch (Exception e) {
            throw new Exception("Error when deleting InboundEndpoint", e);
        }
    }

    protected void isProxyDeployed(String proxyServiceName) throws Exception {
        Assert.assertTrue((boolean)this.esbUtils.isProxyDeployed(this.contextUrls.getBackEndUrl(), this.sessionCookie, proxyServiceName), (String)"Proxy Deployment failed or time out");
    }

    protected boolean isProxyDeployed(OMElement omElement) throws Exception {
        String proxyName = omElement.getAttributeValue(new QName("name"));
        return this.esbUtils.isProxyDeployed(this.contextUrls.getBackEndUrl(), this.sessionCookie, proxyName);
    }

    protected boolean isProxySuccesfullyDeployed(String proxyName) throws Exception {
        return this.esbUtils.isProxyDeployed(this.contextUrls.getBackEndUrl(), this.sessionCookie, proxyName);
    }

    protected void isEndpointDeployed(String endpointName) throws Exception {
        Assert.assertTrue((boolean)this.esbUtils.isEndpointDeployed(this.contextUrls.getBackEndUrl(), this.sessionCookie, endpointName), (String)"Endpoint Deployment failed or time out");
    }

    protected boolean isEndpointDeployed(OMElement omElement) throws Exception {
        String endpointName = omElement.getAttributeValue(new QName("name"));
        return this.esbUtils.isEndpointDeployed(this.contextUrls.getBackEndUrl(), this.sessionCookie, endpointName);
    }

    protected void isLocalEntryDeployed(String localEntryName) throws Exception {
        Assert.assertTrue((boolean)this.esbUtils.isLocalEntryDeployed(this.contextUrls.getBackEndUrl(), this.sessionCookie, "sec_policy_3"), (String)("Localentry " + localEntryName + " not found"));
    }

    protected void deleteProxyService(String proxyServiceName) throws Exception {
        if (this.esbUtils.isProxyServiceExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, proxyServiceName)) {
            this.esbUtils.deleteProxyService(this.contextUrls.getBackEndUrl(), this.sessionCookie, proxyServiceName);
            Assert.assertTrue((boolean)this.esbUtils.isProxyUnDeployed(this.contextUrls.getBackEndUrl(), this.sessionCookie, proxyServiceName), (String)"Proxy Deletion failed or time out");
        }
        if (this.proxyServicesList != null && this.proxyServicesList.contains(proxyServiceName)) {
            this.proxyServicesList.remove(proxyServiceName);
        }
    }

    protected void deleteApi(String api) throws Exception {
        if (this.esbUtils.isApiExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, api)) {
            this.esbUtils.deleteApi(this.contextUrls.getBackEndUrl(), this.sessionCookie, api);
            Assert.assertTrue((boolean)this.esbUtils.isApiUnDeployed(this.contextUrls.getBackEndUrl(), this.sessionCookie, api), (String)("Api: " + api + " Deletion failed or time out"));
        }
        if (this.apiList != null && this.apiList.contains(api)) {
            this.apiList.remove(api);
        }
    }

    protected void deleteSequence(String sequenceName) throws SequenceEditorException, RemoteException {
        if (this.esbUtils.isSequenceExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, sequenceName)) {
            this.esbUtils.deleteSequence(this.contextUrls.getBackEndUrl(), this.sessionCookie, sequenceName);
        }
        if (this.sequencesList != null && this.sequencesList.contains(sequenceName)) {
            this.sequencesList.remove(sequenceName);
        }
    }

    protected void addSequence(OMElement sequenceConfig) throws Exception {
        String sequenceName = sequenceConfig.getAttributeValue(new QName("name"));
        if (this.esbUtils.isSequenceExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, sequenceName)) {
            this.esbUtils.deleteSequence(this.contextUrls.getBackEndUrl(), this.sessionCookie, sequenceName);
        }
        this.esbUtils.addSequence(this.contextUrls.getBackEndUrl(), this.sessionCookie, this.setEndpoints(sequenceConfig));
        if (this.sequencesList == null) {
            this.sequencesList = new ArrayList<String>();
        }
        this.sequencesList.add(sequenceName);
    }

    protected boolean isSequenceDeployed(OMElement sequenceConfig) throws RemoteException, SequenceEditorException {
        String sequenceName = sequenceConfig.getAttributeValue(new QName("name"));
        return this.esbUtils.isSequenceExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, sequenceName);
    }

    protected void uploadConnector(String repoLocation, String strFileName) throws MalformedURLException, RemoteException {
        ArrayList<LibraryFileItem> uploadLibraryInfoList = new ArrayList<LibraryFileItem>();
        LibraryFileItem uploadedFileItem = new LibraryFileItem();
        uploadedFileItem.setDataHandler(new DataHandler((DataSource)new FileDataSource(new File(repoLocation + File.separator + strFileName))));
        uploadedFileItem.setFileName(strFileName);
        uploadedFileItem.setFileType("zip");
        uploadLibraryInfoList.add(uploadedFileItem);
        LibraryFileItem[] uploadServiceTypes = new LibraryFileItem[uploadLibraryInfoList.size()];
        uploadServiceTypes = uploadLibraryInfoList.toArray(uploadServiceTypes);
        this.esbUtils.uploadConnector(this.contextUrls.getBackEndUrl(), this.sessionCookie, uploadServiceTypes);
    }

    protected void updateConnectorStatus(String libQName, String libName, String packageName, String status) throws RemoteException {
        this.esbUtils.updateConnectorStatus(this.contextUrls.getBackEndUrl(), this.sessionCookie, libQName, libName, packageName, status);
    }

    protected void addImport(String libName, String packageName) throws RemoteException {
        this.esbUtils.addImport(this.contextUrls.getBackEndUrl(), this.sessionCookie, libName, packageName);
    }

    protected String getImport(String qualifiedName) throws RemoteException {
        return this.esbUtils.getImport(this.contextUrls.getBackEndUrl(), this.sessionCookie, qualifiedName);
    }

    protected LibraryInfo[] getAllLibraryInfo() throws RemoteException {
        return this.esbUtils.getAllLibraryInfo(this.contextUrls.getBackEndUrl(), this.sessionCookie);
    }

    protected String[] getAllLibraries() throws RemoteException {
        return this.esbUtils.getAllLibraries(this.contextUrls.getBackEndUrl(), this.sessionCookie);
    }

    protected void deleteImport(String importQualifiedName) throws RemoteException {
        this.esbUtils.deleteImport(this.contextUrls.getBackEndUrl(), this.sessionCookie, importQualifiedName);
    }

    protected LibraryInfo getLibraryInfo(String libName, String packageName) throws RemoteException {
        return this.esbUtils.getLibraryInfo(this.contextUrls.getBackEndUrl(), this.sessionCookie, libName, packageName);
    }

    protected DataHandler downloadLibraryArchive(String fileName) throws RemoteException, MediationLibraryAdminServiceException {
        return this.esbUtils.downloadLibraryArchive(this.contextUrls.getBackEndUrl(), this.sessionCookie, fileName);
    }

    protected void addEndpoint(OMElement endpointConfig) throws Exception {
        String endpointName = endpointConfig.getAttributeValue(new QName("name"));
        if (this.esbUtils.isSequenceExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, endpointName)) {
            this.esbUtils.deleteEndpoint(this.contextUrls.getBackEndUrl(), this.sessionCookie, endpointName);
        }
        this.esbUtils.addEndpoint(this.contextUrls.getBackEndUrl(), this.sessionCookie, this.setEndpoints(endpointConfig));
        if (this.endpointsList == null) {
            this.endpointsList = new ArrayList<String>();
        }
        this.endpointsList.add(endpointName);
    }

    protected void addLocalEntry(OMElement localEntryConfig) throws Exception {
        String localEntryName = localEntryConfig.getAttributeValue(new QName("key"));
        if (this.esbUtils.isLocalEntryExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, localEntryName)) {
            this.esbUtils.deleteLocalEntry(this.contextUrls.getBackEndUrl(), this.sessionCookie, localEntryName);
        }
        this.esbUtils.addLocalEntry(this.contextUrls.getBackEndUrl(), this.sessionCookie, localEntryConfig);
        if (this.localEntryList == null) {
            this.localEntryList = new ArrayList<String>();
        }
        this.localEntryList.add(localEntryName);
    }

    protected void addMessageProcessor(OMElement messageProcessorConfig) throws Exception {
        String messageProcessorName = messageProcessorConfig.getAttributeValue(new QName("name"));
        if (this.esbUtils.isMessageProcessorExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, messageProcessorName)) {
            this.esbUtils.deleteMessageProcessor(this.contextUrls.getBackEndUrl(), this.sessionCookie, messageProcessorName);
        }
        this.esbUtils.addMessageProcessor(this.contextUrls.getBackEndUrl(), this.sessionCookie, this.setEndpoints(messageProcessorConfig));
        if (this.messageProcessorsList == null) {
            this.messageProcessorsList = new ArrayList<String>();
        }
        this.messageProcessorsList.add(messageProcessorName);
    }

    protected void addMessageStore(OMElement messageStoreConfig) throws Exception {
        String messageStoreName = messageStoreConfig.getAttributeValue(new QName("name"));
        if (this.esbUtils.isMessageStoreExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, messageStoreName)) {
            this.esbUtils.deleteMessageStore(this.contextUrls.getBackEndUrl(), this.sessionCookie, messageStoreName);
        }
        this.esbUtils.addMessageStore(this.contextUrls.getBackEndUrl(), this.sessionCookie, this.setEndpoints(messageStoreConfig));
        if (this.messageStoresList == null) {
            this.messageStoresList = new ArrayList<String>();
        }
        this.messageStoresList.add(messageStoreName);
    }

    protected void addSequenceTemplate(OMElement sequenceTemplate) throws Exception {
        String name = sequenceTemplate.getAttributeValue(new QName("name"));
        if (this.esbUtils.isSequenceTemplateExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, name)) {
            this.esbUtils.deleteSequenceTemplate(this.contextUrls.getBackEndUrl(), this.sessionCookie, name);
        }
        this.esbUtils.addSequenceTemplate(this.contextUrls.getBackEndUrl(), this.sessionCookie, this.setEndpoints(sequenceTemplate));
        if (this.sequenceTemplateList == null) {
            this.sequenceTemplateList = new ArrayList<String>();
        }
        this.sequenceTemplateList.add(name);
    }

    protected void addApi(OMElement api) throws Exception {
        String apiName = api.getAttributeValue(new QName("name"));
        if (this.esbUtils.isApiExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, apiName)) {
            this.esbUtils.deleteApi(this.contextUrls.getBackEndUrl(), this.sessionCookie, apiName);
        }
        this.esbUtils.addAPI(this.contextUrls.getBackEndUrl(), this.sessionCookie, api);
        if (this.apiList == null) {
            this.apiList = new ArrayList<String>();
        }
        this.apiList.add(apiName);
    }

    protected void addPriorityExecutor(OMElement priorityExecutor) throws Exception {
        String executorName = priorityExecutor.getAttributeValue(new QName("name"));
        if (this.esbUtils.isPriorityExecutorExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, executorName)) {
            this.esbUtils.deletePriorityExecutor(this.contextUrls.getBackEndUrl(), this.sessionCookie, executorName);
        }
        this.esbUtils.addPriorityExecutor(this.contextUrls.getBackEndUrl(), this.sessionCookie, priorityExecutor);
        if (this.priorityExecutorList == null) {
            this.priorityExecutorList = new ArrayList<String>();
        }
        this.priorityExecutorList.add(executorName);
    }

    protected void addScheduledTask(OMElement task) throws Exception {
        String taskName = task.getAttributeValue(new QName("name"));
        String taskGroup = task.getAttributeValue(new QName("group"));
        if (this.esbUtils.isScheduleTaskExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, taskName)) {
            this.esbUtils.deleteScheduleTask(this.contextUrls.getBackEndUrl(), this.sessionCookie, taskName, taskGroup);
        }
        this.esbUtils.addScheduleTask(this.contextUrls.getBackEndUrl(), this.sessionCookie, task);
        if (this.scheduledTaskList == null) {
            this.scheduledTaskList = new ArrayList<String[]>();
        }
        this.scheduledTaskList.add(new String[]{taskName, taskGroup});
    }

    protected void applySecurity(String serviceName, int policyId, String[] userGroups) throws SecurityAdminServiceSecurityConfigExceptionException, RemoteException, InterruptedException {
        SecurityAdminServiceClient securityAdminServiceClient = new SecurityAdminServiceClient(this.contextUrls.getBackEndUrl(), this.sessionCookie);
        securityAdminServiceClient.applySecurity(serviceName, policyId + "", userGroups, new String[]{"wso2carbon.jks"}, "wso2carbon.jks");
        this.log.info((Object)("Security Scenario " + policyId + " Applied"));
        Thread.sleep(1000L);
    }

    protected void restoreSynapseConfig() throws Exception {
        String carbonHome = System.getProperty("carbon.home");
        String fullPath = carbonHome + synapsePathFormBaseUri;
        String defaultSynapseConfigPath = TestConfigurationProvider.getResourceLocation("ESB") + File.separator + "defaultconfigs" + File.separator + "synapse.xml";
        if (this.esbUtils.isFileEmpty(fullPath)) {
            try {
                this.log.info((Object)"Synapse config is empty copying Backup Config to the location.");
                ESBTestCaseUtils.copyFile(defaultSynapseConfigPath, fullPath);
            }
            catch (IOException exception) {
                throw new Exception("Exception occurred while restoring the default synapse configuration.", exception);
            }
        }
    }

    private void deleteMessageProcessors() {
        if (this.messageProcessorsList != null) {
            for (String messageProcessor : this.messageProcessorsList) {
                try {
                    if (!this.esbUtils.isMessageProcessorExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, messageProcessor)) continue;
                    this.esbUtils.deleteMessageProcessor(this.contextUrls.getBackEndUrl(), this.sessionCookie, messageProcessor);
                }
                catch (Exception e) {
                    Assert.fail((String)("while undeploying Message Processor. " + e.getMessage()));
                }
            }
            this.messageProcessorsList.clear();
        }
    }

    private void deleteMessageStores() {
        if (this.messageStoresList != null) {
            for (String messageStore : this.messageStoresList) {
                try {
                    if (!this.esbUtils.isMessageStoreExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, messageStore)) continue;
                    this.esbUtils.deleteMessageStore(this.contextUrls.getBackEndUrl(), this.sessionCookie, messageStore);
                }
                catch (Exception e) {
                    Assert.fail((String)("while undeploying Message store. " + e.getMessage()));
                }
            }
            this.messageStoresList.clear();
        }
    }

    private void deleteSequences() {
        if (this.sequencesList != null) {
            for (String sequence : this.sequencesList) {
                if (sequence.equalsIgnoreCase("fault")) continue;
                try {
                    if (!this.esbUtils.isSequenceExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, sequence)) continue;
                    this.esbUtils.deleteSequence(this.contextUrls.getBackEndUrl(), this.sessionCookie, sequence);
                }
                catch (Exception e) {
                    Assert.fail((String)("while undeploying Sequence. " + e.getMessage()));
                }
            }
            this.sequencesList.clear();
        }
    }

    private void deleteProxyServices() {
        if (this.proxyServicesList != null) {
            for (String proxyName : this.proxyServicesList) {
                try {
                    if (!this.esbUtils.isProxyServiceExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, proxyName)) continue;
                    this.esbUtils.deleteProxyService(this.contextUrls.getBackEndUrl(), this.sessionCookie, proxyName);
                }
                catch (Exception e) {
                    Assert.fail((String)("while undeploying Proxy. " + e.getMessage()));
                }
            }
            this.proxyServicesList.clear();
        }
    }

    private void deleteEndpoints() {
        if (this.endpointsList != null) {
            for (String endpoint : this.endpointsList) {
                try {
                    if (!this.esbUtils.isEndpointExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, endpoint)) continue;
                    this.esbUtils.deleteEndpoint(this.contextUrls.getBackEndUrl(), this.sessionCookie, endpoint);
                }
                catch (Exception e) {
                    Assert.fail((String)("while undeploying Endpoint. " + e.getMessage()));
                }
            }
            this.endpointsList.clear();
        }
    }

    private void deleteLocalEntries() {
        if (this.localEntryList != null) {
            for (String localEntry : this.localEntryList) {
                try {
                    if (!this.esbUtils.isLocalEntryExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, localEntry)) continue;
                    this.esbUtils.deleteLocalEntry(this.contextUrls.getBackEndUrl(), this.sessionCookie, localEntry);
                }
                catch (Exception e) {
                    Assert.fail((String)("while undeploying LocalEntry. " + e.getMessage()));
                }
            }
            this.localEntryList.clear();
        }
    }

    private void deleteSequenceTemplates() {
        if (this.sequenceTemplateList != null) {
            for (String localEntry : this.sequenceTemplateList) {
                try {
                    if (!this.esbUtils.isSequenceTemplateExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, localEntry)) continue;
                    this.esbUtils.deleteSequenceTemplate(this.contextUrls.getBackEndUrl(), this.sessionCookie, localEntry);
                }
                catch (Exception e) {
                    Assert.fail((String)("while undeploying Sequence Template. " + e.getMessage()));
                }
            }
            this.sequenceTemplateList.clear();
        }
    }

    private void deleteApi() {
        if (this.apiList != null) {
            for (String api : this.apiList) {
                try {
                    if (!this.esbUtils.isApiExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, api)) continue;
                    this.esbUtils.deleteApi(this.contextUrls.getBackEndUrl(), this.sessionCookie, api);
                }
                catch (Exception e) {
                    Assert.fail((String)("while undeploying Api. " + e.getMessage()));
                }
            }
            this.apiList.clear();
        }
    }

    private void deletePriorityExecutors() {
        if (this.priorityExecutorList != null) {
            for (String executor : this.priorityExecutorList) {
                try {
                    if (!this.esbUtils.isPriorityExecutorExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, executor)) continue;
                    this.esbUtils.deleteProxyService(this.contextUrls.getBackEndUrl(), this.sessionCookie, executor);
                }
                catch (Exception e) {
                    Assert.fail((String)("while undeploying Priority Executor. " + e.getMessage()));
                }
            }
            this.priorityExecutorList.clear();
        }
    }

    private void deleteScheduledTasks() {
        if (this.scheduledTaskList != null) {
            for (String[] executor : this.scheduledTaskList) {
                try {
                    if (!this.esbUtils.isScheduleTaskExist(this.contextUrls.getBackEndUrl(), this.sessionCookie, executor[0])) continue;
                    this.esbUtils.deleteScheduleTask(this.contextUrls.getBackEndUrl(), this.sessionCookie, executor[0], executor[1]);
                }
                catch (Exception e) {
                    Assert.fail((String)("while undeploying ScheduledTask Executor. " + e.getMessage()));
                }
            }
            this.scheduledTaskList.clear();
        }
    }

    protected void updateESBRegistry(String resourcePath) throws Exception {
        SynapseConfigAdminClient synapseConfigAdminClient = new SynapseConfigAdminClient(this.contextUrls.getBackEndUrl(), this.getSessionCookie());
        OMElement synapseConfig = AXIOMUtil.stringToOM((String)synapseConfigAdminClient.getConfiguration());
        synapseConfig.getFirstChildWithName(new QName(synapseConfig.getNamespace().getNamespaceURI(), "registry")).detach();
        synapseConfig.addChild((OMNode)this.esbUtils.loadResource(resourcePath).getFirstElement());
        synapseConfigAdminClient.updateConfiguration(synapseConfig);
        this.esbUtils.verifySynapseDeployment(synapseConfig, this.contextUrls.getBackEndUrl(), this.getSessionCookie());
        Thread.sleep(3000L);
    }

    protected boolean isRunningOnStratos() throws XPathExpressionException {
        return this.context.getConfigurationValue("//executionEnvironment").equals("platform");
    }

    protected String getESBResourceLocation() {
        return FrameworkPathUtil.getSystemResourceLocation() + "artifacts" + File.separator + "ESB";
    }

    protected String getBackEndServiceUrl(String serviceName) throws XPathExpressionException {
        return EndpointGenerator.getBackEndServiceEndpointUrl(serviceName);
    }

    protected void uploadCapp(String appname, DataHandler dataHandler) throws RemoteException {
        CarbonAppUploaderClient carbonAppUploaderClient = new CarbonAppUploaderClient(this.contextUrls.getBackEndUrl(), this.sessionCookie);
        carbonAppUploaderClient.uploadCarbonAppArtifact(appname, dataHandler);
    }

    protected SynapseApplicationMetadata getSynapseAppData(String appName) throws RemoteException, ExceptionException {
        SynapseApplicationAdminClient synapseApplicationAdminClient = new SynapseApplicationAdminClient(this.contextUrls.getBackEndUrl(), this.sessionCookie);
        return synapseApplicationAdminClient.getSynapseAppData(appName);
    }

    protected OMElement setEndpoints(OMElement synapseConfig) throws XMLStreamException, XPathExpressionException {
        if (this.isBuilderEnabled()) {
            return synapseConfig;
        }
        String config = this.replaceEndpoints(synapseConfig.toString());
        return AXIOMUtil.stringToOM((String)config);
    }

    protected DataHandler setEndpoints(DataHandler dataHandler) throws XMLStreamException, IOException, XPathExpressionException {
        if (this.isBuilderEnabled()) {
            return dataHandler;
        }
        String config = this.readInputStreamAsString(dataHandler.getInputStream());
        config = this.replaceEndpoints(config);
        ByteArrayDataSource dbs = new ByteArrayDataSource(config.getBytes());
        return new DataHandler((DataSource)dbs);
    }

    private boolean isBuilderEnabled() throws XPathExpressionException {
        return this.context.getConfigurationValue("//executionEnvironment").equals("standalone");
    }

    private boolean isClusterEnabled() throws XPathExpressionException {
        return this.context.getProductGroup().isClusterEnabled();
    }

    private String getExecutionEnvironment() throws XPathExpressionException {
        return this.context.getConfigurationValue("//executionEnvironment");
    }

    private boolean isProxyWSDlExist(String serviceUrl, long synchronizingDelay) throws Exception {
        new ServiceDeploymentUtil();
        return ServiceDeploymentUtil.isServiceWSDlExist(serviceUrl, synchronizingDelay);
    }

    private boolean isProxyWSDlNotExist(String serviceUrl, long synchronizingDelay) throws Exception {
        new ServiceDeploymentUtil();
        return ServiceDeploymentUtil.isServiceWSDlNotExist(serviceUrl, synchronizingDelay);
    }

    protected void verifyProxyServiceExistence(String proxyServiceName) throws RemoteException {
    }

    protected void verifySequenceExistence(String sequenceName) throws RemoteException, SequenceEditorException {
    }

    protected boolean checkCarbonAppExistence(String carbonAppName) throws IOException {
        String response = this.retrieveArtifactUsingManagementApi("applications");
        return response.contains(carbonAppName);
    }

    protected boolean checkApiExistence(String apiName) throws IOException {
        String response = this.retrieveArtifactUsingManagementApi("apis");
        return response.contains(apiName);
    }

    protected boolean checkEndpointExistence(String endpoinName) throws IOException {
        String response = this.retrieveArtifactUsingManagementApi("endpoints");
        return response.contains(endpoinName);
    }

    private boolean checkInboundEndpointExistence(String inboundEndpoinName) throws IOException {
        String response = this.retrieveArtifactUsingManagementApi("inbound-endpoints");
        return response.contains(inboundEndpoinName);
    }

    protected int getNoOfArtifacts(String artifactType) throws IOException {
        int count = 0;
        String response = this.retrieveArtifactUsingManagementApi(artifactType);
        JSONObject jsonObject = new JSONObject(response);
        if (jsonObject.has("count")) {
            count = jsonObject.getInt("count");
        }
        return count;
    }

    protected boolean checkProxyServiceExistence(String proxyServiceName) throws IOException {
        String response = this.retrieveArtifactUsingManagementApi("proxy-services");
        return response.contains(proxyServiceName);
    }

    private boolean checkTaskExistence(String taskName) throws IOException {
        String response = this.retrieveArtifactUsingManagementApi("tasks");
        return response.contains(taskName);
    }

    protected boolean checkSequenceExistence(String sequenceName) throws IOException {
        String response = this.retrieveArtifactUsingManagementApi("sequences");
        return response.contains(sequenceName);
    }

    protected boolean checkLocalEntryExistence(String localEntryName) throws IOException {
        String response = this.retrieveArtifactUsingManagementApi("local-entries");
        return response.contains(localEntryName);
    }

    protected boolean checkMessageStoreExistence(String messageStoreName) throws IOException {
        String response = this.retrieveArtifactUsingManagementApi("message-stores");
        return response.contains(messageStoreName);
    }

    private String retrieveArtifactUsingManagementApi(String artifactType) throws IOException {
        if (!this.isManagementApiAvailable) {
            Awaitility.await().pollInterval(50L, TimeUnit.MILLISECONDS).atMost(60L, TimeUnit.SECONDS).until(this.isManagementApiAvailable());
        }
        SimpleHttpClient client = new SimpleHttpClient();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        String endpoint = "https://" + this.hostName + ":" + (9154 + this.portOffset) + "/management/" + artifactType;
        HttpResponse response = client.doGet(endpoint, headers);
        return client.getResponsePayload(response);
    }

    public Callable<Boolean> isManagementApiAvailable() {
        return () -> {
            try (Socket s = new Socket(this.hostName, 9154 + this.portOffset);){
                this.isManagementApiAvailable = true;
                Boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                this.log.error((Object)("Error while opening socket for port " + (9154 + this.portOffset)), (Throwable)e);
                return false;
            }
        };
    }

    protected void verifyAPIExistence(String apiName) throws RestApiAdminAPIException, RemoteException {
    }

    protected void verifyEndpointExistence(String endpointName) throws EndpointAdminEndpointAdminException, RemoteException {
    }

    protected void verifyLocalEntryExistence(String localEntry) throws RemoteException, LocalEntryAdminException {
    }

    protected void verifyMessageProcessorExistence(String processorName) throws RemoteException {
    }

    protected void verifyMessageStoreExistence(String storeName) throws RemoteException {
    }

    private String replaceEndpoints(String config) throws XPathExpressionException {
        String serviceUrl = new AutomationContext("AS", TestUserMode.SUPER_TENANT_ADMIN).getContextUrls().getServiceUrl();
        config = config.replace("http://localhost:9000/services/", serviceUrl);
        config = config.replace("http://127.0.0.1:9000/services/", serviceUrl);
        return config;
    }

    protected OMElement replaceEndpoints(String relativePathToConfigFile, String serviceName, String port) throws XMLStreamException, FileNotFoundException, XPathExpressionException {
        String config = this.esbUtils.loadResource(relativePathToConfigFile).toString();
        config = config.replace("http://localhost:" + port + "/services/" + serviceName, this.getBackEndServiceUrl(serviceName));
        return AXIOMUtil.stringToOM((String)config);
    }

    private String readInputStreamAsString(InputStream in) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(in);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int result = bis.read();
        while (result != -1) {
            byte b = (byte)result;
            buf.write(b);
            result = bis.read();
        }
        return buf.toString();
    }

    protected String login(AutomationContext context) throws IOException, XPathExpressionException, URISyntaxException, SAXException, XMLStreamException, LoginAuthenticationExceptionException, AutomationUtilException {
        LoginLogoutClient loginLogoutClient = new LoginLogoutClient(context);
        return loginLogoutClient.login();
    }

    protected String getSessionCookie() {
        return this.sessionCookie;
    }

    protected String[] getUserRole() {
        return new String[]{"admin"};
    }

    protected void reloadSessionCookie() throws Exception {
    }

    public void configureHTTPWireLogs(String logLevel) {
        if (!this.isManagementApiAvailable) {
            Awaitility.await().pollInterval(50L, TimeUnit.MILLISECONDS).atMost(60L, TimeUnit.SECONDS).until(this.isManagementApiAvailable());
        }
        try {
            SimpleHttpClient client = new SimpleHttpClient();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            String endpoint = "https://" + this.hostName + ":" + (9154 + this.portOffset) + "/management/logging";
            JSONObject payload = new JSONObject();
            payload.put("loggerName", (Object)"synapse-transport-http-wire");
            payload.put("loggingLevel", (Object)logLevel);
            client.doPatch(endpoint, headers, payload.toString(), "application/json");
        }
        catch (IOException e) {
            throw new SynapseException("Error updating the log-level of synapse-transport-http-wire logger", (Throwable)e);
        }
    }
}

