/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.aws.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;
import org.wso2.aws.client.util.AWSAPIUtil;
import org.wso2.aws.client.util.GatewayUtil;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.ConfigurationDto;
import org.wso2.carbon.apimgt.api.model.Environment;
import org.wso2.carbon.apimgt.api.model.URITemplate;
import org.wso2.carbon.apimgt.impl.deployer.ExternalGatewayDeployer;
import org.wso2.carbon.apimgt.impl.deployer.exceptions.DeployerException;

@Component(name="aws.external.gateway.deployer.component", immediate=true, service={ExternalGatewayDeployer.class})
public class AWSGatewayDeployer
implements ExternalGatewayDeployer {
    private static final Log log = LogFactory.getLog(AWSAPIUtil.class);

    public String deploy(API api, Environment environment, String referenceArtifact) throws DeployerException {
        if (referenceArtifact == null) {
            return AWSAPIUtil.importRestAPI(api, environment);
        }
        return AWSAPIUtil.reimportRestAPI(referenceArtifact, api, environment);
    }

    public boolean undeploy(String apiID, String apiName, String apiVersion, String apiContext, Environment environment, String referenceArtifact) throws DeployerException {
        return AWSAPIUtil.deleteDeployment(environment, referenceArtifact);
    }

    public boolean undeployWhenRetire(API api, Environment environment, String referenceArtifact) throws DeployerException {
        return AWSAPIUtil.deleteDeployment(environment, referenceArtifact);
    }

    public List<ConfigurationDto> getConnectionConfigurations() {
        ArrayList<ConfigurationDto> configurationDtoList = new ArrayList<ConfigurationDto>();
        configurationDtoList.add(new ConfigurationDto("region", "AWS Region", "input", "AWS Region", "", true, false, Collections.emptyList(), false));
        configurationDtoList.add(new ConfigurationDto("access_key", "Access Key", "input", "AWS Access Key for Signature Authentication", "", true, true, Collections.emptyList(), false));
        configurationDtoList.add(new ConfigurationDto("secret_key", "Secret Key", "input", "AWS Secret Key for Signature Authentication", "", true, true, Collections.emptyList(), false));
        configurationDtoList.add(new ConfigurationDto("stage", "Stage Name", "input", "Default stage name", "", true, false, Collections.emptyList(), false));
        return configurationDtoList;
    }

    public String getType() {
        return "AWS";
    }

    public JsonObject getGatewayFeatureCatalog() throws DeployerException {
        JsonObject jsonObject;
        block9: {
            InputStream inputStream = AWSGatewayDeployer.class.getClassLoader().getResourceAsStream("GatewayFeatureCatalog.json");
            try {
                if (inputStream == null) {
                    throw new DeployerException("Gateway Feature Catalog JSON not found");
                }
                InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new DeployerException("Error while getting Gateway Feature Catalog", (Throwable)e);
                }
            }
            inputStream.close();
        }
        return jsonObject;
    }

    public List<String> validateApi(API api) throws DeployerException {
        ArrayList<String> errorList = new ArrayList<String>();
        try {
            errorList.add(GatewayUtil.validateAWSAPIEndpoint(GatewayUtil.getEndpointURL(api)));
            errorList.add(GatewayUtil.validateResourceContexts(api));
            return errorList.stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (DeployerException e) {
            throw new DeployerException("Error while validating API with AWS Gateway", (Throwable)e);
        }
    }

    public String getAPIExecutionURL(String url, Environment environment, String referenceArtifact) throws DeployerException {
        StringBuilder resolvedUrl = new StringBuilder(url);
        String awsAPIId = GatewayUtil.getAWSApiIdFromReferenceArtifact(referenceArtifact);
        int start = resolvedUrl.indexOf("{apiId}");
        if (start != -1) {
            resolvedUrl.replace(start, start + "{apiId}".length(), awsAPIId);
        }
        String region = (String)environment.getAdditionalProperties().get("region");
        start = resolvedUrl.indexOf("{region}");
        if (start != -1) {
            resolvedUrl.replace(start, start + "{region}".length(), region);
        }
        return resolvedUrl.toString() + "/" + (String)environment.getAdditionalProperties().get("stage");
    }

    public void transformAPI(API api) throws DeployerException {
        for (URITemplate resource : api.getUriTemplates()) {
            if (!resource.getUriTemplate().endsWith("/*")) continue;
            resource.setUriTemplate(resource.getUriTemplate().replace("/*", "/"));
        }
    }

    public String getDefaultHostnameTemplate() {
        return "{apiId}.execute-api.{region}.amazonaws.com";
    }
}

