/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.aws.client;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;
import org.wso2.aws.client.AWSGatewayDeployer;
import org.wso2.aws.client.util.AWSAPIUtil;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.ConfigurationDto;
import org.wso2.carbon.apimgt.api.model.GatewayAgentConfiguration;
import org.wso2.carbon.apimgt.api.model.GatewayPortalConfiguration;

@Component(name="aws.external.gateway.configuration.component", immediate=true, service={GatewayAgentConfiguration.class})
public class AWSGatewayConfiguration
implements GatewayAgentConfiguration {
    private static final Log log = LogFactory.getLog(AWSAPIUtil.class);

    public String getImplementation() {
        return AWSGatewayDeployer.class.getName();
    }

    public List<ConfigurationDto> getConnectionConfigurations() {
        ArrayList<ConfigurationDto> configurationDtoList = new ArrayList<ConfigurationDto>();
        configurationDtoList.add(new ConfigurationDto("region", "AWS Region", "input", "AWS Region", "", true, false, Collections.emptyList(), false));
        configurationDtoList.add(new ConfigurationDto("access_key", "Access Key", "input", "AWS Access Key for Signature Authentication", "", true, true, Collections.emptyList(), false));
        configurationDtoList.add(new ConfigurationDto("secret_key", "Secret Key", "input", "AWS Secret Key for Signature Authentication", "", true, true, Collections.emptyList(), false));
        configurationDtoList.add(new ConfigurationDto("stage", "Stage Name", "input", "Default stage name", "", true, false, Collections.emptyList(), false));
        return configurationDtoList;
    }

    public String getType() {
        return "AWS";
    }

    public GatewayPortalConfiguration getGatewayFeatureCatalog() throws APIManagementException {
        GatewayPortalConfiguration gatewayPortalConfiguration;
        block9: {
            InputStream inputStream = AWSGatewayConfiguration.class.getClassLoader().getResourceAsStream("GatewayFeatureCatalog.json");
            try {
                if (inputStream == null) {
                    throw new APIManagementException("Gateway Feature Catalog JSON not found");
                }
                Gson gson = new Gson();
                InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                JsonObject gatewayObject = jsonObject.getAsJsonObject("AWS");
                List apiTypes = (List)gson.fromJson(gatewayObject.get("apiTypes"), new TypeToken<List<String>>(){}.getType());
                JsonObject gatewayFeatures = gatewayObject.get("gatewayFeatures").getAsJsonObject();
                GatewayPortalConfiguration config = new GatewayPortalConfiguration();
                config.setGatewayType("AWS");
                config.setSupportedAPITypes(apiTypes);
                config.setSupportedFeatures((Object)gatewayFeatures);
                gatewayPortalConfiguration = config;
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new APIManagementException("Error occurred while reading Gateway Feature Catalog JSON", (Throwable)e);
                }
            }
            inputStream.close();
        }
        return gatewayPortalConfiguration;
    }

    public String getDefaultHostnameTemplate() {
        return "{apiId}.execute-api.{region}.amazonaws.com";
    }
}

