/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.module.csv;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.module.core.SimpleMessageContext;
import org.wso2.carbon.module.csv.AbstractCsvToAnyTransformer;
import org.wso2.carbon.module.csv.constant.EmptyCsvValueType;
import org.wso2.carbon.module.csv.constant.JsonDataType;
import org.wso2.carbon.module.csv.model.JsonDataTypesSchema;
import org.wso2.carbon.module.csv.util.CsvTransformer;
import org.wso2.carbon.module.csv.util.PropertyReader;

public class CsvToJsonTransformer
extends AbstractCsvToAnyTransformer {
    @Override
    void mediate(SimpleMessageContext mc, Stream<String[]> csvArrayStream, String[] header) {
        EmptyCsvValueType treatEmptyCsvValueAs = PropertyReader.getEnumParam(mc, "csvEmptyValues", EmptyCsvValueType.class, EmptyCsvValueType.NULL);
        Optional<String> jsonKeysQuery = PropertyReader.getStringParam(mc, "jsonKeys");
        List<JsonDataTypesSchema> dataTypesSchemaList = PropertyReader.getJsonArrayParam(mc, "dataTypes", JsonDataTypesSchema.class);
        Optional<String> rootJsonKeyQuery = PropertyReader.getStringParam(mc, "rootJsonKey");
        String[] jsonKeys = this.generateObjectKeys(jsonKeysQuery.orElse(""), header);
        Map<Integer, String> dataTypesMap = this.getDataTypes(dataTypesSchemaList, header);
        HashMap<String, Integer> keyOccurrences = new HashMap<String, Integer>();
        String[] uniqueJsonKeys = new String[jsonKeys.length];
        for (int i = 0; i < jsonKeys.length; ++i) {
            String key = jsonKeys[i];
            int count = keyOccurrences.getOrDefault(key, 0);
            uniqueJsonKeys[i] = count > 0 ? key + "_" + count : key;
            keyOccurrences.put(key, count + 1);
        }
        csvArrayStream.map(row -> {
            JsonObject jsonObject = new JsonObject();
            for (int i = 0; i < ((String[])row).length; ++i) {
                String dataTypeString = dataTypesMap.getOrDefault(i, JsonDataType.STRING.toString());
                JsonPrimitive value = this.getCellValue((String[])row, i, treatEmptyCsvValueAs, dataTypeString);
                String key = this.getObjectKey(uniqueJsonKeys, i);
                jsonObject.add(key, (JsonElement)value);
            }
            return jsonObject;
        }).collect((Collector)rootJsonKeyQuery.map(arg_0 -> ((SimpleMessageContext)mc).collectToJsonArray(arg_0)).orElseGet(() -> ((SimpleMessageContext)mc).collectToJsonArray()));
    }

    private JsonPrimitive getCellValue(String[] row, int index, EmptyCsvValueType emptyCsvValueType, String dataTypeString) {
        JsonPrimitive cellValue = null;
        String cellValueString = row[index];
        if (StringUtils.isNotBlank((String)cellValueString)) {
            cellValue = this.convertCellType(cellValueString, dataTypeString);
        } else if (emptyCsvValueType == EmptyCsvValueType.EMPTY) {
            cellValue = new JsonPrimitive("");
        }
        return cellValue;
    }

    private JsonPrimitive convertCellType(String cellValueString, String dataTypeString) {
        if (dataTypeString != null) {
            try {
                JsonDataType dataType = JsonDataType.valueOf(dataTypeString.trim().toUpperCase());
                switch (dataType) {
                    case NUMBER: {
                        return new JsonPrimitive((Number)Double.parseDouble(cellValueString));
                    }
                    case INTEGER: {
                        return new JsonPrimitive((Number)Integer.parseInt(cellValueString));
                    }
                    case BOOLEAN: {
                        return new JsonPrimitive(Boolean.valueOf(Boolean.parseBoolean(cellValueString)));
                    }
                }
                return new JsonPrimitive(cellValueString);
            }
            catch (IllegalArgumentException e) {
                this.log.error((Object)"Error converting csv data to given json type : ", (Throwable)e);
            }
        }
        return new JsonPrimitive(cellValueString);
    }

    private Map<Integer, String> getDataTypes(List<JsonDataTypesSchema> dataTypesSchemaList, String[] header) {
        HashMap<Integer, String> dataTypeMap = new HashMap<Integer, String>();
        for (JsonDataTypesSchema jsonDataTypesSchema : dataTypesSchemaList) {
            int columnIndex;
            String columnIdentifierQuery = jsonDataTypesSchema.getColumnNameOrIndex();
            String isColumnName = jsonDataTypesSchema.getIsColumnName();
            if (isColumnName != null && isColumnName.equalsIgnoreCase("yes")) {
                columnIdentifierQuery = "\"" + columnIdentifierQuery + "\"";
            }
            if ((columnIndex = CsvTransformer.resolveColumnIndex(columnIdentifierQuery, header)) < 0) continue;
            String columnDataTypeValue = jsonDataTypesSchema.getDataType();
            dataTypeMap.put(columnIndex, columnDataTypeValue);
        }
        return dataTypeMap;
    }
}

