/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.module.csv;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.module.core.SimpleMediator;
import org.wso2.carbon.module.core.SimpleMessageContext;
import org.wso2.carbon.module.csv.util.PropertyReader;

public class XmlToCsvTransformer
extends SimpleMediator {
    public void mediate(SimpleMessageContext mc) {
        boolean suppressEscapeCharacter = PropertyReader.getBooleanParam(mc, "suppressEscaping");
        String[] header = this.getHeader(mc);
        mc.getXmlChildElementsStream().map(omElement -> {
            ArrayList<String> csvEntry = new ArrayList<String>();
            Iterator childElementsIterator = omElement.getChildElements();
            while (childElementsIterator.hasNext()) {
                OMElement childElement = (OMElement)childElementsIterator.next();
                String childText = childElement.getText();
                csvEntry.add(childText);
            }
            return csvEntry.toArray(new String[0]);
        }).collect(mc.collectToCsv(header, suppressEscapeCharacter));
    }

    private String[] getHeader(SimpleMessageContext mc) {
        String[] header;
        String headerToAppend = (String)mc.lookupTemplateParameter("customHeader");
        if (!StringUtils.isBlank((String)headerToAppend)) {
            header = headerToAppend.split(",");
        } else {
            OMElement rootXmlElement = mc.getRootXmlElement();
            OMElement firstElement = rootXmlElement.getFirstElement();
            Iterator childElementsIterator = firstElement.getChildElements();
            ArrayList<String> headerList = new ArrayList<String>();
            while (childElementsIterator.hasNext()) {
                OMElement childElement = (OMElement)childElementsIterator.next();
                String keyName = childElement.getQName().getLocalPart();
                headerList.add(keyName);
            }
            header = headerList.toArray(new String[0]);
        }
        return header;
    }
}

