/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.module.csv.util;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.module.core.SimpleMessageContext;
import org.wso2.carbon.module.core.exceptions.SimpleMessageContextException;

public class PropertyReader {
    private static final Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE_WITH_SPACES).setPrettyPrinting().create();

    private PropertyReader() {
    }

    public static Optional<String> getStringParam(SimpleMessageContext mc, String parameterKey) {
        String parameter = (String)mc.lookupTemplateParameter(parameterKey);
        if (StringUtils.isNotBlank((String)parameter)) {
            return Optional.of(parameter);
        }
        return Optional.empty();
    }

    public static Optional<Character> getCharParam(SimpleMessageContext mc, String parameterKey) {
        Optional<String> parameterValue = PropertyReader.getStringParam(mc, parameterKey);
        return parameterValue.map(PropertyReader::replaceWhitespaces);
    }

    private static Character replaceWhitespaces(String text) {
        if (text.equals("tab")) {
            return Character.valueOf('\t');
        }
        if (text.equals("space")) {
            return Character.valueOf(' ');
        }
        return Character.valueOf(text.charAt(0));
    }

    public static Optional<Integer> getIntegerParam(SimpleMessageContext mc, String parameterKey) {
        Optional<String> parameterValue = PropertyReader.getStringParam(mc, parameterKey);
        return parameterValue.map(s -> {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return null;
            }
        });
    }

    public static boolean getBooleanParam(SimpleMessageContext mc, String parameterKey) {
        boolean skipHeader = false;
        String parameter = (String)mc.lookupTemplateParameter(parameterKey);
        if (StringUtils.isNotBlank((String)parameter)) {
            skipHeader = Boolean.parseBoolean(parameter);
        }
        return skipHeader;
    }

    public static <E extends Enum<E>> E getEnumParam(SimpleMessageContext mc, String parameterKey, Class<E> enumType, E defaultValue) {
        Optional<String> parameterValue = PropertyReader.getStringParam(mc, parameterKey);
        if (parameterValue.isPresent()) {
            try {
                return Enum.valueOf(enumType, parameterValue.get().toUpperCase());
            }
            catch (Exception e) {
                throw new SimpleMessageContextException(String.format("Invalid parameter value for %s : %s", parameterKey, parameterValue.get()));
            }
        }
        return defaultValue;
    }

    public static <E> List<E> getJsonArrayParam(SimpleMessageContext mc, String parameterKey, Class<E> type) {
        List result;
        Optional<String> stringParamOptional = PropertyReader.getStringParam(mc, parameterKey);
        Type resultListType = TypeToken.getParameterized(List.class, (Type[])new Type[]{type}).getType();
        if (stringParamOptional.isPresent()) {
            String paramString = stringParamOptional.get();
            try {
                result = (List)gson.fromJson(paramString, resultListType);
            }
            catch (JsonSyntaxException e) {
                throw new SimpleMessageContextException(String.format("Invalid parameter value for %s", parameterKey), (Throwable)e);
            }
        } else {
            result = Collections.emptyList();
        }
        return result;
    }
}

