/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.sample.identity.oauth2.grant.password;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.token.handlers.grant.PasswordGrantHandler;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class RoleBasedPasswordGrant
extends PasswordGrantHandler {
    private static Log log = LogFactory.getLog(RoleBasedPasswordGrant.class);

    public boolean validateGrant(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        boolean authorized = super.authorizeAccessDelegation(tokReqMsgCtx);
        if (authorized) {
            String username = tokReqMsgCtx.getOauth2AccessTokenReqDTO().getResourceOwnerUsername();
            try {
                String[] roles = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getUserStoreManager().getRoleListOfUser(MultitenantUtils.getTenantAwareUsername((String)username));
                for (String role : this.getAuthorizedRoles()) {
                    if (!new ArrayList<String>(Arrays.asList(roles)).contains(role)) continue;
                    return true;
                }
            }
            catch (UserStoreException e) {
                log.error((Object)e);
            }
        }
        return false;
    }

    private List<String> getAuthorizedRoles() {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("TestRole");
        return roles;
    }
}

