/*
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.wso2.auth0.client.model;

import com.google.gson.annotations.SerializedName;
import org.wso2.carbon.apimgt.impl.APIConstants;

import java.util.Arrays;
import java.util.List;

public class Auth0ClientGrantInfo {
    @SerializedName("client_id")
    private String clientId;
    @SerializedName("audience")
    private String audience;
    @SerializedName("scope")
    private List<String> scope;

    public Auth0ClientGrantInfo(String clientId, String audience) {
        this.clientId = clientId;
        this.audience = audience;
        this.scope = Arrays.asList(APIConstants.OAUTH2_DEFAULT_SCOPE);
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getAudience() {
        return audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public List<String> getScope() {
        return scope;
    }

    public void setScope(List<String> scope) {
        this.scope = scope;
    }
}
