/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.auth0.client;

import com.google.gson.Gson;
import feign.Client;
import feign.Feign;
import feign.FeignException;
import feign.Logger;
import feign.RequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.gson.GsonDecoder;
import feign.gson.GsonEncoder;
import feign.okhttp.OkHttpClient;
import feign.slf4j.Slf4jLogger;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.auth0.client.model.Auth0APIKeyInterceptor;
import org.wso2.auth0.client.model.Auth0AccessTokenResponse;
import org.wso2.auth0.client.model.Auth0ClientGrant;
import org.wso2.auth0.client.model.Auth0ClientGrantInfo;
import org.wso2.auth0.client.model.Auth0ClientInfo;
import org.wso2.auth0.client.model.Auth0DCRClient;
import org.wso2.auth0.client.model.Auth0TokenClient;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.AccessTokenInfo;
import org.wso2.carbon.apimgt.api.model.AccessTokenRequest;
import org.wso2.carbon.apimgt.api.model.KeyManagerConfiguration;
import org.wso2.carbon.apimgt.api.model.OAuthAppRequest;
import org.wso2.carbon.apimgt.api.model.OAuthApplicationInfo;
import org.wso2.carbon.apimgt.api.model.Scope;
import org.wso2.carbon.apimgt.impl.AbstractKeyManager;
import org.wso2.carbon.apimgt.impl.dao.ApiMgtDAO;
import org.wso2.carbon.apimgt.impl.kmclient.FormEncoder;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class Auth0OAuthClient
extends AbstractKeyManager {
    private static final Log log = LogFactory.getLog(Auth0OAuthClient.class);
    private Auth0DCRClient auth0DCRClient;
    private Auth0ClientGrant auth0ClientGrant;
    private Auth0TokenClient auth0TokenClient;

    public static String getEncodedCredentials(String clientId, String clientSecret) throws APIManagementException {
        String encodedCredentials;
        try {
            encodedCredentials = Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new APIManagementException("Encoding method is not supported", (Throwable)e);
        }
        return encodedCredentials;
    }

    public OAuthApplicationInfo createApplication(OAuthAppRequest oAuthAppRequest) throws APIManagementException {
        OAuthApplicationInfo oAuthApplicationInfo = oAuthAppRequest.getOAuthApplicationInfo();
        Auth0ClientInfo clientInfo = this.createClientInfoFromOauthApplicationInfo(oAuthApplicationInfo);
        Auth0ClientInfo createdApplication = this.auth0DCRClient.createApplication(clientInfo);
        if (createdApplication != null) {
            OAuthApplicationInfo createdOauthApplication = this.createOAuthAppInfoFromResponse(createdApplication);
            String audience = this.getAudienceFromAuthAppRequest(oAuthApplicationInfo);
            Auth0ClientGrantInfo auth0ClientGrantInfo = new Auth0ClientGrantInfo(createdApplication.getClientId(), audience);
            Auth0ClientGrantInfo addedClientGrant = null;
            if (audience.isEmpty()) {
                log.warn((Object)"Did not provide the audience");
                return createdOauthApplication;
            }
            addedClientGrant = this.auth0ClientGrant.createClientGrant(auth0ClientGrantInfo);
            if (addedClientGrant == null) {
                log.warn((Object)"Error while adding the audience");
            }
            return createdOauthApplication;
        }
        return null;
    }

    private String getAudienceFromAuthAppRequest(OAuthApplicationInfo oAuthApplicationInfo) {
        Object parameter = oAuthApplicationInfo.getParameter("additionalProperties");
        Map additionalProperties = new HashMap();
        if (parameter instanceof String) {
            additionalProperties = (Map)new Gson().fromJson((String)parameter, Map.class);
        }
        return (String)additionalProperties.get("audience_of_api");
    }

    private OAuthApplicationInfo createOAuthAppInfoFromResponse(Auth0ClientInfo createdApplication) {
        OAuthApplicationInfo appInfo = new OAuthApplicationInfo();
        appInfo.setClientName(createdApplication.getClientName());
        appInfo.setClientId(createdApplication.getClientId());
        appInfo.setClientSecret(createdApplication.getClientSecret());
        if (createdApplication.getRedirectUris() != null && createdApplication.getRedirectUris().size() > 0) {
            appInfo.setCallBackURL(String.join((CharSequence)",", createdApplication.getRedirectUris()));
        }
        if (StringUtils.isNotEmpty((String)createdApplication.getClientName())) {
            appInfo.addParameter("client_name", (Object)createdApplication.getClientName());
        }
        if (StringUtils.isNotEmpty((String)createdApplication.getClientId())) {
            appInfo.addParameter("client_id", (Object)createdApplication.getClientId());
        }
        if (StringUtils.isNotEmpty((String)createdApplication.getClientSecret())) {
            appInfo.addParameter("client_secret", (Object)createdApplication.getClientSecret());
        }
        if (createdApplication.getGrantTypes() != null && createdApplication.getGrantTypes().size() > 0) {
            appInfo.addParameter("grant_types", (Object)String.join((CharSequence)",", createdApplication.getGrantTypes()));
        }
        String additionalProperties = new Gson().toJson((Object)createdApplication);
        appInfo.addParameter("additionalProperties", new Gson().fromJson(additionalProperties, Map.class));
        return appInfo;
    }

    private Auth0ClientInfo createClientInfoFromOauthApplicationInfo(OAuthApplicationInfo oAuthApplicationInfo) {
        Auth0ClientInfo clientInfo = new Auth0ClientInfo();
        String userId = (String)oAuthApplicationInfo.getParameter("username");
        String userNameForSp = MultitenantUtils.getTenantAwareUsername((String)userId);
        String domain = UserCoreUtil.extractDomainFromName((String)userNameForSp);
        if (domain != null && !domain.isEmpty() && !"PRIMARY".equals(domain)) {
            userNameForSp = userNameForSp.replace(UserCoreConstants.DOMAIN_SEPARATOR, "_");
        }
        String applicationName = oAuthApplicationInfo.getClientName();
        String keyType = (String)oAuthApplicationInfo.getParameter("key_type");
        String callBackURL = oAuthApplicationInfo.getCallBackURL();
        if (keyType != null) {
            applicationName = userNameForSp.concat(applicationName).concat("_").concat(keyType);
        }
        List<String> grantTypes = new ArrayList<String>();
        if (oAuthApplicationInfo.getParameter("grant_types") != null) {
            grantTypes = Arrays.asList(((String)oAuthApplicationInfo.getParameter("grant_types")).split(","));
        }
        clientInfo.setGrantTypes(grantTypes);
        clientInfo.setClientName(applicationName);
        if (StringUtils.isNotEmpty((String)callBackURL)) {
            String[] calBackUris = callBackURL.split(",");
            clientInfo.setRedirectUris(Arrays.asList(calBackUris));
        }
        Object parameter = oAuthApplicationInfo.getParameter("additionalProperties");
        Map additionalProperties = new HashMap();
        if (parameter instanceof String) {
            additionalProperties = (Map)new Gson().fromJson((String)parameter, Map.class);
        }
        if (additionalProperties.containsKey("app_type")) {
            clientInfo.setApplicationType((String)additionalProperties.get("app_type"));
        } else {
            clientInfo.setApplicationType("regular_web");
        }
        if (additionalProperties.containsKey("token_endpoint_auth_method")) {
            clientInfo.setTokenEndpointAuthMethod((String)additionalProperties.get("token_endpoint_auth_method"));
        }
        return clientInfo;
    }

    public OAuthApplicationInfo updateApplication(OAuthAppRequest oAuthAppRequest) throws APIManagementException {
        OAuthApplicationInfo oAuthApplicationInfo = oAuthAppRequest.getOAuthApplicationInfo();
        Auth0ClientInfo clientInfo = this.createClientInfoFromOauthApplicationInfo(oAuthApplicationInfo);
        clientInfo.setClientSecret(oAuthApplicationInfo.getClientSecret());
        Auth0ClientInfo createdApplication = this.auth0DCRClient.updateApplication(oAuthApplicationInfo.getClientId(), clientInfo);
        if (createdApplication != null) {
            Auth0ClientGrantInfo addedClientGrant;
            OAuthApplicationInfo createdOAuthApplication;
            block7: {
                createdOAuthApplication = this.createOAuthAppInfoFromResponse(createdApplication);
                String audience = this.getAudienceFromAuthAppRequest(oAuthApplicationInfo);
                Auth0ClientGrantInfo auth0ClientGrantInfo = new Auth0ClientGrantInfo(createdApplication.getClientId(), audience);
                addedClientGrant = null;
                if (!audience.isEmpty()) {
                    try {
                        addedClientGrant = this.auth0ClientGrant.createClientGrant(auth0ClientGrantInfo);
                        if (addedClientGrant != null) {
                            return createdOAuthApplication;
                        }
                        break block7;
                    }
                    catch (FeignException e) {
                        if (e.status() == 409) {
                            log.warn((Object)"Client grant already exists.");
                            return createdOAuthApplication;
                        }
                        break block7;
                    }
                }
                log.warn((Object)"Did not provide the audience");
                return createdOAuthApplication;
            }
            if (addedClientGrant == null) {
                log.warn((Object)"Error while adding the audience");
            }
            return createdOAuthApplication;
        }
        return null;
    }

    public void deleteApplication(String clientID) throws APIManagementException {
        this.auth0DCRClient.deleteApplication(clientID);
    }

    public OAuthApplicationInfo retrieveApplication(String clientID) throws APIManagementException {
        Auth0ClientInfo auth0ClientInfo = this.auth0DCRClient.getApplication(clientID);
        OAuthApplicationInfo createdOauthApplication = this.createOAuthAppInfoFromResponse(auth0ClientInfo);
        return createdOauthApplication;
    }

    public AccessTokenInfo getNewApplicationAccessToken(AccessTokenRequest accessTokenRequest) throws APIManagementException {
        String basicCredentials;
        Auth0ClientGrantInfo[] clientGrantInfos = this.auth0ClientGrant.getClientGrant(accessTokenRequest.getClientId());
        String audience = clientGrantInfos.length > 0 ? clientGrantInfos[0].getAudience() : "";
        String scopes = accessTokenRequest.getScope() != null && accessTokenRequest.getScope().length > 0 ? String.join((CharSequence)" ", accessTokenRequest.getScope()) : "";
        String grantType = accessTokenRequest.getGrantType() != null ? accessTokenRequest.getGrantType() : "client_credentials";
        Auth0AccessTokenResponse retrievedAccessTokenResponse = this.auth0TokenClient.getAccessToken(grantType, audience, scopes, basicCredentials = Auth0OAuthClient.getEncodedCredentials(accessTokenRequest.getClientId(), accessTokenRequest.getClientSecret()));
        if (retrievedAccessTokenResponse != null) {
            AccessTokenInfo accessTokenInfo = new AccessTokenInfo();
            accessTokenInfo.setConsumerKey(accessTokenRequest.getClientId());
            accessTokenInfo.setConsumerSecret(accessTokenRequest.getClientSecret());
            accessTokenInfo.setAccessToken(retrievedAccessTokenResponse.getAccessToken());
            if (retrievedAccessTokenResponse.getScope() != null) {
                accessTokenInfo.setScope(retrievedAccessTokenResponse.getScope().split("\\s+"));
            }
            accessTokenInfo.setValidityPeriod(retrievedAccessTokenResponse.getExpiry());
            return accessTokenInfo;
        }
        return null;
    }

    public String getNewApplicationConsumerSecret(AccessTokenRequest accessTokenRequest) throws APIManagementException {
        Auth0ClientInfo createdApplication = this.auth0DCRClient.regenerateClientSecret(accessTokenRequest.getClientId());
        return createdApplication.getClientSecret();
    }

    public AccessTokenInfo getTokenMetaData(String s) throws APIManagementException {
        return null;
    }

    public KeyManagerConfiguration getKeyManagerConfiguration() throws APIManagementException {
        return this.configuration;
    }

    public OAuthApplicationInfo mapOAuthApplication(OAuthAppRequest oAuthAppRequest) throws APIManagementException {
        return oAuthAppRequest.getOAuthApplicationInfo();
    }

    public void loadConfiguration(KeyManagerConfiguration keyManagerConfiguration) throws APIManagementException {
        this.configuration = keyManagerConfiguration;
        this.auth0TokenClient = (Auth0TokenClient)Feign.builder().client((Client)new OkHttpClient()).encoder((Encoder)new FormEncoder()).decoder((Decoder)new GsonDecoder()).errorDecoder((ErrorDecoder)new ErrorDecoder.Default()).logger((Logger)new Slf4jLogger()).target(Auth0TokenClient.class, (String)keyManagerConfiguration.getParameter("token_endpoint"));
        Auth0APIKeyInterceptor auth0APIKeyInterceptor = new Auth0APIKeyInterceptor(this.auth0TokenClient, (String)keyManagerConfiguration.getParameter("client_id"), (String)keyManagerConfiguration.getParameter("client_secret"), (String)keyManagerConfiguration.getParameter("audience"));
        String clientRegistrationEndpoint = ((String)keyManagerConfiguration.getParameter("audience")).concat("clients");
        String clientGrantEndpoint = ((String)keyManagerConfiguration.getParameter("audience")).concat("client-grants");
        this.auth0DCRClient = (Auth0DCRClient)Feign.builder().client((Client)new OkHttpClient()).encoder((Encoder)new GsonEncoder()).decoder((Decoder)new GsonDecoder()).errorDecoder((ErrorDecoder)new ErrorDecoder.Default()).logger((Logger)new Slf4jLogger()).requestInterceptor((RequestInterceptor)auth0APIKeyInterceptor).target(Auth0DCRClient.class, clientRegistrationEndpoint);
        this.auth0ClientGrant = (Auth0ClientGrant)Feign.builder().client((Client)new OkHttpClient()).encoder((Encoder)new GsonEncoder()).decoder((Decoder)new GsonDecoder()).errorDecoder((ErrorDecoder)new ErrorDecoder.Default()).logger((Logger)new Slf4jLogger()).requestInterceptor((RequestInterceptor)auth0APIKeyInterceptor).target(Auth0ClientGrant.class, clientGrantEndpoint);
    }

    public boolean registerNewResource(API api, Map map) throws APIManagementException {
        return false;
    }

    public Map getResourceByApiId(String s) throws APIManagementException {
        return null;
    }

    public boolean updateRegisteredResource(API api, Map map) throws APIManagementException {
        return false;
    }

    public void deleteRegisteredResourceByAPIId(String s) throws APIManagementException {
    }

    public void deleteMappedApplication(String s) throws APIManagementException {
    }

    public Set<String> getActiveTokensByConsumerKey(String s) throws APIManagementException {
        return null;
    }

    public AccessTokenInfo getAccessTokenByConsumerKey(String s) throws APIManagementException {
        return null;
    }

    public boolean canHandleToken(String accessToken) throws APIManagementException {
        return false;
    }

    public Map<String, Set<Scope>> getScopesForAPIS(String apiIdsString) throws APIManagementException {
        HashMap<String, Set<Scope>> apiToScopeMapping = new HashMap<String, Set<Scope>>();
        ApiMgtDAO apiMgtDAO = ApiMgtDAO.getInstance();
        Map apiToScopeKeyMapping = apiMgtDAO.getScopesForAPIS(apiIdsString);
        for (String apiId : apiToScopeKeyMapping.keySet()) {
            LinkedHashSet<Scope> apiScopes = new LinkedHashSet<Scope>();
            Set scopeKeys = (Set)apiToScopeKeyMapping.get(apiId);
            for (String scopeKey : scopeKeys) {
                Scope scope = this.getScopeByName(scopeKey);
                apiScopes.add(scope);
            }
            apiToScopeMapping.put(apiId, apiScopes);
        }
        return apiToScopeMapping;
    }

    public void registerScope(Scope scope) throws APIManagementException {
    }

    public Scope getScopeByName(String s) throws APIManagementException {
        return null;
    }

    public Map<String, Scope> getAllScopes() throws APIManagementException {
        return null;
    }

    public void deleteScope(String s) throws APIManagementException {
    }

    public void updateScope(Scope scope) throws APIManagementException {
    }

    public boolean isScopeExists(String s) throws APIManagementException {
        return false;
    }

    public String getType() {
        return "Auth0";
    }
}

