/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2.generate.feature;

import org.apache.maven.artifact.Artifact;
import org.wso2.maven.p2.generate.feature.Bundle;

public class IncludedFeature {
    private String groupId;
    private String artifactId;
    private String artifactVersion;
    private String optionality;
    private boolean optional = false;
    private String featureID;
    private String featureVersion;
    private Artifact artifact;

    public boolean isOptional() {
        return this.optional;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getArtifactVersion() {
        return this.artifactVersion;
    }

    public void setArtifactVersion(String artifactVersion) {
        this.artifactVersion = artifactVersion;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }

    public String getFeatureID() {
        return this.featureID;
    }

    public String getFeatureVersion() {
        return this.featureVersion;
    }

    public static IncludedFeature getIncludedFeature(String definition) {
        String segment;
        IncludedFeature feature;
        String[] segments = definition.split(":");
        if (segments.length >= 2) {
            feature = new IncludedFeature();
            feature.groupId = segments[0];
            feature.artifactId = segments[1];
            if (segments[1].endsWith(".feature")) {
                feature.featureID = segments[1].substring(0, segments[1].lastIndexOf(".feature"));
            }
        } else {
            return null;
        }
        if (segments.length >= 3) {
            segment = segments[2];
            if ("optional".equals(segment)) {
                feature.optional = true;
            } else {
                feature.artifactVersion = segment;
                feature.featureVersion = Bundle.getOSGIVersion(segment);
            }
        }
        if (segments.length == 4 && "optional".equals(segment = segments[3])) {
            feature.optional = true;
        }
        return feature;
    }

    public void setFeatureVersion(String version) {
        if (this.artifactVersion == null || this.artifactVersion.equals("")) {
            this.artifactVersion = version;
            this.featureVersion = Bundle.getOSGIVersion(version);
        }
    }
}

