/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.car.artifact.fsm.resolvers;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.maven.car.artifact.fsm.IParameterResolver;
import org.wso2.maven.car.artifact.fsm.TopologyFSEngine;
import org.wso2.maven.stratos.interfaces.ITopology;
import org.wso2.maven.stratos.interfaces.ITopologyServer;

public class ServerParameterResolver
implements IParameterResolver {
    private TopologyFSEngine engine;
    private HashMap<String, Map<String, URL>> serverRoleMap;

    @Override
    public String resolve(String parameter) {
        String s = parameter.substring(2, parameter.length() - 1);
        String[] parameterSections = s.split("\\.");
        String key = parameterSections[0];
        List<String> values = this.removeFirstParameter(parameterSections);
        return this.getParameterValue(key, values);
    }

    @Override
    public ITopology getTopology() {
        return this.engine.getTopology();
    }

    @Override
    public void setTopologyFSEngine(TopologyFSEngine engine) {
        this.engine = engine;
        this.initialize();
    }

    private String getParameterValue(String key, List<String> values) {
        if ((key = key.toLowerCase()).equals("servers")) {
            return this.getServersParameter(values.get(0), this.removeFirstParameter(values));
        }
        return null;
    }

    private String getServersParameter(String serverRole, List<String> values) {
        String logic1;
        if (this.getServerRoleMap().containsKey(serverRole) && (logic1 = values.get(0).toLowerCase()).equals("url")) {
            Map<String, URL> map = this.getServerRoleMap().get(serverRole);
            String urlInfo = values.get(1).toLowerCase();
            URL url = map.get(urlInfo);
            if (values.size() == 2) {
                return url.toString();
            }
            if (values.get(2).equals("host")) {
                return url.getHost();
            }
            if (values.get(2).equals("port")) {
                return String.valueOf(url.getPort());
            }
            if (values.get(2).equals("protocol")) {
                return url.getProtocol();
            }
        }
        return null;
    }

    private List<String> removeFirstParameter(String ... list) {
        return this.removeFirstParameter(Arrays.asList(list));
    }

    private List<String> removeFirstParameter(List<String> list) {
        ArrayList<String> newList = new ArrayList<String>();
        newList.addAll(list);
        newList.remove(0);
        return newList;
    }

    public HashMap<String, Map<String, URL>> getServerRoleMap() {
        if (this.serverRoleMap == null) {
            this.serverRoleMap = new HashMap();
        }
        return this.serverRoleMap;
    }

    private void initialize() {
        HashMap<String, Map<String, URL>> serverRoleMap = this.getServerRoleMap();
        List servers = this.getTopology().getServers();
        for (ITopologyServer server : servers) {
            List serverRoles = server.getServerRoles();
            for (String role : serverRoles) {
                if (serverRoleMap.containsKey(role)) continue;
                serverRoleMap.put(role, server.getUrls());
            }
        }
    }
}

