/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.wso2.maven.registry.RegistryArtifact;
import org.wso2.maven.registry.RegistryInfoProvider;
import org.wso2.maven.registry.beans.RegistryCollection;
import org.wso2.maven.registry.beans.RegistryElement;
import org.wso2.maven.registry.beans.RegistryItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryInfo
extends RegistryInfoProvider {
    private List<RegistryElement> registryArtifacts = new ArrayList<RegistryElement>();

    @Override
    protected void deserialize(OMElement documentElement) throws Exception {
        List artifactElements = this.getChildElements(documentElement, "item");
        for (OMElement omElement : artifactElements) {
            RegistryItem item = this.getRegistryItem(omElement);
            this.registryArtifacts.add(item);
        }
        List itemElements1 = this.getChildElements(documentElement, "collection");
        for (OMElement omElement2 : itemElements1) {
            RegistryCollection item = this.getRegistryCollection(omElement2);
            this.registryArtifacts.add(item);
        }
    }

    public void addESBArtifact(RegistryElement artifact) {
        this.registryArtifacts.add(artifact);
    }

    public boolean removeESBArtifact(RegistryArtifact artifact) {
        return this.registryArtifacts.remove(artifact);
    }

    public List<RegistryElement> getAllESBArtifacts() {
        return Collections.unmodifiableList(this.registryArtifacts);
    }

    @Override
    public OMElement getDocumentElement() {
        OMElement documentElement = this.getElement("resources", "");
        for (RegistryElement item : this.registryArtifacts) {
            OMElement element = this.getRegistryElementInfo(item);
            if (element == null) continue;
            documentElement.addChild((OMNode)element);
        }
        return documentElement;
    }
}

