/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.plugins;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class ServiceModuleListMojo
extends AbstractMojo {
    private List dependencies;
    private File outputDirectory;
    private List extAarNames;
    private List extMarNames;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.dependencies != null && !this.dependencies.isEmpty()) {
            ArrayList<String> marList = new ArrayList<String>();
            ArrayList<String> aarList = new ArrayList<String>();
            Iterator iterator = this.dependencies.iterator();
            while (iterator.hasNext()) {
                String o;
                Dependency dependency = (Dependency)iterator.next();
                if (dependency.getType().equals("aar")) {
                    o = dependency.getArtifactId() + "." + dependency.getType();
                    aarList.add(o);
                    continue;
                }
                if (!dependency.getType().equals("mar")) continue;
                o = dependency.getArtifactId() + "-" + dependency.getVersion() + "." + dependency.getType();
                marList.add(o);
            }
            if (this.extAarNames != null && this.extAarNames.size() > 0) {
                aarList.addAll(this.extAarNames);
            }
            if (this.extMarNames != null && this.extMarNames.size() > 0) {
                marList.addAll(this.extMarNames);
            }
            this.serializeList(marList, "modules.list");
            this.serializeList(aarList, "services.list");
        }
    }

    private void serializeList(List list, String outputFileName) throws MojoFailureException {
        File outLocation;
        this.getLog().info((CharSequence)("Generating " + outputFileName));
        if (!this.outputDirectory.isDirectory() || !this.outputDirectory.exists()) {
            this.outputDirectory.mkdir();
        }
        if ((outLocation = new File(this.outputDirectory, outputFileName)).exists()) {
            outLocation.delete();
        }
        try {
            outLocation.createNewFile();
            FileWriter fileWriter = new FileWriter(outLocation);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String archiveName = (String)iterator.next();
                bufferedWriter.write(archiveName);
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (IOException e) {
            String msg = outLocation.getAbsolutePath() + "cannot be created";
            throw new MojoFailureException((Object)e, msg, msg);
        }
    }
}

