/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.DeferredParsingException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.wso2.maven.CARMojo;
import org.wso2.maven.MavenUtils;
import org.wso2.maven.core.model.AbstractXMLDoc;
import org.wso2.maven.model.Artifact;
import org.wso2.maven.model.ArtifactDependency;
import org.wso2.maven.model.ArtifactDetails;

class CAppHandler
extends AbstractXMLDoc {
    private final String cAppName;
    private final CARMojo mojoInstance;
    private final List<ArtifactDetails> artifactTypeList;
    private final Map<String, String> apiList = new HashMap<String, String>();
    private final Map<String, String> proxyList = new HashMap<String, String>();

    public CAppHandler(String cAppName, CARMojo mojoInstance) {
        this.cAppName = cAppName;
        this.mojoInstance = mojoInstance;
        this.artifactTypeList = new ArrayList<ArtifactDetails>(Arrays.asList(new ArtifactDetails("apis", "synapse/api", "EnterpriseIntegrator"), new ArtifactDetails("endpoints", "synapse/endpoint", "EnterpriseIntegrator"), new ArtifactDetails("inbound-endpoints", "synapse/inbound-endpoint", "EnterpriseIntegrator"), new ArtifactDetails("local-entries", "synapse/local-entry", "EnterpriseIntegrator"), new ArtifactDetails("message-processors", "synapse/message-processors", "EnterpriseIntegrator"), new ArtifactDetails("message-stores", "synapse/message-store", "EnterpriseIntegrator"), new ArtifactDetails("proxy-services", "synapse/proxy-service", "EnterpriseIntegrator"), new ArtifactDetails("sequences", "synapse/sequence", "EnterpriseIntegrator"), new ArtifactDetails("tasks", "synapse/task", "EnterpriseIntegrator"), new ArtifactDetails("templates", "synapse/template", "EnterpriseIntegrator"), new ArtifactDetails("data-sources", "datasource/datasource", "EnterpriseServiceBus"), new ArtifactDetails("data-services", "service/dataservice", "EnterpriseServiceBus")));
    }

    void processArtifacts(File artifactsFolder, String archiveDirectory, List<ArtifactDependency> dependencies, List<ArtifactDependency> metadataDependencies, String version) {
        if (!artifactsFolder.exists()) {
            this.mojoInstance.logInfo("Could not find artifacts folder in " + artifactsFolder.getAbsolutePath());
            return;
        }
        this.mojoInstance.logInfo("Processing artifacts in " + artifactsFolder.getAbsolutePath());
        for (ArtifactDetails artifactDetails : this.artifactTypeList) {
            File artifactFolder = new File(artifactsFolder, artifactDetails.getDirectory());
            this.processArtifactsInFolder(artifactFolder, dependencies, metadataDependencies, version, archiveDirectory, artifactDetails.getServerRole(), artifactDetails.getType());
        }
    }

    void processArtifactsInFolder(File artifactsDir, List<ArtifactDependency> dependencies, List<ArtifactDependency> metadataDependencies, String version, String archiveDirectory, String serverRole, String type) {
        File[] configFiles = artifactsDir.listFiles();
        if (configFiles != null) {
            for (File configFile : configFiles) {
                if (!configFile.isFile()) continue;
                try {
                    String fileName;
                    String fileContent = FileUtils.readFileToString((File)configFile);
                    OMElement configElement = this.getElement(fileContent);
                    String name = configElement.getAttributeValue(new QName("name"));
                    if ("synapse/local-entry".equals(type)) {
                        name = configElement.getAttributeValue(new QName("key"));
                    }
                    if ("datasource/datasource".equals(type)) {
                        name = configFile.getName().substring(0, configFile.getName().length() - 4);
                    }
                    String configVersion = configElement.getAttributeValue(new QName("version"));
                    boolean apiHasVersion = true;
                    if ("synapse/api".equals(type)) {
                        this.apiList.put(name, configVersion);
                        if (!this.isMetadataPresent(name, configVersion, artifactsDir, "_metadata.yaml")) {
                            this.writeMetadataFile(name, configElement, archiveDirectory, false, version);
                            this.addMetadataDependencies(metadataDependencies, configElement, false, version);
                        }
                    }
                    if ("synapse/proxy-service".equals(type)) {
                        this.proxyList.put(name, configVersion);
                        if (!this.isMetadataPresent(name, configVersion, artifactsDir, "_proxy_metadata.yaml")) {
                            this.writeMetadataFile(name, configElement, archiveDirectory, true, version);
                            this.addMetadataDependencies(metadataDependencies, configElement, true, version);
                        }
                    }
                    if (configVersion == null) {
                        apiHasVersion = false;
                        configVersion = version;
                    }
                    String folderName = "";
                    if ("synapse/api".equals(type) && apiHasVersion) {
                        fileName = name + "_" + configVersion + "-" + configVersion;
                        folderName = name + "_" + configVersion + "_" + configVersion;
                    } else {
                        fileName = name + "-" + configVersion;
                        folderName = name + "_" + configVersion;
                    }
                    fileName = fileName.concat("service/dataservice".equals(type) ? ".dbs" : ".xml");
                    name = apiHasVersion ? name + "_" + configVersion : name;
                    dependencies.add(new ArtifactDependency(name, configVersion, serverRole, true));
                    this.writeArtifactAndFile(configFile, archiveDirectory, name, type, serverRole, configVersion, fileName, folderName);
                }
                catch (IOException | XMLStreamException | DeferredParsingException e) {
                    this.mojoInstance.logError("Error occurred while processing " + configFile.getName());
                    this.mojoInstance.logError(e.getMessage());
                }
            }
        }
    }

    private boolean isMetadataPresent(String name, String configVersion, File artifactsDir, String suffix) {
        String metadataFilename = StringUtils.isBlank((String)configVersion) ? name + suffix : name + "_" + configVersion + suffix;
        File resourcesFolder = artifactsDir.toPath().getParent().getParent().resolve("resources").toFile();
        File metadataFolder = new File(resourcesFolder, "metadata");
        File metaFile = new File(metadataFolder, metadataFilename);
        return metaFile.exists();
    }

    void processResourcesFolder(File resourcesFolder, String archiveDirectory, List<ArtifactDependency> dependencies, List<ArtifactDependency> metadataDependencies, String version) {
        if (!resourcesFolder.exists()) {
            this.mojoInstance.logInfo("Could not find resources folder in " + resourcesFolder.getAbsolutePath());
            return;
        }
        this.processConnectors(resourcesFolder, archiveDirectory, dependencies);
        this.processRegistryResources(resourcesFolder, archiveDirectory, dependencies);
        this.processRegistryResources(new File(resourcesFolder, "registry"), archiveDirectory, dependencies);
        this.processMetadata(resourcesFolder, archiveDirectory, metadataDependencies, version);
        this.processPropertyFile(resourcesFolder, archiveDirectory, version, dependencies);
    }

    void processConnectors(File resourcesFolder, String archiveDirectory, List<ArtifactDependency> dependencies) {
        this.mojoInstance.logInfo("Processing connectors in " + resourcesFolder.getAbsolutePath());
        File connectorFolder = new File(resourcesFolder, "connectors");
        File[] connectorFiles = connectorFolder.listFiles();
        if (connectorFiles == null) {
            return;
        }
        for (File connector : connectorFiles) {
            if (!connector.isFile() || !connector.getName().endsWith(".zip")) continue;
            String fileName = connector.getName();
            int lastIndex = fileName.lastIndexOf(45);
            String name = fileName.substring(0, lastIndex);
            String version = fileName.substring(lastIndex + 1, fileName.length() - 4);
            dependencies.add(new ArtifactDependency(name, version, "EnterpriseIntegrator", true));
            this.writeArtifactAndFile(connector, archiveDirectory, name, "synapse/lib", "EnterpriseIntegrator", version, fileName, name + "_" + version);
        }
    }

    void processPropertyFile(File resourcesFolder, String archiveDirectory, String version, List<ArtifactDependency> dependencies) {
        File confFolder = new File(resourcesFolder, "conf");
        File propertyFile = new File(confFolder, "config.properties");
        if (!propertyFile.exists()) {
            return;
        }
        this.mojoInstance.logInfo("Processing property file in " + confFolder.getAbsolutePath());
        this.writeArtifactAndFile(propertyFile, archiveDirectory, "config", "config/property", "EnterpriseIntegrator", version, "config.properties", "config_" + version);
        dependencies.add(new ArtifactDependency("config", version, "EnterpriseIntegrator", true));
    }

    void processRegistryResources(File resourcesFolder, String archiveDirectory, List<ArtifactDependency> dependencies) {
        this.mojoInstance.logInfo("Processing registry resources in " + resourcesFolder.getAbsolutePath());
        File artifactFile = new File(resourcesFolder, "artifact.xml");
        if (!artifactFile.exists()) {
            return;
        }
        try {
            String artifactXmlFileAsString = FileUtils.readFileToString((File)artifactFile);
            OMElement artifactsElement = this.getElement(artifactXmlFileAsString);
            List artifactChildElements = this.getChildElements(artifactsElement, "artifact");
            for (OMElement artifact : artifactChildElements) {
                File registryResource;
                String path;
                String name = artifact.getAttributeValue(new QName("name"));
                String version = artifact.getAttributeValue(new QName("version"));
                String commonPath = Paths.get(archiveDirectory, name + "_" + version).toString();
                if (artifact.getFirstChildWithName(new QName("item")) != null) {
                    OMElement item = this.getFirstChildWithName(artifact, "item");
                    String fileName = item.getFirstChildWithName(new QName("file")).getText();
                    path = item.getFirstChildWithName(new QName("path")).getText();
                    if (path.startsWith("/_system/governance/mi-resources")) {
                        path = path.substring("/_system/governance/mi-resources".length());
                        registryResource = new File(resourcesFolder, path + "/" + fileName);
                    } else if (path.startsWith("/_system/governance")) {
                        path = path.substring("/_system/governance".length());
                        registryResource = new File(resourcesFolder, "gov" + path + "/" + fileName);
                    } else {
                        path = path.substring("/_system/config".length());
                        registryResource = new File(resourcesFolder, "conf" + path + "/" + fileName);
                    }
                    if (!registryResource.exists()) {
                        this.mojoInstance.logError("Registry resource " + path + "/" + fileName + " does not exist");
                        continue;
                    }
                    org.wso2.developerstudio.eclipse.utils.file.FileUtils.copy((File)registryResource, (File)new File(Paths.get(archiveDirectory, name + "_" + version, "resources", fileName).toString()));
                    OMElement infoElement = this.getElement("resources", "");
                    infoElement.addChild((OMNode)item);
                    org.wso2.developerstudio.eclipse.utils.file.FileUtils.createFile((File)new File(commonPath, "registry-info.xml"), (String)this.serialize(infoElement));
                } else if (artifact.getFirstChildWithName(new QName("collection")) != null) {
                    OMElement collection = this.getFirstChildWithName(artifact, "collection");
                    String directory = collection.getFirstChildWithName(new QName("directory")).getText();
                    path = collection.getFirstChildWithName(new QName("path")).getText();
                    if (path.startsWith("/_system/governance/mi-resources")) {
                        path = path.substring("/_system/governance/mi-resources".length());
                        registryResource = new File(resourcesFolder, path);
                    } else if (path.startsWith("/_system/governance")) {
                        path = path.substring("/_system/governance".length());
                        registryResource = new File(resourcesFolder, "gov" + path);
                    } else {
                        path = path.substring("/_system/config".length());
                        registryResource = new File(resourcesFolder, "conf" + path);
                    }
                    if (!registryResource.exists()) {
                        this.mojoInstance.logError("Registry resource " + path + " does not exist");
                        continue;
                    }
                    File destFile = new File(Paths.get(archiveDirectory, name + "_" + version, "resources", directory).toString());
                    destFile.mkdirs();
                    FileUtils.copyDirectory((File)registryResource, (File)destFile);
                    OMElement infoElement = this.getElement("resources", "");
                    infoElement.addChild((OMNode)collection);
                    org.wso2.developerstudio.eclipse.utils.file.FileUtils.createFile((File)new File(commonPath, "registry-info.xml"), (String)this.serialize(infoElement));
                }
                dependencies.add(new ArtifactDependency(name, version, "EnterpriseIntegrator", true));
                Artifact artifactObject = new Artifact();
                artifactObject.setName(name);
                artifactObject.setType("registry/resource");
                artifactObject.setVersion(version);
                artifactObject.setServerRole("EnterpriseIntegrator");
                artifactObject.setFile("registry-info.xml");
                String artifactDataAsString = this.createArtifactData(artifactObject);
                org.wso2.developerstudio.eclipse.utils.file.FileUtils.createFile((File)new File(commonPath, "artifact.xml"), (String)artifactDataAsString);
            }
        }
        catch (IOException | XMLStreamException | MojoExecutionException e) {
            this.mojoInstance.logError("Error occurred while processing registry resources");
            this.mojoInstance.logError(e.getMessage());
        }
    }

    void processMetadata(File resourcesFolder, String archiveDirectory, List<ArtifactDependency> metadataDependencies, String version) {
        this.mojoInstance.logInfo("Processing metadata in " + resourcesFolder.getAbsolutePath());
        File metadataFolder = new File(resourcesFolder, "metadata");
        if (this.apiList.size() > 0) {
            for (Map.Entry<String, String> entry : this.apiList.entrySet()) {
                File swaggerFile;
                String apiName = entry.getKey();
                String apiVersion = entry.getValue();
                String swaggerFilename = apiName + "_swagger.yaml";
                String metadataFilename = apiName + "_metadata.yaml";
                boolean apiVersionExists = true;
                if (apiVersion != null) {
                    swaggerFilename = apiName + "_" + apiVersion + "_swagger.yaml";
                    metadataFilename = apiName + "_" + apiVersion + "_metadata.yaml";
                } else {
                    apiVersion = version;
                    apiVersionExists = false;
                }
                File metaFile = new File(metadataFolder, metadataFilename);
                if (metaFile.exists()) {
                    String folderName = "metadata/" + apiName + "_metadata_" + apiVersion;
                    String fileName = apiName + "_metadata-" + apiVersion + ".yaml";
                    if (apiVersionExists) {
                        fileName = apiName + "_" + apiVersion + "_metadata-" + apiVersion + ".yaml";
                        folderName = "metadata/" + apiName + "_" + apiVersion + "_metadata_" + apiVersion;
                        String name = apiName + "_" + apiVersion + "_metadata";
                        metadataDependencies.add(new ArtifactDependency(name, apiVersion, "EnterpriseIntegrator", true));
                        this.writeArtifactAndFile(metaFile, archiveDirectory, name, "synapse/metadata", "EnterpriseIntegrator", apiVersion, fileName, folderName);
                    } else {
                        metadataDependencies.add(new ArtifactDependency(apiName + "_metadata", version, "EnterpriseIntegrator", true));
                        this.writeArtifactAndFile(metaFile, archiveDirectory, apiName + "_metadata", "synapse/metadata", "EnterpriseIntegrator", apiVersion, fileName, folderName);
                    }
                }
                if (this.isApiDefinitionPresent(apiName, apiVersion, apiVersionExists, metadataDependencies) || !(swaggerFile = new File(metadataFolder, swaggerFilename)).exists()) continue;
                String folderName = "metadata/" + apiName + "_swagger_" + apiVersion;
                String fileName = apiName + "_swagger-" + apiVersion + ".yaml";
                if (apiVersionExists) {
                    fileName = apiName + "_" + apiVersion + "_swagger-" + apiVersion + ".yaml";
                    folderName = "metadata/" + apiName + "_" + apiVersion + "_swagger_" + apiVersion;
                    String name = apiName + "_" + apiVersion + "_swagger";
                    metadataDependencies.add(new ArtifactDependency(name, apiVersion, "EnterpriseIntegrator", true));
                    this.writeArtifactAndFile(swaggerFile, archiveDirectory, name, "synapse/metadata", "EnterpriseIntegrator", apiVersion, fileName, folderName);
                    continue;
                }
                metadataDependencies.add(new ArtifactDependency(apiName + "_swagger", apiVersion, "EnterpriseIntegrator", true));
                this.writeArtifactAndFile(swaggerFile, archiveDirectory, apiName + "_swagger", "synapse/metadata", "EnterpriseIntegrator", apiVersion, fileName, folderName);
            }
        }
        if (this.proxyList.size() > 0) {
            for (Map.Entry<String, String> entry : this.proxyList.entrySet()) {
                File metaFile;
                String proxyName = entry.getKey();
                String proxyVersion = entry.getValue();
                if (proxyVersion == null) {
                    proxyVersion = version;
                }
                if (!(metaFile = new File(metadataFolder, proxyName + "_proxy_metadata.yaml")).exists()) continue;
                this.writeArtifactAndFile(metaFile, archiveDirectory, proxyName + "_proxy_metadata", "synapse/metadata", "EnterpriseIntegrator", proxyVersion, proxyName + "_proxy_metadata-" + proxyVersion + ".yaml", "metadata/" + proxyName + "_proxy_metadata_" + proxyVersion);
                metadataDependencies.add(new ArtifactDependency(proxyName + "_proxy_metadata", proxyVersion, "EnterpriseIntegrator", true));
            }
        }
    }

    private void writeArtifactAndFile(File configFile, String archiveDirectory, String name, String type, String serverRole, String configVersion, String fileName, String folderName) {
        this.writeArtifactAndFile(configFile, archiveDirectory, name, type, serverRole, configVersion, fileName, folderName, null);
    }

    private void writeArtifactAndFile(File configFile, String archiveDirectory, String name, String type, String serverRole, String configVersion, String fileName, String folderName, String connectorName) {
        Artifact artifactObject = new Artifact();
        artifactObject.setName(name);
        artifactObject.setType(type);
        artifactObject.setVersion(configVersion);
        artifactObject.setServerRole(serverRole);
        artifactObject.setFile(fileName);
        if (connectorName != null) {
            artifactObject.setConnector(connectorName);
        }
        try {
            String artifactDataAsString = this.createArtifactData(artifactObject);
            org.wso2.developerstudio.eclipse.utils.file.FileUtils.createFile((File)new File(Paths.get(archiveDirectory, folderName).toString(), "artifact.xml"), (String)artifactDataAsString);
            org.wso2.developerstudio.eclipse.utils.file.FileUtils.copy((File)configFile, (File)new File(Paths.get(archiveDirectory, folderName, fileName).toString()));
        }
        catch (IOException | MojoExecutionException e) {
            this.mojoInstance.logError("Error occurred while creating " + fileName);
            this.mojoInstance.logError(e.getMessage());
        }
    }

    void processAPIDefinitions(File resourcesFolder, String archiveDirectory, List<ArtifactDependency> metadataDependencies, String projectVersion) {
        this.mojoInstance.logInfo("Processing API definitions in " + resourcesFolder.getAbsolutePath());
        File metadataFolder = new File(resourcesFolder, "api-definitions");
        if (!this.apiList.isEmpty()) {
            for (Map.Entry<String, String> entry : this.apiList.entrySet()) {
                String name;
                String folderName;
                String fileName;
                File swaggerFile;
                String apiName = entry.getKey();
                String apiVersion = entry.getValue();
                String swaggerFilename = apiName + ".yaml";
                boolean apiVersionExists = true;
                if (apiVersion == null) {
                    apiVersion = projectVersion;
                    apiVersionExists = false;
                } else {
                    swaggerFilename = apiName + "_v" + apiVersion + ".yaml";
                }
                if (!(swaggerFile = new File(metadataFolder, swaggerFilename)).exists()) continue;
                if (apiVersionExists) {
                    fileName = apiName + "_" + apiVersion + "_swagger-" + apiVersion + ".yaml";
                    folderName = "metadata/" + apiName + "_" + apiVersion + "_swagger_" + apiVersion;
                    name = apiName + "_" + apiVersion + "_swagger";
                    metadataDependencies.add(new ArtifactDependency(name, apiVersion, "EnterpriseIntegrator", true));
                    this.writeArtifactAndFile(swaggerFile, archiveDirectory, name, "synapse/metadata", "EnterpriseIntegrator", apiVersion, fileName, folderName);
                    continue;
                }
                folderName = "metadata/" + apiName + "_swagger_" + apiVersion;
                fileName = apiName + "_swagger-" + apiVersion + ".yaml";
                name = apiName + "_swagger";
                metadataDependencies.add(new ArtifactDependency(name, apiVersion, "EnterpriseIntegrator", true));
                this.writeArtifactAndFile(swaggerFile, archiveDirectory, name, "synapse/metadata", "EnterpriseIntegrator", apiVersion, fileName, folderName);
            }
        }
    }

    private void writeMetadataFile(String name, OMElement apiElement, String archiveDirectory, boolean isProxy, String projectVersion) {
        try {
            String metadataFileName;
            String metadataFolder;
            String artifactName;
            String version = null;
            OMAttribute versionAtt = apiElement.getAttribute(new QName("version"));
            if (versionAtt != null) {
                version = versionAtt.getAttributeValue();
            }
            if (version != null) {
                artifactName = name + "_" + version + "_metadata";
                metadataFolder = name + "_" + version + "_metadata_" + version;
                metadataFileName = name + "_" + version + "_metadata-" + version + ".yaml";
            } else {
                if (isProxy) {
                    name = name + "_proxy";
                }
                artifactName = name + "_metadata";
                metadataFolder = name + "_metadata_" + projectVersion;
                metadataFileName = name + "_metadata-" + projectVersion + ".yaml";
            }
            Artifact artifactObject = new Artifact();
            artifactObject.setName(artifactName);
            artifactObject.setType("synapse/metadata");
            artifactObject.setVersion(this.getAPIVersion(apiElement, projectVersion));
            artifactObject.setServerRole("EnterpriseIntegrator");
            artifactObject.setFile(metadataFileName);
            String artifactDataAsString = this.createArtifactData(artifactObject);
            String metadata = Paths.get(archiveDirectory, "metadata", metadataFolder).toString();
            org.wso2.developerstudio.eclipse.utils.file.FileUtils.createFile((File)new File(metadata, "artifact.xml"), (String)artifactDataAsString);
            if (isProxy) {
                org.wso2.developerstudio.eclipse.utils.file.FileUtils.createFile((File)new File(metadata, metadataFileName), (String)this.getProxyMetadataPropertiesAsString(apiElement, projectVersion));
            } else {
                org.wso2.developerstudio.eclipse.utils.file.FileUtils.createFile((File)new File(metadata, metadataFileName), (String)this.getAPIMetadataPropertiesAsString(apiElement, projectVersion));
            }
        }
        catch (IOException | MojoExecutionException e) {
            this.mojoInstance.logError("Error occurred while creating metadata file");
            this.mojoInstance.logError(e.getMessage());
        }
    }

    private String getAPIMetadataPropertiesAsString(OMElement apiElement, String projectVersion) {
        String version = this.getAPIVersion(apiElement, projectVersion);
        String key = apiElement.getAttributeValue(new QName("name")) + "-" + version;
        String name = apiElement.getAttributeValue(new QName("name"));
        OMAttribute descriptionAtr = apiElement.getAttribute(new QName("description"));
        StringBuilder builder = new StringBuilder();
        builder.append("---\n");
        builder.append("key: \"").append(key).append("\"\n");
        builder.append("name: \"").append(name).append("\"\n");
        builder.append("displayName: \"").append(name).append("\"\n");
        if (descriptionAtr != null) {
            builder.append("description: \"").append(descriptionAtr.getAttributeValue()).append("\"\n");
        }
        builder.append("version: \"").append(version).append("\"\n");
        builder.append("serviceUrl: \"").append(this.getAPIURL(apiElement)).append("\"\n");
        builder.append("definitionType: \"OAS3\"\n");
        builder.append("securityType: \"BASIC\"\n");
        builder.append("mutualSSLEnabled: false\n");
        return builder.toString();
    }

    private String getProxyMetadataPropertiesAsString(OMElement proxyElement, String projectVersion) {
        String key = proxyElement.getAttributeValue(new QName("name")) + "_proxy-" + projectVersion;
        String name = proxyElement.getAttributeValue(new QName("name"));
        OMAttribute descriptionAtr = proxyElement.getAttribute(new QName("description"));
        StringBuilder builder = new StringBuilder();
        builder.append("---\n");
        builder.append("key: \"").append(key).append("\"\n");
        builder.append("name: \"").append(name).append("\"\n");
        builder.append("displayName: \"").append(name).append("\"\n");
        if (descriptionAtr != null) {
            builder.append("description: \"").append(descriptionAtr.getAttributeValue()).append("\"\n");
        }
        builder.append("version: \"").append(projectVersion).append("\"\n");
        builder.append("serviceUrl: \"").append(this.getProxyServiceURL(name)).append("\"\n");
        builder.append("definitionType: \"WSDL1\"\n");
        builder.append("securityType: \"BASIC\"\n");
        builder.append("mutualSSLEnabled: false\n");
        return builder.toString();
    }

    private void addMetadataDependencies(List<ArtifactDependency> metadataDependencies, OMElement configElement, boolean isProxy, String projectVersion) {
        String dependencyName;
        String version;
        String name = configElement.getAttributeValue(new QName("name"));
        OMAttribute versionAtt = configElement.getAttribute(new QName("version"));
        if (versionAtt != null) {
            version = versionAtt.getAttributeValue();
            dependencyName = name + "_" + version + "_metadata";
        } else {
            version = projectVersion;
            if (isProxy) {
                name = name + "_proxy";
            }
            dependencyName = name + "_metadata";
        }
        metadataDependencies.add(new ArtifactDependency(dependencyName, version, "EnterpriseIntegrator", true));
    }

    private String getAPIVersion(OMElement apiElement, String projectVersion) {
        OMAttribute versionAtt = apiElement.getAttribute(new QName("version"));
        if (versionAtt != null) {
            return versionAtt.getAttributeValue();
        }
        return projectVersion;
    }

    private String getProxyServiceURL(String name) {
        return "https://{MI_HOST}:{MI_PORT}/services/" + name;
    }

    private String getAPIURL(OMElement apiElement) {
        String versionType;
        String contextAtt = apiElement.getAttribute(new QName("context")).getAttributeValue();
        OMAttribute versionTypeAtt = apiElement.getAttribute(new QName("version-type"));
        OMAttribute versionAtt = apiElement.getAttribute(new QName("version"));
        if (versionTypeAtt != null && "url".equals(versionType = versionTypeAtt.getAttributeValue())) {
            return "https://{MI_HOST}:{MI_PORT}" + contextAtt + "/" + versionAtt.getAttributeValue();
        }
        return "https://{MI_HOST}:{MI_PORT}" + contextAtt;
    }

    private String createArtifactData(Artifact artifact) throws MojoExecutionException {
        OMElement artifactElement = this.getElement("artifact", "");
        artifactElement = this.addAttribute(artifactElement, "name", artifact.getName());
        artifactElement = this.addAttribute(artifactElement, "version", artifact.getVersion());
        artifactElement = this.addAttribute(artifactElement, "type", artifact.getType());
        artifactElement = this.addAttribute(artifactElement, "serverRole", artifact.getServerRole());
        if (artifact.getConnector() != null) {
            artifactElement = this.addAttribute(artifactElement, "connector", artifact.getConnector());
        }
        OMElement fileChildElement = this.getElement("file", artifact.getFile());
        artifactElement.addChild((OMNode)fileChildElement);
        return this.serialize(artifactElement);
    }

    void createDependencyArtifactsXmlFile(String archiveDirectory, List<ArtifactDependency> dependencies, List<ArtifactDependency> metaDependencies, MavenProject project) {
        String artifactsXmlFileDataAsString;
        OMElement dependencyElement;
        OMElement artifactsElement = this.getElement("artifacts", "");
        OMElement artifactElement = this.getElement("artifact", "");
        artifactElement = this.addAttribute(artifactElement, "name", project.getArtifactId());
        artifactElement = this.addAttribute(artifactElement, "version", project.getVersion());
        artifactElement = this.addAttribute(artifactElement, "type", "carbon/application");
        if (project.getProperties().containsKey("mainSequence")) {
            artifactElement = this.addAttribute(artifactElement, "mainSequence", project.getProperties().getProperty("mainSequence"));
        }
        for (ArtifactDependency dependency : dependencies) {
            dependencyElement = this.getElement("dependency", "");
            dependencyElement = this.addAttribute(dependencyElement, "artifact", dependency.getArtifact());
            dependencyElement = this.addAttribute(dependencyElement, "version", dependency.getVersion());
            dependencyElement = this.addAttribute(dependencyElement, "include", dependency.getInclude().toString());
            if (dependency.getServerRole() != null) {
                dependencyElement = this.addAttribute(dependencyElement, "serverRole", dependency.getServerRole());
            }
            artifactElement.addChild((OMNode)dependencyElement);
        }
        artifactsElement.addChild((OMNode)artifactElement);
        try {
            artifactsXmlFileDataAsString = this.serialize(artifactsElement);
            org.wso2.developerstudio.eclipse.utils.file.FileUtils.createFile((File)new File(archiveDirectory, "artifacts.xml"), (String)artifactsXmlFileDataAsString);
        }
        catch (IOException | MojoExecutionException e) {
            this.mojoInstance.logError("Error occurred while creating artifacts.xml file");
            this.mojoInstance.logError(e.getMessage());
        }
        for (ArtifactDependency dependency : metaDependencies) {
            dependencyElement = this.getElement("dependency", "");
            dependencyElement = this.addAttribute(dependencyElement, "artifact", dependency.getArtifact());
            dependencyElement = this.addAttribute(dependencyElement, "version", dependency.getVersion());
            dependencyElement = this.addAttribute(dependencyElement, "include", dependency.getInclude().toString());
            if (dependency.getServerRole() != null) {
                dependencyElement = this.addAttribute(dependencyElement, "serverRole", dependency.getServerRole());
            }
            artifactElement.addChild((OMNode)dependencyElement);
        }
        artifactsElement.addChild((OMNode)artifactElement);
        try {
            artifactsXmlFileDataAsString = this.serialize(artifactsElement);
            org.wso2.developerstudio.eclipse.utils.file.FileUtils.createFile((File)new File(archiveDirectory, "metadata.xml"), (String)artifactsXmlFileDataAsString);
        }
        catch (IOException | MojoExecutionException e) {
            this.mojoInstance.logError("Error occurred while creating metadata.xml file");
            this.mojoInstance.logError(e.getMessage());
        }
    }

    void processClassMediators(List<ArtifactDependency> dependencies, MavenProject project) {
        String jarName = project.getArtifactId() + "-" + project.getVersion() + ".jar";
        File jarFile = new File(Paths.get(project.getBasedir().toString(), "target", jarName).toString());
        if (jarFile.exists()) {
            dependencies.add(new ArtifactDependency(project.getArtifactId() + "_class_mediators", project.getVersion(), "EnterpriseIntegrator", true));
            this.writeArtifactAndFile(jarFile, project.getBasedir().toString() + File.separator + "tmp", project.getArtifactId() + "_class_mediators", "lib/synapse/mediator", "EnterpriseIntegrator", project.getVersion(), jarName, project.getArtifactId() + "_class_mediators" + "_" + project.getVersion());
            jarFile.delete();
        }
    }

    void processConnectorLibDependencies(List<ArtifactDependency> dependencies, MavenProject project) {
        File[] dependencyFiles;
        File connectorDepFolder = new File(Paths.get(project.getBasedir().toString(), "target", "dependency").toString());
        if (connectorDepFolder.exists() && (dependencyFiles = connectorDepFolder.listFiles()) != null) {
            for (File dependencyFile : dependencyFiles) {
                if (!dependencyFile.isFile() || !dependencyFile.getName().endsWith(".zip")) continue;
                String fileName = dependencyFile.getName();
                int lastIndex = fileName.lastIndexOf(45);
                String name = fileName.substring(0, lastIndex);
                String version = fileName.substring(lastIndex + 1, fileName.length() - ".zip".length());
                dependencies.add(new ArtifactDependency(name, version, "EnterpriseIntegrator", true));
                this.writeArtifactAndFile(dependencyFile, project.getBasedir().toString() + File.separator + "tmp", name, "synapse/lib", "EnterpriseIntegrator", version, fileName, name + "_" + version);
            }
        }
        if (MavenUtils.ignoreConnectorDependencies(project)) {
            this.mojoInstance.getLog().info((CharSequence)"The connector dependencies are not bundled as the runtime version is less than 4.4.0");
            return;
        }
        File libFolder = new File(project.getBasedir(), "target" + File.separator + "libs");
        if (!libFolder.exists()) {
            return;
        }
        File[] connectorDeps = libFolder.listFiles();
        if (connectorDeps == null) {
            return;
        }
        for (File connectorDir : connectorDeps) {
            if (!connectorDir.isDirectory()) continue;
            String connectorName = connectorDir.getName();
            File[] libFiles = connectorDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            if (libFiles == null) continue;
            for (File libFile : libFiles) {
                String fileNameWithoutExt = libFile.getName().substring(0, libFile.getName().length() - 4);
                dependencies.add(new ArtifactDependency(fileNameWithoutExt, project.getVersion(), "EnterpriseIntegrator", true));
                this.writeArtifactAndFile(libFile, project.getBasedir() + File.separator + "tmp", fileNameWithoutExt, "lib/connector/dependency", "EnterpriseIntegrator", project.getVersion(), libFile.getName(), connectorName + "_" + fileNameWithoutExt, connectorName);
            }
        }
    }

    protected void deserialize(OMElement documentElement) throws Exception {
    }

    protected String serialize() throws Exception {
        return null;
    }

    private String serialize(OMElement element) throws MojoExecutionException {
        OMDocument document = factory.createOMDocument();
        document.addChild((OMNode)element);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            CAppHandler.prettify((OMElement)element, (OutputStream)outputStream);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error serializing", e);
        }
        return outputStream.toString();
    }

    private boolean isApiDefinitionPresent(String apiName, String apiVersion, boolean apiVersionExists, List<ArtifactDependency> metadataDependencies) {
        apiName = apiVersionExists ? apiName + "_" + apiVersion + "_swagger" : apiName + "_swagger";
        for (ArtifactDependency dependency : metadataDependencies) {
            if (!dependency.getArtifact().equals(apiName) || !dependency.getVersion().equals(apiVersion)) continue;
            return true;
        }
        return false;
    }

    protected String getDefaultName() {
        return null;
    }
}

