/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.datamapper;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.wso2.maven.CARMojo;
import org.wso2.maven.MavenUtils;
import org.wso2.maven.datamapper.Constants;
import org.wso2.maven.datamapper.DataMapperException;

public class DataMapperBundler {
    private final CARMojo mojoInstance;
    private final String sourceDirectory;
    private final String resourcesDirectory;
    private final String projectDirectory;
    private final Invoker invoker;

    public DataMapperBundler(CARMojo mojoInstance, String projectDirectory, String sourceDirectory, String resourcesDirectory) {
        this.mojoInstance = mojoInstance;
        this.sourceDirectory = sourceDirectory;
        this.resourcesDirectory = resourcesDirectory;
        this.projectDirectory = projectDirectory;
        this.invoker = new DefaultInvoker();
    }

    public void bundleDataMapper() throws DataMapperException, MojoExecutionException {
        String oldDataMapperDirectoryPath = this.resourcesDirectory + File.separator + Constants.DATA_MAPPER_DIR_PATH;
        String newDataMapperDirectoryPath = this.resourcesDirectory + File.separator + "datamapper";
        List<Path> dataMappers = this.listSubDirectories(oldDataMapperDirectoryPath);
        dataMappers.addAll(this.listSubDirectories(newDataMapperDirectoryPath));
        if (dataMappers.isEmpty()) {
            return;
        }
        this.appendDataMapperLogs();
        this.createDataMapperArtifacts();
        MavenUtils.setupInvoker(this.invoker, this.projectDirectory);
        this.installNodeAndNPM();
        this.runNpmInstall();
        this.configureNpm();
        this.bundleDataMappers(dataMappers);
        this.generateDataMapperSchemas(dataMappers);
        this.removeBundlingArtifacts();
        this.copyDataMapperFilesToTarget();
    }

    public void deleteGeneratedDatamapperArtifacts() throws DataMapperException {
        String olDataMapperDirectoryPath = this.resourcesDirectory + File.separator + Constants.DATA_MAPPER_DIR_PATH;
        String newDataMapperDirectoryPath = this.resourcesDirectory + File.separator + "datamapper";
        List<Path> dataMappers = this.listSubDirectories(olDataMapperDirectoryPath);
        dataMappers.addAll(this.listSubDirectories(newDataMapperDirectoryPath));
        if (dataMappers.isEmpty()) {
            return;
        }
        for (Path dataMapper : dataMappers) {
            String dataMapperName;
            Path tsFilePath = dataMapper.resolve((dataMapperName = dataMapper.getFileName().toString()) + ".ts");
            if (Files.notExists(tsFilePath, new LinkOption[0])) {
                return;
            }
            Path bundledJsFilePath = Paths.get(dataMapper + File.separator + dataMapperName + ".dmc", new String[0]);
            Path inputSchemaFilePath = Paths.get(dataMapper + File.separator + dataMapperName + "_inputSchema.json", new String[0]);
            Path outputSchemaFilePath = Paths.get(dataMapper + File.separator + dataMapperName + "_outputSchema.json", new String[0]);
            try {
                Files.deleteIfExists(bundledJsFilePath);
                Files.deleteIfExists(inputSchemaFilePath);
                Files.deleteIfExists(outputSchemaFilePath);
            }
            catch (IOException e) {
                throw new DataMapperException("Failed to delete generated data mapper artifacts.", e);
            }
        }
    }

    private void installNodeAndNPM() throws DataMapperException {
        InvocationRequest request = this.createBaseRequest();
        this.mojoInstance.logInfo("Installing Node and NPM");
        request.setGoals(Collections.singletonList("com.github.eirslett:frontend-maven-plugin:1.12.0:install-node-and-npm"));
        this.setNodeAndNpmProperties(request);
        this.executeRequest(request, "Node and NPM installation failed.");
    }

    private void runNpmInstall() throws DataMapperException {
        InvocationRequest request = this.createBaseRequest();
        this.mojoInstance.logInfo("Running npm install");
        request.setGoals(Collections.singletonList("com.github.eirslett:frontend-maven-plugin:1.12.0:npm"));
        this.setNpmInstallProperties(request);
        this.executeRequest(request, "npm install failed.");
    }

    private void configureNpm() throws DataMapperException {
        InvocationRequest request = this.createBaseRequest();
        this.mojoInstance.logInfo("Configuring npm");
        request.setGoals(Collections.singletonList("com.github.eirslett:frontend-maven-plugin:1.12.0:npm"));
        Properties properties = new Properties();
        properties.setProperty("arguments", "config set scripts-prepend-node-path auto");
        request.setProperties(properties);
        this.executeRequest(request, "npm configuration failed.");
    }

    private void bundleDataMappers(List<Path> dataMappers) throws DataMapperException {
        for (Path dataMapper : dataMappers) {
            if (this.bundleSingleDataMapper(dataMapper)) continue;
            return;
        }
        this.mojoInstance.logInfo("Data mapper bundling completed successfully");
    }

    private void generateDataMapperSchemas(List<Path> dataMappers) throws DataMapperException {
        this.createConfigJsonForSchemaGeneration();
        for (Path dataMapper : dataMappers) {
            this.generateDataMapperSchema(dataMapper.toAbsolutePath());
        }
    }

    private void copyDataMapperFilesToTarget() throws DataMapperException {
        Path oldDataMapperPath = Paths.get(this.resourcesDirectory + File.separator + Constants.DATA_MAPPER_DIR_PATH, new String[0]);
        Path newDataMapperPath = Paths.get(this.resourcesDirectory + File.separator + "datamapper", new String[0]);
        try {
            if (Files.exists(oldDataMapperPath, new LinkOption[0])) {
                FileUtils.copyDirectory((File)oldDataMapperPath.toFile(), (File)Paths.get("." + File.separator + "target" + File.separator + "datamapper", new String[0]).toFile());
            }
            if (Files.exists(newDataMapperPath, new LinkOption[0])) {
                FileUtils.copyDirectory((File)newDataMapperPath.toFile(), (File)Paths.get("." + File.separator + "target" + File.separator + "datamapper", new String[0]).toFile());
            }
        }
        catch (IOException e) {
            throw new DataMapperException("Failed to copy data mapper files to target directory.", e);
        }
    }

    private boolean bundleSingleDataMapper(Path dataMapper) throws DataMapperException {
        this.copyTsFiles(dataMapper);
        String dataMapperName = dataMapper.getFileName().toString();
        this.mojoInstance.logInfo("Bundling data mapper: " + dataMapperName);
        this.createWebpackConfig(dataMapperName);
        Path npmDirectory = Paths.get("." + File.separator + "target", new String[0]);
        InvocationRequest request = this.createBaseRequest();
        request.setBaseDirectory(npmDirectory.toFile());
        request.setGoals(Collections.singletonList("org.codehaus.mojo:exec-maven-plugin:1.6.0:exec@build -Dexec.executable=\"" + this.getNpmExecutablePath() + "\" -Dexec.args=\"" + "run build" + " " + "--scripts-prepend-node-path=auto" + "\""));
        this.executeRequest(request, "Failed to bundle data mapper: " + dataMapperName);
        this.mojoInstance.logInfo("Bundle completed for data mapper: " + dataMapperName);
        Path bundledJsFilePath = Paths.get("." + File.separator + "target" + File.separator + "src" + File.separator + dataMapperName + ".dmc", new String[0]);
        this.appendMapFunction(dataMapper.toString(), dataMapperName, bundledJsFilePath.toString());
        this.copyGenerateDataMapperFile(bundledJsFilePath.toString(), dataMapper);
        this.removeSourceFiles();
        this.removeWebpackConfig();
        return true;
    }

    private void generateDataMapperSchema(Path dataMapper) throws DataMapperException {
        String dataMapperName = dataMapper.getFileName().toString();
        this.mojoInstance.logInfo("Generating schema for data mapper: " + dataMapperName);
        Path npmDirectory = Paths.get("." + File.separator + "target", new String[0]);
        InvocationRequest request = this.createBaseRequest();
        request.setBaseDirectory(npmDirectory.toFile());
        request.setGoals(Collections.singletonList("org.codehaus.mojo:exec-maven-plugin:1.6.0:exec@build -Dexec.executable=\"" + this.getNpmExecutablePath() + "\" -Dexec.args=\"" + "run generate" + " " + dataMapper + File.separator + dataMapperName + ".ts " + "--scripts-prepend-node-path=auto" + "\""));
        this.executeRequest(request, "Failed to bundle data mapper: " + dataMapperName);
    }

    private String getNpmExecutablePath() {
        String osName = System.getProperty("os.name").toLowerCase();
        String npmExecutable = osName.contains("win") ? "npm.cmd" : "npm";
        return Paths.get(System.getProperty("user.dir"), "target", "node", npmExecutable).toString();
    }

    private InvocationRequest createBaseRequest() {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        Path baseDir = Paths.get(System.getProperty("user.dir"), new String[0]);
        Path pomPath = baseDir.resolve(Paths.get("." + File.separator + "target" + File.separator + "pom.xml", new String[0]));
        request.setPomFile(pomPath.toFile());
        request.setInputStream((InputStream)new ByteArrayInputStream(new byte[0]));
        return request;
    }

    private void setNodeAndNpmProperties(InvocationRequest request) {
        Properties properties = new Properties();
        properties.setProperty("nodeVersion", "v14.17.3");
        properties.setProperty("npmVersion", "6.14.13");
        request.setProperties(properties);
    }

    private void setNpmInstallProperties(InvocationRequest request) {
        Properties properties = new Properties();
        properties.setProperty("arguments", "install");
        request.setProperties(properties);
    }

    private void executeRequest(InvocationRequest request, String errorMessage) throws DataMapperException {
        try {
            InvocationResult result = this.invoker.execute(request);
            if (result.getExitCode() != 0) {
                this.mojoInstance.logError(errorMessage);
                if (result.getExecutionException() != null) {
                    this.mojoInstance.logError(result.getExecutionException().getMessage());
                }
                throw new DataMapperException(errorMessage);
            }
        }
        catch (MavenInvocationException e) {
            throw new DataMapperException(errorMessage, e);
        }
    }

    private void createDataMapperArtifacts() throws DataMapperException {
        this.mojoInstance.logInfo("Creating data mapper artifacts");
        this.ensureDataMapperTargetExists();
        this.createPomFile();
        this.createPackageJson();
        this.createConfigJson();
        this.createSchemaGenerator();
    }

    private void appendDataMapperLogs() {
        this.mojoInstance.getLog().info((CharSequence)"------------------------------------------------------------------------");
        this.mojoInstance.getLog().info((CharSequence)"Bundling Data Mapper");
        this.mojoInstance.getLog().info((CharSequence)"------------------------------------------------------------------------");
    }

    private void createPomFile() throws DataMapperException {
        String pomContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\n         xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n    <modelVersion>4.0.0</modelVersion>\n    <groupId>org.example</groupId>\n    <artifactId>data-mapper-bundler</artifactId>\n    <version>1.0-SNAPSHOT</version>\n</project>";
        Path pomPath = Paths.get("." + File.separator + "target" + File.separator + "pom.xml", new String[0]);
        try {
            Files.write(pomPath, pomContent.getBytes(), StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            throw new DataMapperException("Failed to create pom.xml file.", e);
        }
    }

    public void createSchemaGenerator() throws DataMapperException {
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("schemaGenerator.ts");
            String targetPath = "." + File.separator + "target" + File.separator + "schemaGenerator.ts";
            File targetFile = new File(targetPath);
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)targetFile);
        }
        catch (IOException e) {
            throw new DataMapperException("Failed to read schemaGenerator.ts file.", e);
        }
    }

    private void createPackageJson() throws DataMapperException {
        String packageJsonContent = "{\n    \"name\": \"data-mapper-bundler\",\n    \"version\": \"1.0.0\",\n    \"scripts\": {\n        \"build\": \"tsc && webpack\",\n        \"generate\": \" tsc -p . && node schemaGenerator.js \"\n    },\n    \"devDependencies\": {\n        \"typescript\": \"^4.4.2\",\n        \"webpack\": \"^5.52.0\",\n        \"webpack-cli\": \"^4.8.0\",\n        \"ts-loader\": \"^9.2.3\"\n    }\n}";
        try (FileWriter fileWriter = new FileWriter("." + File.separator + "target" + File.separator + "package.json");){
            fileWriter.write(packageJsonContent);
        }
        catch (IOException e) {
            throw new DataMapperException("Failed to create package.json file.", e);
        }
    }

    private void createConfigJson() throws DataMapperException {
        String tsConfigContent = "{\n    \"compilerOptions\": {\n        \"outDir\": \"./target\",\n        \"module\": \"commonjs\",\n        \"target\": \"es5\",\n        \"sourceMap\": true\n    },\n    \"include\": [\n        \"./src/**/*\"\n    ]\n}";
        try (FileWriter fileWriter = new FileWriter("." + File.separator + "target" + File.separator + "tsconfig.json");){
            fileWriter.write(tsConfigContent);
        }
        catch (IOException e) {
            throw new DataMapperException("Failed to create tsconfig.json file.", e);
        }
    }

    private void createConfigJsonForSchemaGeneration() throws DataMapperException {
        String tsConfigContent = "{\n    \"include\": [     \"schemaGenerator.ts\" ],    \"exclude\": [     \"node_modules\" ],    \"compilerOptions\": {\n        \"module\": \"commonjs\",\n        \"target\": \"es5\",\n        \"sourceMap\": true,\n        \"esModuleInterop\": true\n    }\n}";
        try (FileWriter fileWriter = new FileWriter("." + File.separator + "target" + File.separator + "tsconfig.json");){
            fileWriter.write(tsConfigContent);
        }
        catch (IOException e) {
            throw new DataMapperException("Failed to create tsconfig.json file.", e);
        }
    }

    private void createWebpackConfig(String dataMapperName) throws DataMapperException {
        String webPackConfigContent = "const path = require(\"path\");\nmodule.exports = {\n    entry: \"./src/" + dataMapperName + ".ts\",\n    module: {\n        rules: [\n            {\n                test: /\\.tsx?$/,\n                use: \"ts-loader\",\n                exclude: /node_modules/,\n            }\n        ],\n    },\n    resolve: {\n        extensions: [\".ts\", \".js\"],\n    },\n    output: {\n        filename: \"./src/" + dataMapperName + ".dmc\",\n        path: path.resolve(__dirname),\n        iife: false,\n        library: 'DataMapper', \n        libraryTarget: 'var',\n    },\n    mode: \"production\",\n};";
        try (FileWriter fileWriter = new FileWriter("." + File.separator + "target" + File.separator + "webpack.config.js");){
            fileWriter.write(webPackConfigContent);
        }
        catch (IOException e) {
            throw new DataMapperException("Failed to create webpack.config.js file.", e);
        }
    }

    private void appendMapFunction(String tsFolder, String datamapperName, String dmcPath) {
        String mapFunction = this.generateMapFunction(tsFolder + File.separator + datamapperName + ".ts");
        try (FileWriter fileWriter = new FileWriter(dmcPath, true);){
            fileWriter.write(mapFunction);
        }
        catch (IOException e) {
            this.mojoInstance.logError("Failed to append map function to the bundled js file.");
        }
    }

    private String generateMapFunction(String tsPath) {
        String functionName = "";
        String inputVariable = "";
        try (BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(tsPath, new String[0]), new OpenOption[0])));){
            String line;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("*") && line.contains("functionName") && line.contains("map_")) {
                    functionName = line.split(":")[1].trim();
                }
                if (!line.startsWith("*") || !line.contains("inputVariable")) continue;
                inputVariable = line.split(":")[1].trim();
            }
        }
        catch (IOException e) {
            this.mojoInstance.logError("Failed to read the file.");
        }
        String mapFunction = "\n\nfunction mapFunction(input) {\n    return DataMapper.mapFunction(input);\n}\n\n";
        if (!functionName.isEmpty() && !inputVariable.isEmpty()) {
            mapFunction = mapFunction + "function " + functionName + "() {\n    return mapFunction(" + inputVariable + ");\n}\n";
        }
        return mapFunction;
    }

    private List<Path> listSubDirectories(String directory) throws DataMapperException {
        Path dirPath = Paths.get(directory, new String[0]);
        ArrayList<Path> subDirectories = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dirPath);){
            for (Path path : stream) {
                if (!Files.isDirectory(path, new LinkOption[0]) || path.equals(dirPath) || !this.isDataMapperDirectory(path)) continue;
                subDirectories.add(path);
            }
        }
        catch (NoSuchFileException e) {
            this.mojoInstance.logInfo("datamapper directory not found");
        }
        catch (IOException e) {
            throw new DataMapperException("Failed to find data mapper directories.", e);
        }
        return subDirectories;
    }

    private boolean isDataMapperDirectory(Path path) {
        String dirName = path.getFileName().toString();
        return Files.exists(Paths.get(path.toString(), dirName + ".ts"), new LinkOption[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyTsFiles(Path sourceDir) throws DataMapperException {
        Path destDir = Paths.get("." + File.separator + "target" + File.separator + "src", new String[0]);
        try {
            Files.createDirectories(destDir, new FileAttribute[0]);
            final ArrayList fileList = new ArrayList();
            Files.walkFileTree(sourceDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (file.toString().endsWith(".ts")) {
                        fileList.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            for (Path sourcePath : fileList) {
                Path destPath = destDir.resolve(sourceDir.relativize(sourcePath));
                try {
                    Files.copy(sourcePath, destPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new DataMapperException("Failed to copy data mapper file: " + sourcePath, e);
                    return;
                }
            }
        }
        catch (IOException e) {
            throw new DataMapperException("Failed to copy data mapper files.", e);
        }
    }

    private void writeSchemaToFile(String content, String path) throws DataMapperException {
        try (FileWriter fileWriter = new FileWriter(path);){
            fileWriter.write(content);
        }
        catch (IOException e) {
            throw new DataMapperException("Failed to create file: " + path, e);
        }
    }

    private void copyGenerateDataMapperFile(String sourceFile, Path destinationDir) throws DataMapperException {
        this.mojoInstance.logInfo("Copying bundled js file to registry");
        Path sourcePath = Paths.get(sourceFile, new String[0]);
        Path destPath = destinationDir.resolve(sourcePath.getFileName());
        try {
            Files.copy(sourcePath, destPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new DataMapperException("Failed to copy bundled js file to registry.", e);
        }
    }

    private void ensureDataMapperTargetExists() throws DataMapperException {
        Path dataMapperPath = Paths.get("." + File.separator + "target", new String[0]);
        if (!Files.exists(dataMapperPath, new LinkOption[0])) {
            try {
                Files.createDirectories(dataMapperPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new DataMapperException("Failed to create data-mapper artifacts directory: " + dataMapperPath, e);
            }
        }
    }

    private void removeSourceFiles() throws DataMapperException {
        Path dataMapperPath = Paths.get("." + File.separator + "target" + File.separator + "src", new String[0]);
        try {
            Files.walkFileTree(dataMapperPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new DataMapperException("Error while removing data-mapper source directory.", e);
        }
    }

    private void removeWebpackConfig() throws DataMapperException {
        Path filePath = Paths.get("." + File.separator + "target" + File.separator + "webpack.config.js", new String[0]);
        try {
            Files.delete(filePath);
        }
        catch (IOException e) {
            throw new DataMapperException("Error while removing webpack.config.js file.", e);
        }
    }

    private void removeBundlingArtifacts() {
        this.mojoInstance.logInfo("Cleaning up data mapper bundling artifacts");
        String[] pathsToDelete = new String[]{"." + File.separator + "target"};
        String excludeRegex = ".*\\.jar";
        for (String path : pathsToDelete) {
            File file = new File(path);
            this.deleteRecursively(file, excludeRegex);
        }
    }

    private void deleteRecursively(File file, String excludeRegex) {
        File[] entries;
        if (this.isInsideSourceDirectory(file)) {
            return;
        }
        if (file.isDirectory() && (entries = file.listFiles()) != null) {
            for (File entry : entries) {
                this.deleteRecursively(entry, excludeRegex);
            }
        }
        if (!(excludeRegex != null && file.getAbsolutePath().matches(excludeRegex) || file.delete())) {
            this.mojoInstance.logError("Failed to delete " + file.getPath());
        }
    }

    private boolean isInsideSourceDirectory(File file) {
        Path sourcePath = Paths.get(this.sourceDirectory, new String[0]).toAbsolutePath().normalize();
        Path filePath = file.toPath().toAbsolutePath().normalize();
        return filePath.startsWith(sourcePath);
    }
}

