/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.secvault.reader;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.secvault.MasterKey;
import org.wso2.carbon.secvault.MasterKeyReader;
import org.wso2.carbon.secvault.exception.SecureVaultException;
import org.wso2.carbon.secvault.model.MasterKeyReaderConfiguration;
import org.wso2.carbon.secvault.model.masterkey.MasterKeyConfiguration;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.introspector.BeanAccess;

@Component(name="org.wso2.carbon.secvault.reader.DefaultMasterKeyReader", immediate=true)
public class DefaultMasterKeyReader
implements MasterKeyReader {
    private static Logger logger = LoggerFactory.getLogger(DefaultMasterKeyReader.class);
    private Set<String> relocationPaths = new HashSet<String>();
    private MasterKeyReaderConfiguration masterKeyReaderConfiguration;

    @Activate
    public void activate() {
        logger.debug("Activating DefaultMasterKeyReader");
    }

    @Deactivate
    public void deactivate() {
        logger.debug("Deactivating DefaultMasterKeyReader");
    }

    @Override
    public void init(MasterKeyReaderConfiguration masterKeyReaderConfiguration) throws SecureVaultException {
        this.masterKeyReaderConfiguration = masterKeyReaderConfiguration;
    }

    @Override
    public void readMasterKeys(List<MasterKey> masterKeys) throws SecureVaultException {
        Path masterKeysFilePath = Paths.get(this.masterKeyReaderConfiguration.getParameter("masterKeyReaderFile").orElseThrow(() -> new SecureVaultException("Master keys YAML path not found")), new String[0]);
        if (Files.exists(masterKeysFilePath, new LinkOption[0])) {
            this.readMasterKeysFile(masterKeysFilePath, masterKeys);
        }
        this.readMasterKeysFromEnvironment(masterKeys);
        this.readMasterKeysFromSystem(masterKeys);
        if (!this.fullyInitialized(masterKeys)) {
            this.readMasterKeysFromConsole(masterKeys);
        }
    }

    private void readMasterKeysFromEnvironment(List<MasterKey> masterKeys) throws SecureVaultException {
        masterKeys.forEach(masterKey -> {
            logger.debug("Reading master key '{}' from environment variables.", (Object)masterKey.getMasterKeyName());
            Optional.ofNullable(System.getenv(masterKey.getMasterKeyName())).ifPresent(s2 -> masterKey.setMasterKeyValue(s2.toCharArray()));
        });
    }

    private void readMasterKeysFromSystem(List<MasterKey> masterKeys) throws SecureVaultException {
        masterKeys.forEach(masterKey -> {
            logger.debug("Reading master key '{}' from system properties.", (Object)masterKey.getMasterKeyName());
            Optional.ofNullable(System.getProperty(masterKey.getMasterKeyName())).ifPresent(s2 -> masterKey.setMasterKeyValue(s2.toCharArray()));
        });
    }

    private void readMasterKeysFile(Path masterKeysFilePath, List<MasterKey> masterKeys) throws SecureVaultException {
        try (FileInputStream inputStream = new FileInputStream(masterKeysFilePath.toFile());
             BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));){
            Yaml yaml = new Yaml(new CustomClassLoaderConstructor(MasterKeyConfiguration.class, MasterKeyConfiguration.class.getClassLoader()));
            yaml.setBeanAccess(BeanAccess.FIELD);
            MasterKeyConfiguration masterKeyConfiguration = Optional.ofNullable(yaml.loadAs(bufferedReader, MasterKeyConfiguration.class)).orElseThrow(() -> new SecureVaultException("Unable to load master-keys.yaml file"));
            if (!masterKeyConfiguration.getRelocation().isEmpty()) {
                logger.debug("Master key relocation : {}", (Object)masterKeyConfiguration.getRelocation());
                if (this.relocationPaths.contains(masterKeysFilePath.toString())) {
                    throw new SecureVaultException("Cyclic dependency detected on Master Key relocation path");
                }
                this.relocationPaths.add(masterKeysFilePath.toString());
                Path path = Paths.get(masterKeyConfiguration.getRelocation(), new String[0]);
                this.readMasterKeysFile(path, masterKeys);
                return;
            }
            Properties properties = Optional.ofNullable(masterKeyConfiguration.getMasterKeys()).orElseThrow(() -> new SecureVaultException("masterKeys section of master-keys.yaml is empty"));
            if (properties.isEmpty()) {
                throw new SecureVaultException("master-keys.yaml file is doesn't contain any master key " + masterKeysFilePath.toFile());
            }
            for (MasterKey masterKey : masterKeys) {
                logger.debug("Reading master key '{}' from file.", (Object)masterKey.getMasterKeyName());
                byte[] masterKeyValue = (byte[])Optional.ofNullable(properties.get(masterKey.getMasterKeyName())).orElseThrow(() -> new SecureVaultException("Master Key value not found for : " + masterKey.getMasterKeyName()));
                ByteBuffer byteBuffer = ByteBuffer.wrap(masterKeyValue);
                CharBuffer charBuffer = StandardCharsets.UTF_8.decode(byteBuffer);
                masterKey.setMasterKeyValue(charBuffer.array());
            }
            ((InputStream)inputStream).close();
            if (this.relocationPaths.isEmpty() && !masterKeyConfiguration.isPermanent() && !masterKeysFilePath.toFile().delete()) {
                masterKeysFilePath.toFile().deleteOnExit();
            }
        }
        catch (IOException e) {
            throw new SecureVaultException("Failed to load master-keys.yaml file " + masterKeysFilePath.toFile(), e);
        }
    }

    private void readMasterKeysFromConsole(List<MasterKey> masterKeys) throws SecureVaultException {
        Optional.ofNullable(System.console()).ifPresent(console -> masterKeys.stream().filter(masterKey -> !masterKey.getMasterKeyValue().isPresent()).forEach(uninitializedMasterKey -> {
            logger.debug("Reading master key '{}' from console.", (Object)uninitializedMasterKey.getMasterKeyName());
            uninitializedMasterKey.setMasterKeyValue(console.readPassword("[%s]", "Enter master key '" + uninitializedMasterKey.getMasterKeyName() + "' :"));
        }));
    }

    private boolean fullyInitialized(List<MasterKey> masterKeys) {
        return masterKeys.parallelStream().allMatch(masterKey -> masterKey.getMasterKeyValue().isPresent());
    }
}

