/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.common.certificatevalidation.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contractimpl.common.certificatevalidation.cache.ManageableCache;
import org.wso2.transport.http.netty.contractimpl.common.certificatevalidation.cache.ManageableCacheValue;

public class CacheManager {
    private static final boolean DO_NOT_INTERRUPT_IF_RUNNING = false;
    private ScheduledExecutorService scheduler;
    private ScheduledFuture scheduledFuture = null;
    private ManageableCache cache;
    private int cacheMaxSize;
    private int delay;
    private CacheManagingTask cacheManagingTask;
    private static final Logger LOG = LoggerFactory.getLogger(CacheManager.class);

    public CacheManager(ManageableCache cache, int cacheMaxSize, int delay) {
        int numThreads = 1;
        this.scheduler = Executors.newScheduledThreadPool(numThreads);
        this.cache = cache;
        this.cacheMaxSize = cacheMaxSize;
        this.cacheManagingTask = new CacheManagingTask();
        this.delay = delay;
        this.start();
    }

    private boolean start() {
        if (this.scheduledFuture == null || this.scheduledFuture.isCancelled()) {
            this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(this.cacheManagingTask, this.delay, this.delay, TimeUnit.MINUTES);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Cache Manager Started.", (Object)this.cache.getClass().getSimpleName());
            }
            return true;
        }
        return false;
    }

    public boolean wakeUpNow() {
        if (this.scheduledFuture != null) {
            if (!this.scheduledFuture.isCancelled()) {
                this.scheduledFuture.cancel(false);
            }
            this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(this.cacheManagingTask, 0L, this.delay, TimeUnit.MINUTES);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Cache Manager woke up.", (Object)this.cache.getClass().getSimpleName());
            }
            return true;
        }
        return false;
    }

    public boolean changeDelay(int delay) {
        int min2 = 1;
        int max = 1440;
        if (delay < min2 || delay > max) {
            throw new IllegalArgumentException("Delay time should should be between " + min2 + " and " + max + " minutes");
        }
        this.delay = delay;
        return this.wakeUpNow();
    }

    public int getDelay() {
        return this.delay;
    }

    public boolean stop() {
        if (this.scheduledFuture != null && !this.scheduledFuture.isCancelled()) {
            this.scheduledFuture.cancel(false);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Cache Manager stopped.", (Object)this.cache.getClass().getSimpleName());
            }
            return true;
        }
        return false;
    }

    public boolean isRunning() {
        return !this.scheduledFuture.isCancelled();
    }

    private class CacheManagingTask
    implements Runnable {
        private CacheManagingTask() {
        }

        @Override
        public void run() {
            int cacheSize;
            long start = System.currentTimeMillis();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Cache Manager Task Started.", (Object)CacheManager.this.cache.getClass().getSimpleName());
            }
            int numberToRemove = (cacheSize = CacheManager.this.cache.getCacheSize()) > CacheManager.this.cacheMaxSize ? cacheSize - CacheManager.this.cacheMaxSize : 0;
            ArrayList<ManageableCacheValue> entriesToRemove = new ArrayList<ManageableCacheValue>();
            LRUEntryCollector lruEntryCollector = new LRUEntryCollector(entriesToRemove, numberToRemove);
            CacheManager.this.cache.resetIterator();
            while (cacheSize-- > 0) {
                ManageableCacheValue nextCacheValue = CacheManager.this.cache.getNextCacheValue();
                if (nextCacheValue == null) {
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug("Cache manager iteration through Cache values done");
                    break;
                }
                if (!nextCacheValue.isValid()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Updating Invalid Cache Value by Manager");
                    }
                    nextCacheValue.updateCacheWithNewValue();
                }
                if (numberToRemove <= 0) continue;
                lruEntryCollector.collectEntriesToRemove(nextCacheValue);
            }
            for (ManageableCacheValue oldCacheValue : entriesToRemove) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Removing LRU value from cache");
                }
                oldCacheValue.removeThisCacheValue();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(CacheManager.this.cache.getClass().getSimpleName() + " Cache Manager Task Done. Took " + (System.currentTimeMillis() - start) + " ms.");
            }
        }

        private class LRUEntryCollector {
            private List<ManageableCacheValue> entriesToRemove;
            private int listMaxSize;

            LRUEntryCollector(List<ManageableCacheValue> entriesToRemove, int numberToRemove) {
                this.entriesToRemove = entriesToRemove;
                this.listMaxSize = numberToRemove;
            }

            private void collectEntriesToRemove(ManageableCacheValue value) {
                int j;
                this.entriesToRemove.add(value);
                for (j = this.entriesToRemove.size() - 1; j > 0 && value.getTimeStamp() < this.entriesToRemove.get(j - 1).getTimeStamp(); --j) {
                    this.entriesToRemove.remove(j);
                    this.entriesToRemove.add(j, this.entriesToRemove.get(j - 1));
                }
                this.entriesToRemove.remove(j);
                this.entriesToRemove.add(j, value);
                if (this.entriesToRemove.size() > this.listMaxSize) {
                    this.entriesToRemove.remove(this.entriesToRemove.size() - 1);
                }
            }
        }
    }
}

