/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.common.disruptor.handler;

import java.util.concurrent.locks.Lock;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.transport.http.netty.common.disruptor.event.CarbonDisruptorEvent;
import org.wso2.carbon.transport.http.netty.common.disruptor.handler.DisruptorEventHandler;
import org.wso2.carbon.transport.http.netty.internal.NettyTransportContextHolder;

public class CarbonDisruptorEventHandler
extends DisruptorEventHandler {
    @Override
    public void onEvent(CarbonDisruptorEvent carbonDisruptorEvent, long l, boolean b) throws Exception {
        CarbonMessage carbonMessage = (CarbonMessage)carbonDisruptorEvent.getEvent();
        Lock lock = carbonMessage.getLock();
        if (carbonMessage.getProperty("DIRECTION") == null) {
            if (lock.tryLock()) {
                CarbonCallback carbonCallback = (CarbonCallback)carbonMessage.getProperty("CALL_BACK");
                NettyTransportContextHolder.getInstance().getMessageProcessor().receive(carbonMessage, carbonCallback);
            }
        } else if (carbonMessage.getProperty("DIRECTION").equals("DIRECTION_RESPONSE") && lock.tryLock()) {
            CarbonCallback carbonCallback = (CarbonCallback)carbonMessage.getProperty("CALL_BACK");
            carbonCallback.done(carbonMessage);
        }
    }

    @Override
    public void onEvent(Object o) throws Exception {
        if (o instanceof CarbonDisruptorEvent) {
            CarbonMessage carbonMessage = (CarbonMessage)((CarbonDisruptorEvent)o).getEvent();
            if (carbonMessage.getProperty("DIRECTION") == null) {
                CarbonCallback carbonCallback = (CarbonCallback)carbonMessage.getProperty("CALL_BACK");
                NettyTransportContextHolder.getInstance().getMessageProcessor().receive(carbonMessage, carbonCallback);
            } else if (carbonMessage.getProperty("DIRECTION").equals("DIRECTION_RESPONSE")) {
                CarbonCallback carbonCallback = (CarbonCallback)carbonMessage.getProperty("CALL_BACK");
                carbonCallback.done(carbonMessage);
            }
        }
    }
}

