/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j;

import java.util.HashMap;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.transports.TransportManager;
import org.wso2.carbon.messaging.handler.HandlerExecutor;
import org.wso2.carbon.transport.http.netty.config.ListenerConfiguration;
import org.wso2.carbon.transport.http.netty.config.TransportsConfiguration;
import org.wso2.carbon.transport.http.netty.config.YAMLTransportConfigurationBuilder;
import org.wso2.carbon.transport.http.netty.internal.NettyTransportContextHolder;
import org.wso2.carbon.transport.http.netty.listener.NettyListener;
import org.wso2.msf4j.Interceptor;
import org.wso2.msf4j.SessionManager;
import org.wso2.msf4j.internal.MSF4JMessageProcessor;
import org.wso2.msf4j.internal.MicroservicesRegistryImpl;
import org.wso2.msf4j.util.RuntimeAnnotations;

public class MicroservicesRunner {
    private static final Logger log = LoggerFactory.getLogger(MicroservicesRunner.class);
    private TransportManager transportManager = new TransportManager();
    private long startTime = System.currentTimeMillis();
    private boolean isStarted;
    private MicroservicesRegistryImpl msRegistry = new MicroservicesRegistryImpl();

    public MicroservicesRunner(int ... ports) {
        this.configureTransport(ports);
    }

    public MicroservicesRunner() {
        this.configureTransport();
    }

    public MicroservicesRunner deploy(Object ... microservice) {
        this.checkState();
        this.msRegistry.addService(microservice);
        return this;
    }

    public MicroservicesRunner deploy(String basePath, Object microservice) {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("value", basePath);
        RuntimeAnnotations.putAnnotation(microservice.getClass(), Path.class, valuesMap);
        this.msRegistry.addService(basePath, microservice);
        return this;
    }

    public MicroservicesRunner setSessionManager(SessionManager sessionManager) {
        this.msRegistry.setSessionManager(sessionManager);
        return this;
    }

    public MicroservicesRunner addInterceptor(Interceptor ... interceptor) {
        this.checkState();
        this.msRegistry.addInterceptor(interceptor);
        return this;
    }

    public MicroservicesRunner addExceptionMapper(ExceptionMapper ... exceptionMapper) {
        this.checkState();
        this.msRegistry.addExceptionMapper(exceptionMapper);
        return this;
    }

    protected void configureTransport(int ... ports) {
        NettyTransportContextHolder nettyTransportContextHolder = NettyTransportContextHolder.getInstance();
        nettyTransportContextHolder.setHandlerExecutor(new HandlerExecutor());
        for (int port : ports) {
            ListenerConfiguration listenerConfiguration = new ListenerConfiguration("netty-" + port, "0.0.0.0", port);
            NettyListener listener = new NettyListener(listenerConfiguration);
            this.transportManager.registerTransport(listener);
            nettyTransportContextHolder.setMessageProcessor(new MSF4JMessageProcessor("netty-" + port, this.msRegistry));
        }
    }

    protected void configureTransport() {
        TransportsConfiguration trpConfig = YAMLTransportConfigurationBuilder.build();
        Set<ListenerConfiguration> listenerConfigurations = trpConfig.getListenerConfigurations();
        NettyTransportContextHolder nettyTransportContextHolder = NettyTransportContextHolder.getInstance();
        nettyTransportContextHolder.setHandlerExecutor(new HandlerExecutor());
        for (ListenerConfiguration listenerConfiguration : listenerConfigurations) {
            NettyListener listener = new NettyListener(listenerConfiguration);
            this.transportManager.registerTransport(listener);
            nettyTransportContextHolder.setMessageProcessor(new MSF4JMessageProcessor(listenerConfiguration.getId(), this.msRegistry));
        }
    }

    protected void registerTransport(NettyListener listener) {
        this.transportManager.registerTransport(listener);
    }

    private void checkState() {
        if (this.isStarted) {
            throw new IllegalStateException("Microservices runner already started");
        }
    }

    public void start() {
        this.msRegistry.getSessionManager().init();
        this.handleServiceLifecycleMethods();
        this.transportManager.startTransports();
        this.isStarted = true;
        log.info("Microservices server started in " + (System.currentTimeMillis() - this.startTime) + "ms");
    }

    public void stop() {
        this.transportManager.stopTransports();
        log.info("Microservices server stopped");
    }

    public MicroservicesRegistryImpl getMsRegistry() {
        return this.msRegistry;
    }

    protected void handleServiceLifecycleMethods() {
        this.msRegistry.initServices();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                MicroservicesRunner.this.msRegistry.preDestroyServices();
            }
        });
    }
}

