/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.deployment.engine;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.deployment.engine.config.DeploymentConfiguration;
import org.wso2.carbon.kernel.utils.Utils;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.introspector.BeanAccess;

public class DeploymentConfigurationProvider {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentConfigurationProvider.class);
    private static DeploymentConfiguration deploymentConfiguration;
    private static boolean isInitialized;

    public static DeploymentConfiguration getDeploymentConfiguration() {
        DeploymentConfigurationProvider.init();
        return deploymentConfiguration;
    }

    private static synchronized void init() {
        if (isInitialized) {
            return;
        }
        String configFileLocation = DeploymentConfigurationProvider.getDeploymentConfigurationLocation();
        try (FileInputStream inputStream = new FileInputStream(configFileLocation);){
            String yamlFileString;
            try (Scanner scanner = new Scanner((InputStream)inputStream, StandardCharsets.UTF_8.name());){
                yamlFileString = scanner.useDelimiter("\\A").next();
                yamlFileString = Utils.substituteVariables(yamlFileString);
            }
            Yaml yaml = new Yaml();
            yaml.setBeanAccess(BeanAccess.FIELD);
            deploymentConfiguration = yaml.loadAs(yamlFileString, DeploymentConfiguration.class);
            isInitialized = true;
        }
        catch (IOException e) {
            String errorMessage = "Failed populate DeploymentConfiguration from " + configFileLocation;
            logger.error(errorMessage, e);
            throw new RuntimeException(errorMessage);
        }
    }

    private static String getDeploymentConfigurationLocation() {
        return Utils.getCarbonConfigHome().resolve("deployment.yml").toString();
    }
}

