/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.messaging.TransportSender;
import org.wso2.msf4j.Request;
import org.wso2.msf4j.Response;
import org.wso2.msf4j.delegates.MSF4JResponse;
import org.wso2.msf4j.internal.DataHolder;
import org.wso2.msf4j.internal.InterceptorException;
import org.wso2.msf4j.internal.InterceptorExecutor;
import org.wso2.msf4j.internal.MSF4JThreadFactory;
import org.wso2.msf4j.internal.MicroservicesRegistryImpl;
import org.wso2.msf4j.internal.router.HandlerException;
import org.wso2.msf4j.internal.router.HttpMethodInfo;
import org.wso2.msf4j.internal.router.HttpMethodInfoBuilder;
import org.wso2.msf4j.internal.router.HttpResourceModel;
import org.wso2.msf4j.internal.router.PatternPathRouter;
import org.wso2.msf4j.internal.router.Util;
import org.wso2.msf4j.util.HttpUtil;

@Component(name="org.wso2.msf4j.internal.MSF4JMessageProcessor", immediate=true, service={CarbonMessageProcessor.class})
public class MSF4JMessageProcessor
implements CarbonMessageProcessor {
    private static final Logger log = LoggerFactory.getLogger(MSF4JMessageProcessor.class);
    private static final String MSF4J_MSG_PROC_ID = "MSF4J-CM-PROCESSOR";
    private ExecutorService executorService = Executors.newFixedThreadPool(60, new MSF4JThreadFactory(new ThreadGroup("msf4j.executor.workerpool")));

    public MSF4JMessageProcessor() {
    }

    public MSF4JMessageProcessor(String channelId, MicroservicesRegistryImpl microservicesRegistry) {
        DataHolder.getInstance().getMicroservicesRegistries().put(channelId, microservicesRegistry);
    }

    @Override
    public boolean receive(CarbonMessage carbonMessage, CarbonCallback carbonCallback) {
        this.executorService.execute(() -> {
            MicroservicesRegistryImpl currentMicroservicesRegistry = DataHolder.getInstance().getMicroservicesRegistries().get(carbonMessage.getProperty("CHANNEL_ID"));
            Request request = new Request(carbonMessage);
            request.setSessionManager(currentMicroservicesRegistry.getSessionManager());
            this.setBaseUri(request);
            Response response = new Response(carbonCallback, request);
            try {
                this.dispatchMethod(currentMicroservicesRegistry, request, response);
            }
            catch (HandlerException e) {
                this.handleHandlerException(e, carbonCallback);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof HandlerException) {
                    this.handleHandlerException((HandlerException)targetException, carbonCallback);
                } else {
                    this.handleThrowable(currentMicroservicesRegistry, targetException, carbonCallback, request);
                }
            }
            catch (InterceptorException e) {
                log.warn("Interceptors threw an exception", e);
                carbonCallback.done(HttpUtil.createTextResponse(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ""));
            }
            catch (Throwable t) {
                this.handleThrowable(currentMicroservicesRegistry, t, carbonCallback, request);
            }
            finally {
                MSF4JResponse.clearBaseUri();
                carbonMessage.release();
            }
        });
        return true;
    }

    private void setBaseUri(Request request) {
        StringBuilder builder = new StringBuilder();
        builder.append(request.getProperty("PROTOCOL").toString().toLowerCase(Locale.US)).append("://").append(request.getHeader("HOST"));
        if (builder.charAt(builder.length() - 1) != '/') {
            builder.append("/");
        }
        try {
            MSF4JResponse.setBaseUri(new URI(builder.toString()));
        }
        catch (URISyntaxException e) {
            log.error("Error while setting the Base URI. " + e.getMessage(), e);
        }
    }

    private void dispatchMethod(MicroservicesRegistryImpl currentMicroservicesRegistry, Request request, Response response) throws Exception {
        HttpUtil.setConnectionHeader(request, response);
        PatternPathRouter.RoutableDestination<HttpResourceModel> destination = currentMicroservicesRegistry.getMetadata().getDestinationMethod(request.getUri(), request.getHttpMethod(), request.getContentType(), request.getAcceptTypes());
        HttpResourceModel resourceModel = destination.getDestination();
        response.setMediaType(Util.getResponseType(request.getAcceptTypes(), resourceModel.getProducesMediaTypes()));
        InterceptorExecutor interceptorExecutor = new InterceptorExecutor(resourceModel, request, response, currentMicroservicesRegistry.getInterceptors());
        if (interceptorExecutor.execPreCalls()) {
            HttpMethodInfoBuilder httpMethodInfoBuilder = new HttpMethodInfoBuilder().httpResourceModel(resourceModel).httpRequest(request).httpResponder(response).requestInfo(destination.getGroupNameValues());
            HttpMethodInfo httpMethodInfo = httpMethodInfoBuilder.build();
            if (httpMethodInfo.isStreamingSupported()) {
                while (!request.isEmpty() || !request.isEomAdded()) {
                    httpMethodInfo.chunk(request.getMessageBody());
                }
                httpMethodInfo.end();
            } else {
                httpMethodInfo.invoke(request, destination);
            }
            interceptorExecutor.execPostCalls(response.getStatusCode());
        }
    }

    private void handleThrowable(MicroservicesRegistryImpl currentMicroservicesRegistry, Throwable throwable, CarbonCallback carbonCallback, Request request) {
        Optional<ExceptionMapper> exceptionMapper = currentMicroservicesRegistry.getExceptionMapper(throwable);
        if (exceptionMapper.isPresent()) {
            Response msf4jResponse = new Response(carbonCallback, request);
            msf4jResponse.setEntity(exceptionMapper.get().toResponse(throwable));
            msf4jResponse.send();
        } else {
            log.warn("Unmapped exception", throwable);
            carbonCallback.done(HttpUtil.createTextResponse(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Exception occurred :" + throwable.getMessage()));
        }
    }

    private void handleHandlerException(HandlerException e, CarbonCallback carbonCallback) {
        carbonCallback.done(e.getFailureResponse());
    }

    @Override
    public void setTransportSender(TransportSender transportSender) {
    }

    @Override
    public String getId() {
        return MSF4J_MSG_PROC_ID;
    }
}

