/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.sender.channel;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.transport.http.netty.config.TransportProperty;

public class BootstrapConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(BootstrapConfiguration.class);
    private static BootstrapConfiguration bootstrapConfig;
    private boolean tcpNoDelay = true;
    private int connectTimeOut = 15000;
    private int reciveBufferSize = 0x100000;
    private int sendBufferSize = 0x100000;
    private boolean keepAlive = true;
    private boolean socketReuse = false;
    private int socketTimeout = 15;

    private BootstrapConfiguration(Set<TransportProperty> transportPropertySet) {
        if (transportPropertySet != null && !transportPropertySet.isEmpty()) {
            for (TransportProperty property : transportPropertySet) {
                if (property.getName().equals("client.bootstrap.nodelay")) {
                    this.tcpNoDelay = (Boolean)property.getValue();
                    continue;
                }
                if (property.getName().equals("client.bootstrap.connect.timeout")) {
                    this.connectTimeOut = (Integer)property.getValue();
                    continue;
                }
                if (property.getName().equals("client.bootstrap.recievebuffersize")) {
                    this.reciveBufferSize = (Integer)property.getValue();
                    continue;
                }
                if (property.getName().equals("client.bootstrap.sendbuffersize")) {
                    this.sendBufferSize = (Integer)property.getValue();
                    continue;
                }
                if (property.getName().equals("client.bootstrap.socket.timeout")) {
                    this.socketTimeout = (Integer)property.getValue();
                    continue;
                }
                if (property.getName().equals("client.bootstrap.keepalive")) {
                    this.keepAlive = (Boolean)property.getValue();
                    continue;
                }
                if (!property.getName().equals("client.bootstrap.socket.reuse")) continue;
                this.socketReuse = (Boolean)property.getValue();
            }
        }
        logger.debug("client.bootstrap.nodelay: " + this.tcpNoDelay);
        logger.debug("client.bootstrap.connect.timeout:" + this.connectTimeOut);
        logger.debug("client.bootstrap.recievebuffersize:" + this.reciveBufferSize);
        logger.debug("client.bootstrap.sendbuffersize:" + this.sendBufferSize);
        logger.debug("client.bootstrap.socket.timeout:" + this.socketTimeout);
        logger.debug("client.bootstrap.keepalive:" + this.keepAlive);
        logger.debug("client.bootstrap.socket.reuse:" + this.socketReuse);
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public int getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public int getReciveBufferSize() {
        return this.reciveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public boolean isSocketReuse() {
        return this.socketReuse;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public static BootstrapConfiguration getInstance() {
        return bootstrapConfig;
    }

    public static void createBootStrapConfiguration(Set<TransportProperty> transportProperties) {
        bootstrapConfig = new BootstrapConfiguration(transportProperties);
    }
}

