/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.example;

import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.messaging.Headers;
import org.wso2.msf4j.Interceptor;
import org.wso2.msf4j.Request;
import org.wso2.msf4j.Response;
import org.wso2.msf4j.ServiceMethodInfo;

public class CustomJWTClaimsInterceptor
implements Interceptor {
    private static final String JWT_HEADER = "X-JWT-Assertion";
    private static final String AUTH_TYPE_JWT = "JWT";
    private final Log log = LogFactory.getLog(CustomJWTClaimsInterceptor.class);

    @Override
    public boolean preCall(Request request, Response responder, ServiceMethodInfo serviceMethodInfo) throws Exception {
        SignedJWT signedJWT;
        ReadOnlyJWTClaimsSet readOnlyJWTClaimsSet;
        String jwtHeader;
        Headers headers = request.getHeaders();
        if (headers != null && (jwtHeader = headers.get(JWT_HEADER)) != null && (readOnlyJWTClaimsSet = (signedJWT = SignedJWT.parse(jwtHeader)).getJWTClaimsSet()) != null) {
            return true;
        }
        responder.setHeader("WWW-Authenticate", AUTH_TYPE_JWT);
        responder.setStatus(Response.Status.UNAUTHORIZED.getStatusCode());
        responder.send();
        return false;
    }

    @Override
    public void postCall(Request request, int status, ServiceMethodInfo serviceMethodInfo) {
    }
}

