/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.common;

import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.Header;
import org.wso2.carbon.messaging.Headers;
import org.wso2.carbon.messaging.MessageDataSource;
import org.wso2.carbon.transport.http.netty.common.ssl.SSLConfig;
import org.wso2.carbon.transport.http.netty.config.Parameter;
import org.wso2.carbon.transport.http.netty.listener.RequestDataHolder;

public class Util {
    private static final String DEFAULT_HTTP_METHOD_POST = "POST";
    private static final String DEFAULT_VERSION_HTTP_1_1 = "HTTP/1.1";
    private static final Pattern varPattern = Pattern.compile("\\$\\{([^}]*)}");

    public static Headers getHeaders(HttpMessage message) {
        LinkedList<Header> headers = new LinkedList<Header>();
        if (message.headers() != null) {
            for (Map.Entry<String, String> k : message.headers().entries()) {
                headers.add(new Header(k.getKey(), k.getValue()));
            }
        }
        return new Headers(headers);
    }

    public static void setHeaders(HttpMessage message, Headers headers) {
        HttpHeaders httpHeaders = message.headers();
        for (Header header : headers.getAll()) {
            httpHeaders.add(header.getName(), (Object)header.getValue());
        }
    }

    public static String getStringValue(CarbonMessage msg, String key, String defaultValue) {
        String value = (String)msg.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static int getIntValue(CarbonMessage msg, String key, int defaultValue) {
        Integer value = (Integer)msg.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static HttpResponse createHttpResponse(CarbonMessage msg) {
        return Util.createHttpResponse(msg, false);
    }

    public static HttpResponse createHttpResponse(CarbonMessage msg, boolean connectionCloseAfterResponse) {
        HttpVersion httpVersion = new HttpVersion(Util.getStringValue(msg, "HTTP_VERSION", HttpVersion.HTTP_1_1.text()), true);
        int statusCode = Util.getIntValue(msg, "HTTP_STATUS_CODE", 200);
        String reasonPhrase = Util.getStringValue(msg, "HTTP_REASON_PHRASE", HttpResponseStatus.valueOf(statusCode).reasonPhrase());
        HttpResponseStatus httpResponseStatus = new HttpResponseStatus(statusCode, reasonPhrase);
        DefaultHttpResponse outgoingResponse = new DefaultHttpResponse(httpVersion, httpResponseStatus, false);
        Headers headers = msg.getHeaders();
        if (connectionCloseAfterResponse) {
            headers.set("Connection", "Close");
        }
        Util.setHeaders(outgoingResponse, headers);
        return outgoingResponse;
    }

    public static HttpRequest createHttpRequest(CarbonMessage msg) {
        HttpMethod httpMethod = null != msg.getProperty("HTTP_METHOD") ? new HttpMethod((String)msg.getProperty("HTTP_METHOD")) : new HttpMethod(DEFAULT_HTTP_METHOD_POST);
        HttpVersion httpVersion = null != msg.getProperty("HTTP_VERSION") ? new HttpVersion((String)msg.getProperty("HTTP_VERSION"), true) : new HttpVersion(DEFAULT_VERSION_HTTP_1_1, true);
        if ((String)msg.getProperty("TO") == null) {
            msg.setProperty("TO", "/");
        }
        DefaultHttpRequest outgoingRequest = new DefaultHttpRequest(httpVersion, httpMethod, (String)msg.getProperty("TO"), false);
        Headers headers = msg.getHeaders();
        Util.setHeaders(outgoingRequest, headers);
        return outgoingRequest;
    }

    public static void setupTransferEncodingForRequest(CarbonMessage cMsg) {
        int contentLength;
        if (cMsg.getHeader("Transfer-Encoding") != null) {
            cMsg.removeHeader("Content-Length");
        } else if ((cMsg.isAlreadyRead() || cMsg.getHeader("Content-Length") == null && !cMsg.isEmpty()) && (contentLength = cMsg.getFullMessageLength()) > 0) {
            cMsg.setHeader("Content-Length", String.valueOf(contentLength));
        }
    }

    public static void setupTransferEncodingForResponse(CarbonMessage cMsg, RequestDataHolder requestDataHolder) {
        int contentLength;
        int statusCode = Util.getIntValue(cMsg, "HTTP_STATUS_CODE", 200);
        String httpMethod = requestDataHolder.getHttpMethod();
        if (statusCode == 204 || statusCode >= 100 && statusCode < 200 || HttpMethod.CONNECT.name().equals(httpMethod) && statusCode >= 200 && statusCode < 300) {
            cMsg.removeHeader("Transfer-Encoding");
            cMsg.removeHeader("Content-Length");
            return;
        }
        String requestTransferEncodingHeader = requestDataHolder.getTransferEncodingHeader();
        if (requestTransferEncodingHeader != null && !"identity".equalsIgnoreCase(requestTransferEncodingHeader)) {
            cMsg.setHeader("Transfer-Encoding", requestTransferEncodingHeader);
            cMsg.removeHeader("Content-Length");
            return;
        }
        String requestContentLength = requestDataHolder.getContentLengthHeader();
        if (requestContentLength != null && (cMsg.isAlreadyRead() || cMsg.getHeader("Content-Length") == null && !cMsg.isEmpty())) {
            int contentLength2 = cMsg.getFullMessageLength();
            if (contentLength2 > 0) {
                cMsg.setHeader("Content-Length", String.valueOf(contentLength2));
            }
            cMsg.removeHeader("Transfer-Encoding");
            return;
        }
        if (cMsg.getHeader("Transfer-Encoding") != null) {
            cMsg.getHeaders().remove("Content-Length");
        } else if ((cMsg.isAlreadyRead() || cMsg.getHeader("Content-Length") == null && !cMsg.isEmpty()) && (contentLength = cMsg.getFullMessageLength()) > 0) {
            cMsg.setHeader("Content-Length", String.valueOf(contentLength));
        }
    }

    public static void prepareBuiltMessageForTransfer(CarbonMessage cMsg) {
        MessageDataSource messageDataSource;
        if (cMsg.isAlreadyRead() && (messageDataSource = cMsg.getMessageDataSource()) != null) {
            messageDataSource.serializeData();
            cMsg.setEndOfMsgAdded(true);
        }
    }

    public static SSLConfig getSSLConfigForListener(String certPass, String keyStorePass, String keyStoreFilePath, String trustStoreFilePath, String trustStorePass, List<Parameter> parametersList) {
        if (certPass == null) {
            certPass = keyStorePass;
        }
        if (keyStoreFilePath == null || keyStorePass == null) {
            throw new IllegalArgumentException("keyStoreFile or keyStorePass not defined for HTTPS scheme");
        }
        File keyStore = new File(Util.substituteVariables(keyStoreFilePath));
        if (!keyStore.exists()) {
            throw new IllegalArgumentException("KeyStore File " + keyStoreFilePath + " not found");
        }
        SSLConfig sslConfig = new SSLConfig(keyStore, keyStorePass).setCertPass(certPass);
        for (Parameter parameter : parametersList) {
            if (parameter.getName().equals("server.ssl.ciphers")) {
                sslConfig.setCipherSuites(parameter.getValue());
                continue;
            }
            if (parameter.getName().equals("server.ssl.http.protocols")) {
                sslConfig.setEnableProtocols(parameter.getValue());
                continue;
            }
            if (parameter.getName().equals("server.supported.snimatchers")) {
                sslConfig.setSniMatchers(parameter.getValue());
                continue;
            }
            if (parameter.getName().equals("server.suported.server.names")) {
                sslConfig.setServerNames(parameter.getValue());
                continue;
            }
            if (parameter.getName().equals("server.enable.session.creation")) {
                sslConfig.setEnableSessionCreation(Boolean.parseBoolean(parameter.getValue()));
                continue;
            }
            if (!parameter.getName().equals("ssl.verify.client")) continue;
            sslConfig.setNeedClientAuth(Boolean.parseBoolean(parameter.getValue()));
        }
        if (trustStoreFilePath != null) {
            File trustStore = new File(Util.substituteVariables(trustStoreFilePath));
            if (!trustStore.exists()) {
                throw new IllegalArgumentException("trustStore File " + trustStoreFilePath + " not found");
            }
            if (trustStorePass == null) {
                throw new IllegalArgumentException("trustStorePass is not defined for HTTPS scheme");
            }
            sslConfig.setTrustStore(trustStore).setTrustStorePass(trustStorePass);
        }
        return sslConfig;
    }

    public static SSLConfig getSSLConfigForSender(String certPass, String keyStorePass, String keyStoreFilePath, String trustStoreFilePath, String trustStorePass, List<Parameter> parametersList) {
        if (certPass == null) {
            certPass = keyStorePass;
        }
        if (trustStoreFilePath == null || trustStorePass == null) {
            throw new IllegalArgumentException("TrusStoreFile or trustStorePass not defined for HTTPS scheme");
        }
        SSLConfig sslConfig = new SSLConfig(null, null).setCertPass(null);
        if (keyStoreFilePath != null) {
            File keyStore = new File(Util.substituteVariables(keyStoreFilePath));
            if (!keyStore.exists()) {
                throw new IllegalArgumentException("KeyStore File " + trustStoreFilePath + " not found");
            }
            sslConfig = new SSLConfig(keyStore, keyStorePass).setCertPass(certPass);
        }
        File trustStore = new File(Util.substituteVariables(trustStoreFilePath));
        sslConfig.setTrustStore(trustStore).setTrustStorePass(trustStorePass);
        sslConfig.setClientMode(true);
        if (parametersList != null) {
            for (Parameter parameter : parametersList) {
                String paramName = parameter.getName();
                if ("client.ssl.ciphers".equals(paramName)) {
                    sslConfig.setCipherSuites(parameter.getValue());
                    continue;
                }
                if ("client.ssl.http.protocols".equals(paramName)) {
                    sslConfig.setEnableProtocols(parameter.getValue());
                    continue;
                }
                if (!"client.enable.session.creation".equals(paramName)) continue;
                sslConfig.setEnableSessionCreation(Boolean.parseBoolean(parameter.getValue()));
            }
        }
        return sslConfig;
    }

    public static int getIntProperty(Map<String, Object> properties, String key, int defaultVal) {
        if (properties == null) {
            return defaultVal;
        }
        Object propertyVal = properties.get(key);
        if (propertyVal == null) {
            return defaultVal;
        }
        if (!(propertyVal instanceof Integer)) {
            throw new IllegalArgumentException("Property : " + key + " must be an integer");
        }
        return (Integer)propertyVal;
    }

    public static String getStringProperty(Map<String, Object> properties, String key, String defaultVal) {
        if (properties == null) {
            return defaultVal;
        }
        Object propertyVal = properties.get(key);
        if (propertyVal == null) {
            return defaultVal;
        }
        if (!(propertyVal instanceof String)) {
            throw new IllegalArgumentException("Property : " + key + " must be a string");
        }
        return (String)propertyVal;
    }

    public static Boolean getBooleanProperty(Map<String, Object> properties, String key, boolean defaultVal) {
        if (properties == null) {
            return defaultVal;
        }
        Object propertyVal = properties.get(key);
        if (propertyVal == null) {
            return defaultVal;
        }
        if (!(propertyVal instanceof Boolean)) {
            throw new IllegalArgumentException("Property : " + key + " must be a boolean");
        }
        return (Boolean)propertyVal;
    }

    public static Long getLongProperty(Map<String, Object> properties, String key, long defaultVal) {
        if (properties == null) {
            return defaultVal;
        }
        Object propertyVal = properties.get(key);
        if (propertyVal == null) {
            return defaultVal;
        }
        if (!(propertyVal instanceof Long)) {
            throw new IllegalArgumentException("Property : " + key + " must be a long");
        }
        return (Long)propertyVal;
    }

    public static String substituteVariables(String value) {
        Matcher matcher = varPattern.matcher(value);
        boolean found = matcher.find();
        if (!found) {
            return value;
        }
        StringBuffer sb = new StringBuffer();
        do {
            String sysPropKey;
            String sysPropValue;
            if ((sysPropValue = Util.getSystemVariableValue(sysPropKey = matcher.group(1), null)) == null || sysPropValue.length() == 0) {
                throw new RuntimeException("System property " + sysPropKey + " is not specified");
            }
            sysPropValue = sysPropValue.replace("\\", "\\\\");
            matcher.appendReplacement(sb, sysPropValue);
        } while (matcher.find());
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String getSystemVariableValue(String variableName, String defaultValue) {
        String value = System.getProperty(variableName) != null ? System.getProperty(variableName) : (System.getenv(variableName) != null ? System.getenv(variableName) : defaultValue);
        return value;
    }
}

