/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.internal;

import io.netty.channel.EventLoopGroup;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.messaging.handler.HandlerExecutor;
import org.wso2.carbon.transport.http.netty.config.ListenerConfiguration;

public class HTTPTransportContextHolder {
    private static final Logger log = LoggerFactory.getLogger(HTTPTransportContextHolder.class);
    private static HTTPTransportContextHolder instance = new HTTPTransportContextHolder();
    private BundleContext bundleContext;
    private HandlerExecutor handlerExecutor;
    private Map<String, ListenerConfiguration> listenerConfigurations = new HashMap<String, ListenerConfiguration>();
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private CarbonMessageProcessor singleCarbonMessageProcessor;
    private Map<String, CarbonMessageProcessor> messageProcessorMap = new ConcurrentHashMap<String, CarbonMessageProcessor>();

    public EventLoopGroup getBossGroup() {
        return this.bossGroup;
    }

    public void setBossGroup(EventLoopGroup bossGroup) {
        this.bossGroup = bossGroup;
    }

    public EventLoopGroup getWorkerGroup() {
        return this.workerGroup;
    }

    public void setWorkerGroup(EventLoopGroup workerGroup) {
        this.workerGroup = workerGroup;
    }

    public ListenerConfiguration getListenerConfiguration(String id) {
        return this.listenerConfigurations.get(id);
    }

    public void setListenerConfiguration(String id, ListenerConfiguration config) {
        this.listenerConfigurations.put(id, config);
    }

    private HTTPTransportContextHolder() {
    }

    public static HTTPTransportContextHolder getInstance() {
        return instance;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public CarbonMessageProcessor getMessageProcessor(String id) {
        CarbonMessageProcessor carbonMessageProcessor = this.singleCarbonMessageProcessor;
        if (carbonMessageProcessor != null) {
            return carbonMessageProcessor;
        }
        if (id == null) {
            log.error("More than one message processor has registered and cannot proceed with 'null' message processor ID.");
            return null;
        }
        return this.messageProcessorMap.get(id);
    }

    public void setMessageProcessor(CarbonMessageProcessor carbonMessageProcessor) {
        if (carbonMessageProcessor.getId() == null) {
            throw new IllegalStateException("Message processor ID cannot be 'null'");
        }
        this.messageProcessorMap.put(carbonMessageProcessor.getId(), carbonMessageProcessor);
        this.singleCarbonMessageProcessor = this.messageProcessorMap.size() == 1 ? carbonMessageProcessor : null;
    }

    public void removeMessageProcessor(CarbonMessageProcessor carbonMessageProcessor) {
        if (this.messageProcessorMap.size() > 1) {
            this.messageProcessorMap.remove(carbonMessageProcessor.getId());
        } else {
            this.messageProcessorMap.clear();
            this.singleCarbonMessageProcessor = null;
        }
    }

    public void setHandlerExecutor(HandlerExecutor handlerExecutor) {
        this.handlerExecutor = handlerExecutor;
    }

    public HandlerExecutor getHandlerExecutor() {
        return this.handlerExecutor;
    }
}

