/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.listener;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.BinaryCarbonMessage;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.messaging.ControlCarbonMessage;
import org.wso2.carbon.messaging.StatusCarbonMessage;
import org.wso2.carbon.messaging.TextCarbonMessage;
import org.wso2.carbon.transport.http.netty.config.ListenerConfiguration;
import org.wso2.carbon.transport.http.netty.exception.UnknownWebSocketFrameTypeException;
import org.wso2.carbon.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.carbon.transport.http.netty.internal.websocket.WebSocketSessionImpl;
import org.wso2.carbon.transport.http.netty.listener.SourceHandler;
import org.wso2.carbon.transport.http.netty.sender.channel.pool.ConnectionManager;

public class WebSocketSourceHandler
extends SourceHandler {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketSourceHandler.class);
    private final String uri;
    private final String channelId;
    private final boolean isSecured;
    private final WebSocketSessionImpl serverSession;
    private CarbonMessage cMsg;
    private List<Session> clientSessions = new LinkedList<Session>();

    public WebSocketSourceHandler(String channelId, ConnectionManager connectionManager, ListenerConfiguration listenerConfiguration, HttpRequest httpRequest, boolean isSecured, ChannelHandlerContext ctx, WebSocketSessionImpl serverSession) throws Exception {
        super(connectionManager, listenerConfiguration);
        this.uri = httpRequest.uri();
        this.channelId = channelId;
        this.isSecured = isSecured;
        this.serverSession = serverSession;
    }

    public void addClientSession(Session clientSession) {
        this.clientSessions.add(clientSession);
    }

    public List<Session> getClientSessions() {
        return this.clientSessions;
    }

    public Session getServerSession() {
        return this.serverSession;
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.serverSession.isOpen()) {
            this.serverSession.setIsOpen(false);
            int statusCode = 1001;
            String reasonText = "Client is going away";
            this.cMsg = new StatusCarbonMessage("STATUS_CLOSE", statusCode, reasonText);
            this.setupCarbonMessage(ctx);
            this.publishToMessageProcessor(this.cMsg);
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws UnknownWebSocketFrameTypeException {
        this.cMsg = null;
        if (!(msg instanceof WebSocketFrame)) {
            logger.error("Expecting WebSocketFrame. Unknown type.");
            throw new UnknownWebSocketFrameTypeException("Expecting WebSocketFrame. Unknown type.");
        }
        if (msg instanceof TextWebSocketFrame) {
            TextWebSocketFrame textWebSocketFrame = (TextWebSocketFrame)msg;
            String text = textWebSocketFrame.text();
            this.cMsg = new TextCarbonMessage(text);
        } else if (msg instanceof BinaryWebSocketFrame) {
            BinaryWebSocketFrame binaryWebSocketFrame = (BinaryWebSocketFrame)msg;
            boolean finalFragment = binaryWebSocketFrame.isFinalFragment();
            ByteBuf byteBuf = binaryWebSocketFrame.content();
            ByteBuffer byteBuffer = byteBuf.nioBuffer();
            this.cMsg = new BinaryCarbonMessage(byteBuffer, finalFragment);
        } else if (msg instanceof CloseWebSocketFrame) {
            CloseWebSocketFrame closeWebSocketFrame = (CloseWebSocketFrame)msg;
            String reasonText = closeWebSocketFrame.reasonText();
            int statusCode = closeWebSocketFrame.statusCode();
            ctx.channel().close();
            this.serverSession.setIsOpen(false);
            this.cMsg = new StatusCarbonMessage("STATUS_CLOSE", statusCode, reasonText);
        } else if (msg instanceof PingWebSocketFrame) {
            PingWebSocketFrame pingWebSocketFrame = (PingWebSocketFrame)msg;
            ctx.channel().writeAndFlush(new PongWebSocketFrame(pingWebSocketFrame.content()));
        } else if (msg instanceof PongWebSocketFrame) {
            PongWebSocketFrame pongWebSocketFrame = (PongWebSocketFrame)msg;
            boolean finalFragment = pongWebSocketFrame.isFinalFragment();
            ByteBuf byteBuf = pongWebSocketFrame.content();
            ByteBuffer byteBuffer = byteBuf.nioBuffer();
            this.cMsg = new ControlCarbonMessage("CONTROL_SIGNAL_HEARTBEAT", byteBuffer, finalFragment);
            this.setupCarbonMessage(ctx);
        }
        this.setupCarbonMessage(ctx);
        this.publishToMessageProcessor(this.cMsg);
    }

    @Override
    protected void publishToMessageProcessor(CarbonMessage cMsg) {
        CarbonMessageProcessor carbonMessageProcessor;
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceRequestReceiving(cMsg);
        }
        if ((carbonMessageProcessor = HTTPTransportContextHolder.getInstance().getMessageProcessor(this.listenerConfiguration.getMessageProcessorId())) != null) {
            try {
                carbonMessageProcessor.receive(cMsg, null);
            }
            catch (Exception e) {
                logger.error("Error while submitting CarbonMessage to CarbonMessageProcessor.", e);
                this.ctx.channel().close();
            }
        } else {
            logger.error("Cannot find registered MessageProcessor to forward the message.");
            this.ctx.channel().close();
        }
    }

    private void setupCarbonMessage(ChannelHandlerContext ctx) {
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceRequestReceiving(this.cMsg);
        }
        this.cMsg.setProperty("TO", this.uri);
        this.cMsg.setProperty("SRC_HANDLER", this);
        this.cMsg.setProperty("LISTENER_PORT", ((InetSocketAddress)ctx.channel().localAddress()).getPort());
        this.cMsg.setProperty("IS_SECURED_CONNECTION", this.isSecured);
        this.cMsg.setProperty("LOCAL_ADDRESS", ctx.channel().localAddress());
        this.cMsg.setProperty("LOCAL_NAME", ((InetSocketAddress)ctx.channel().localAddress()).getHostName());
        this.cMsg.setProperty("CHANNEL_ID", this.channelId);
        this.cMsg.setProperty("PROTOCOL", "ws");
        this.cMsg.setProperty("IS_WEBSOCKET_SERVER", true);
        this.cMsg.setProperty("WEBSOCKET_SERVER_SESSION", this.serverSession);
        this.cMsg.setProperty("WEBSOCKET_CLIENT_SESSIONS_LIST", this.clientSessions);
    }
}

