/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.sender.websocket;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.SSLException;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.messaging.Headers;
import org.wso2.carbon.transport.http.netty.listener.WebSocketSourceHandler;
import org.wso2.carbon.transport.http.netty.sender.websocket.WebSocketTargetHandler;

public class WebSocketClient {
    private static final Logger log = LoggerFactory.getLogger(WebSocketClient.class);
    private Channel channel;
    private WebSocketTargetHandler handler;
    private EventLoopGroup group;
    private boolean handshakeDone = false;
    private final String url;
    private final String subprotocol;
    private final String clientServiceName;
    private final boolean allowExtensions;
    private final Headers headers;
    private final WebSocketSourceHandler sourceHandler;
    private final CarbonMessageProcessor messageProcessor;

    public WebSocketClient(String url, String clientServiceName, String subprotocol, boolean allowExtensions, Headers headers, WebSocketSourceHandler sourceHandler, CarbonMessageProcessor messageProcessor) {
        this.url = url;
        this.clientServiceName = clientServiceName;
        this.subprotocol = subprotocol;
        this.allowExtensions = allowExtensions;
        this.headers = headers;
        this.sourceHandler = sourceHandler;
        this.messageProcessor = messageProcessor;
    }

    public void handshake() throws InterruptedException, URISyntaxException, SSLException {
        String host;
        URI uri = new URI(this.url);
        String scheme = uri.getScheme() == null ? "ws" : uri.getScheme();
        String string = host = uri.getHost() == null ? "127.0.0.1" : uri.getHost();
        final int port = uri.getPort() == -1 ? ("ws".equalsIgnoreCase(scheme) ? 80 : ("wss".equalsIgnoreCase(scheme) ? 443 : -1)) : uri.getPort();
        if (!"ws".equalsIgnoreCase(scheme) && !"wss".equalsIgnoreCase(scheme)) {
            log.error("Only WS(S) is supported.");
            throw new SSLException("");
        }
        boolean ssl = "wss".equalsIgnoreCase(scheme);
        final SslContext sslCtx = ssl ? SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build() : null;
        this.group = new NioEventLoopGroup();
        DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
        this.headers.getAll().forEach(header -> httpHeaders.add(header.getName(), (Object)header.getValue()));
        WebSocketClientHandshaker websocketHandshaker = WebSocketClientHandshakerFactory.newHandshaker(uri, WebSocketVersion.V13, this.subprotocol, this.allowExtensions, httpHeaders);
        this.handler = new WebSocketTargetHandler(websocketHandshaker, this.sourceHandler, ssl, this.url, this.clientServiceName, this.messageProcessor);
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)b.group(this.group)).channel(NioSocketChannel.class)).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) {
                ChannelPipeline p = ch.pipeline();
                if (sslCtx != null) {
                    p.addLast(sslCtx.newHandler(ch.alloc(), host, port));
                }
                p.addLast(new HttpClientCodec(), new HttpObjectAggregator(8192), WebSocketClientCompressionHandler.INSTANCE, WebSocketClient.this.handler);
            }
        });
        this.channel = b.connect(uri.getHost(), port).sync().channel();
        this.handler.handshakeFuture().sync();
        this.handshakeDone = true;
    }

    public Session getSession() {
        return this.handler.getClientSession();
    }
}

