/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.sender.websocket;

import java.net.URISyntaxException;
import java.util.Map;
import javax.net.ssl.SSLException;
import javax.websocket.Session;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.messaging.ClientConnector;
import org.wso2.carbon.messaging.Headers;
import org.wso2.carbon.messaging.exceptions.ClientConnectorException;
import org.wso2.carbon.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.carbon.transport.http.netty.listener.WebSocketSourceHandler;
import org.wso2.carbon.transport.http.netty.sender.websocket.WebSocketClient;

public class WebSocketClientConnector
implements ClientConnector {
    private CarbonMessageProcessor messageProcessor;

    @Override
    public Object init(CarbonMessage carbonMessage, CarbonCallback carbonCallback, Map<String, Object> map) throws ClientConnectorException {
        return this.handleHandshake(carbonMessage);
    }

    @Override
    public boolean send(CarbonMessage msg, CarbonCallback callback) throws ClientConnectorException {
        throw new ClientConnectorException("Method not supported for WebSocket. Use session to send messages.");
    }

    @Override
    public boolean send(CarbonMessage msg, CarbonCallback callback, Map<String, String> parameters) throws ClientConnectorException {
        throw new ClientConnectorException("Method not supported for WebSocket. Use session to send messages.");
    }

    @Override
    public String getProtocol() {
        return "ws";
    }

    @Override
    public void setMessageProcessor(CarbonMessageProcessor messageProcessor) {
        this.messageProcessor = messageProcessor;
        HTTPTransportContextHolder.getInstance().setMessageProcessor(messageProcessor);
    }

    private Session handleHandshake(CarbonMessage carbonMessage) throws ClientConnectorException {
        String url = (String)carbonMessage.getProperty("REMOTE_ADDRESS");
        String clientServiceName = (String)carbonMessage.getProperty("TO");
        WebSocketSourceHandler sourceHandler = (WebSocketSourceHandler)carbonMessage.getProperty("SRC_HANDLER");
        String subprotocols = (String)carbonMessage.getProperty("WEBSOCKET_SUBPROTOCOLS");
        Boolean allowExtensions = (Boolean)carbonMessage.getProperty("WEBSOCKET_ALLOW_EXTENSIONS");
        if (allowExtensions == null) {
            allowExtensions = true;
        }
        Headers headers = carbonMessage.getHeaders();
        WebSocketClient webSocketClient = new WebSocketClient(url, clientServiceName, subprotocols, allowExtensions, headers, sourceHandler, this.messageProcessor);
        try {
            webSocketClient.handshake();
            return webSocketClient.getSession();
        }
        catch (InterruptedException e) {
            throw new ClientConnectorException("Handshake interrupted", e);
        }
        catch (URISyntaxException e) {
            throw new ClientConnectorException("SSL Exception occurred during handshake", e);
        }
        catch (SSLException e) {
            throw new ClientConnectorException("URI Syntax exception occurred during handshake", e);
        }
    }
}

