/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.internal.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import org.wso2.transport.http.netty.contract.websocket.WebSocketControlMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketControlSignal;
import org.wso2.transport.http.netty.contractimpl.websocket.DefaultWebSocketConnection;
import org.wso2.transport.http.netty.contractimpl.websocket.WebSocketMessageImpl;
import org.wso2.transport.http.netty.contractimpl.websocket.message.WebSocketBinaryMessageImpl;
import org.wso2.transport.http.netty.contractimpl.websocket.message.WebSocketControlMessageImpl;
import org.wso2.transport.http.netty.contractimpl.websocket.message.WebSocketTextMessageImpl;
import org.wso2.transport.http.netty.internal.websocket.DefaultWebSocketSession;

public class WebSocketUtil {
    public static String getSessionID(ChannelHandlerContext ctx) {
        return ctx.channel().id().asLongText();
    }

    public static DefaultWebSocketConnection getWebSocketConnection(ChannelHandlerContext ctx, boolean isSecured, String uri) throws URISyntaxException {
        DefaultWebSocketSession session = new DefaultWebSocketSession(ctx, isSecured, uri, WebSocketUtil.getSessionID(ctx));
        return new DefaultWebSocketConnection(ctx, session);
    }

    public static WebSocketControlMessage getWebsocketControlMessage(WebSocketFrame webSocketFrame, WebSocketControlSignal controlSignal) {
        ByteBuf content = webSocketFrame.content();
        ByteBuffer clonedContent = WebSocketUtil.getClonedByteBuf(content);
        WebSocketControlMessageImpl webSocketControlMessage = new WebSocketControlMessageImpl(controlSignal, clonedContent);
        webSocketFrame.release();
        return webSocketControlMessage;
    }

    public static WebSocketMessageImpl getWebSocketMessage(WebSocketFrame frame, String text, boolean isFinalFragment) {
        WebSocketTextMessageImpl webSocketTextMessage = new WebSocketTextMessageImpl(text, isFinalFragment);
        frame.release();
        return webSocketTextMessage;
    }

    public static WebSocketMessageImpl getWebSocketMessage(WebSocketFrame webSocketFrame, ByteBuf content, boolean finalFragment) {
        ByteBuffer clonedContent = WebSocketUtil.getClonedByteBuf(content);
        WebSocketBinaryMessageImpl webSocketBinaryMessage = new WebSocketBinaryMessageImpl(clonedContent, finalFragment);
        webSocketFrame.release();
        return webSocketBinaryMessage;
    }

    private static ByteBuffer getClonedByteBuf(ByteBuf buf) {
        ByteBuffer originalContent = buf.nioBuffer();
        ByteBuffer clonedContent = ByteBuffer.allocate(originalContent.capacity());
        originalContent.rewind();
        clonedContent.put(originalContent);
        originalContent.rewind();
        clonedContent.flip();
        return clonedContent;
    }
}

