/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.ReadOnlyJWSHeader;
import com.nimbusds.jose.crypto.HMAC;
import com.nimbusds.jose.crypto.MACProvider;
import com.nimbusds.jose.util.Base64URL;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class MACSigner
extends MACProvider
implements JWSSigner {
    public MACSigner(byte[] sharedSecret) {
        super(sharedSecret);
    }

    public MACSigner(String sharedSecretString) {
        super(sharedSecretString);
    }

    public Base64URL sign(ReadOnlyJWSHeader header, byte[] signingInput) throws JOSEException {
        String jcaAlg = MACSigner.getJCAAlgorithmName(header.getAlgorithm());
        byte[] hmac = HMAC.compute(jcaAlg, this.getSharedSecret(), signingInput, this.provider);
        return Base64URL.encode(hmac);
    }
}

