/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal;

import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.LastHttpContent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.config.ConfigProviderFactory;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.msf4j.Request;
import org.wso2.msf4j.Response;
import org.wso2.msf4j.config.MSF4JConfig;
import org.wso2.msf4j.delegates.MSF4JResponse;
import org.wso2.msf4j.interceptor.InterceptorExecutor;
import org.wso2.msf4j.internal.DataHolder;
import org.wso2.msf4j.internal.MSF4JThreadFactory;
import org.wso2.msf4j.internal.MicroservicesRegistryImpl;
import org.wso2.msf4j.internal.router.HandlerException;
import org.wso2.msf4j.internal.router.HttpMethodInfo;
import org.wso2.msf4j.internal.router.HttpMethodInfoBuilder;
import org.wso2.msf4j.internal.router.HttpResourceModel;
import org.wso2.msf4j.internal.router.PatternPathRouter;
import org.wso2.msf4j.internal.router.Util;
import org.wso2.msf4j.util.HttpUtil;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.contract.ServerConnectorException;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class MSF4JHttpConnectorListener
implements HttpConnectorListener {
    private static final Logger log = LoggerFactory.getLogger(MSF4JHttpConnectorListener.class);
    private ExecutorService executorService;

    public MSF4JHttpConnectorListener() {
        MSF4JConfig msf4JConfig;
        ConfigProvider configProvider = DataHolder.getInstance().getConfigProvider();
        if (configProvider == null) {
            if (DataHolder.getInstance().getBundleContext() != null) {
                throw new RuntimeException("Failed to populate MSF4J Configuration. Config Provider is Null.");
            }
            String deploymentYamlPath = System.getProperty("msf4j.conf");
            try {
                if (deploymentYamlPath != null && Files.exists(Paths.get(deploymentYamlPath, new String[0]), new LinkOption[0])) {
                    configProvider = ConfigProviderFactory.getConfigProvider(Paths.get(deploymentYamlPath, new String[0]), null);
                    DataHolder.getInstance().setConfigProvider(configProvider);
                } else if (log.isDebugEnabled()) {
                    log.debug("MSF4J Configuration file is not provided. either system property 'msf4j.conf' is not set or provided file path not exist. Hence using default configuration.");
                }
            }
            catch (ConfigurationException e) {
                throw new RuntimeException("Error loading deployment.yaml Configuration", e);
            }
        }
        try {
            msf4JConfig = configProvider != null ? DataHolder.getInstance().getConfigProvider().getConfigurationObject(MSF4JConfig.class) : new MSF4JConfig();
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("Error while loading " + MSF4JConfig.class.getName() + " from config provider", e);
        }
        this.executorService = Executors.newFixedThreadPool(msf4JConfig.getThreadCount(), new MSF4JThreadFactory(new ThreadGroup(msf4JConfig.getThreadPoolName())));
    }

    public MSF4JHttpConnectorListener(String channelId, MicroservicesRegistryImpl microservicesRegistry) {
        DataHolder.getInstance().getMicroservicesRegistries().put(channelId, microservicesRegistry);
    }

    @Override
    public void onMessage(HttpCarbonMessage httpCarbonMessage) {
        this.executorService.execute(() -> {
            MicroservicesRegistryImpl currentMicroservicesRegistry = DataHolder.getInstance().getMicroservicesRegistries().get(httpCarbonMessage.getProperty("listener.interface.id"));
            Request request = new Request(httpCarbonMessage);
            request.setSessionManager(currentMicroservicesRegistry.getSessionManager());
            this.setBaseUri(request);
            Response response = new Response(request);
            try {
                this.dispatchMethod(currentMicroservicesRegistry, request, response);
            }
            catch (HandlerException e) {
                this.handleHandlerException(e, request);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof HandlerException) {
                    this.handleHandlerException((HandlerException)targetException, request);
                } else {
                    this.handleThrowable(currentMicroservicesRegistry, targetException, request);
                }
            }
            catch (Throwable t) {
                this.handleThrowable(currentMicroservicesRegistry, t, request);
            }
            finally {
                MSF4JResponse.clearBaseUri();
                if (!httpCarbonMessage.isEmpty()) {
                    httpCarbonMessage.getHttpContent().release();
                }
            }
        });
    }

    private void setBaseUri(Request request) {
        StringBuilder builder = new StringBuilder();
        builder.append(request.getProperty("PROTOCOL").toString().toLowerCase(Locale.US)).append("://").append(request.getHeader(HttpHeaderNames.HOST.toString()));
        if (builder.charAt(builder.length() - 1) != '/') {
            builder.append("/");
        }
        try {
            MSF4JResponse.setBaseUri(new URI(builder.toString()));
        }
        catch (URISyntaxException e) {
            log.error("Error while setting the Base URI. " + e.getMessage(), e);
        }
    }

    private void dispatchMethod(MicroservicesRegistryImpl registry, Request request, Response response) throws Exception {
        HttpUtil.setConnectionHeader(request, response);
        PatternPathRouter.RoutableDestination<HttpResourceModel> destination = registry.getMetadata().getDestinationMethod(request.getUri(), request.getHttpMethod(), request.getContentType(), request.getAcceptTypes());
        HttpResourceModel resourceModel = destination.getDestination();
        response.setMediaType(Util.getResponseType(request.getAcceptTypes(), resourceModel.getProducesMediaTypes()));
        HttpMethodInfoBuilder httpMethodInfoBuilder = new HttpMethodInfoBuilder().httpResourceModel(resourceModel).httpRequest(request).httpResponder(response).requestInfo(destination.getGroupNameValues());
        HttpMethodInfo httpMethodInfo = httpMethodInfoBuilder.build();
        if (httpMethodInfo.isStreamingSupported()) {
            Method method = resourceModel.getMethod();
            Class<?> clazz = method.getDeclaringClass();
            if (InterceptorExecutor.executeGlobalRequestInterceptors(registry, request, response) && InterceptorExecutor.executeClassLevelRequestInterceptors(request, response, clazz) && InterceptorExecutor.executeMethodLevelRequestInterceptors(request, response, method)) {
                HttpCarbonMessage carbonMessage = this.getHttpCarbonMessage(request);
                HttpContent httpContent = carbonMessage.getHttpContent();
                while (httpContent != null) {
                    httpMethodInfo.chunk(httpContent.content().nioBuffer());
                    httpContent.release();
                    if (httpContent instanceof LastHttpContent) break;
                    httpContent = carbonMessage.getHttpContent();
                }
                boolean isResponseInterceptorsSuccessful = InterceptorExecutor.executeMethodLevelResponseInterceptors(request, response, method) && InterceptorExecutor.executeClassLevelResponseInterceptors(request, response, clazz) && InterceptorExecutor.executeGlobalResponseInterceptors(registry, request, response);
                httpMethodInfo.end(isResponseInterceptorsSuccessful);
            }
        } else {
            httpMethodInfo.invoke(destination, request, httpMethodInfo, registry);
        }
    }

    private HttpCarbonMessage getHttpCarbonMessage(Request request) throws HandlerException {
        Class<?> clazz = request.getClass();
        try {
            Method retrieveCarbonMsg = clazz.getDeclaredMethod("getHttpCarbonMessage", new Class[0]);
            retrieveCarbonMsg.setAccessible(true);
            return (HttpCarbonMessage)retrieveCarbonMsg.invoke((Object)request, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new HandlerException(Response.Status.INTERNAL_SERVER_ERROR, String.format("Error in executing request: %s %s", request.getHttpMethod(), request.getUri()), e);
        }
    }

    private void handleThrowable(MicroservicesRegistryImpl currentMicroservicesRegistry, Throwable throwable, Request request) {
        Optional<ExceptionMapper> exceptionMapper = currentMicroservicesRegistry.getExceptionMapper(throwable);
        if (exceptionMapper.isPresent()) {
            Response msf4jResponse = new Response(request);
            msf4jResponse.setEntity(exceptionMapper.get().toResponse(throwable));
            msf4jResponse.send();
        } else {
            log.warn("Unmapped exception", throwable);
            try {
                HttpCarbonMessage response = HttpUtil.createTextResponse(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Exception occurred :" + throwable.getMessage());
                response.addHttpContent(new DefaultLastHttpContent());
                request.respond(response);
            }
            catch (ServerConnectorException e) {
                log.error("Error while sending the response.", e);
            }
        }
    }

    private void handleHandlerException(HandlerException e, Request request) {
        try {
            HttpCarbonMessage failureResponse = e.getFailureResponse();
            failureResponse.addHttpContent(new DefaultLastHttpContent());
            request.respond(failureResponse);
        }
        catch (ServerConnectorException e1) {
            log.error("Error while sending the response.", e);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        log.error("Error in http connector listener", throwable);
    }
}

