/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.InetSocketAddress;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contract.config.ChunkConfig;
import org.wso2.transport.http.netty.contract.config.ForwardedExtensionConfig;
import org.wso2.transport.http.netty.contractimpl.common.BackPressureHandler;
import org.wso2.transport.http.netty.contractimpl.common.HttpRoute;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.common.states.MessageStateContext;
import org.wso2.transport.http.netty.contractimpl.listener.HttpTraceLoggingHandler;
import org.wso2.transport.http.netty.contractimpl.listener.SourceHandler;
import org.wso2.transport.http.netty.contractimpl.listener.http2.Http2SourceHandler;
import org.wso2.transport.http.netty.contractimpl.sender.ConnectionAvailabilityFuture;
import org.wso2.transport.http.netty.contractimpl.sender.ForwardedHeaderUpdater;
import org.wso2.transport.http.netty.contractimpl.sender.HttpClientChannelInitializer;
import org.wso2.transport.http.netty.contractimpl.sender.TargetHandler;
import org.wso2.transport.http.netty.contractimpl.sender.channel.pool.ConnectionManager;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2ClientChannel;
import org.wso2.transport.http.netty.contractimpl.sender.states.SendingHeaders;
import org.wso2.transport.http.netty.internal.HandlerExecutor;
import org.wso2.transport.http.netty.internal.HttpTransportContextHolder;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class TargetChannel {
    private static final Logger LOG = LoggerFactory.getLogger(TargetChannel.class);
    private Channel channel;
    private TargetHandler targetHandler;
    private HttpClientChannelInitializer httpClientChannelInitializer;
    private HttpRoute httpRoute;
    private ChannelInboundHandlerAdapter correlatedSource;
    private ChannelFuture channelFuture;
    private ConnectionManager connectionManager;
    private boolean requestHeaderWritten = false;
    private String httpVersion;
    private ChunkConfig chunkConfig;
    private HandlerExecutor handlerExecutor;
    private Http2ClientChannel http2ClientChannel;
    private final ConnectionAvailabilityFuture connectionAvailabilityFuture;
    private HttpResponseFuture httpInboundResponseFuture;
    private String trgHlrConnPoolId;

    public TargetChannel(HttpClientChannelInitializer httpClientChannelInitializer, ChannelFuture channelFuture, HttpRoute httpRoute, ConnectionAvailabilityFuture connectionAvailabilityFuture) {
        this.httpClientChannelInitializer = httpClientChannelInitializer;
        this.channelFuture = channelFuture;
        this.handlerExecutor = HttpTransportContextHolder.getInstance().getHandlerExecutor();
        this.httpRoute = httpRoute;
        if (httpClientChannelInitializer != null) {
            this.http2ClientChannel = new Http2ClientChannel(httpClientChannelInitializer.getHttp2ConnectionManager(), httpClientChannelInitializer.getConnection(), httpRoute, channelFuture.channel());
        }
        this.connectionAvailabilityFuture = connectionAvailabilityFuture;
    }

    public ConnectionAvailabilityFuture getConnenctionReadyFuture() {
        return this.connectionAvailabilityFuture;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public TargetChannel setChannel(Channel channel) {
        this.channel = channel;
        return this;
    }

    private TargetHandler getTargetHandler() {
        return this.targetHandler;
    }

    private void setTargetHandler(TargetHandler targetHandler) {
        this.targetHandler = targetHandler;
    }

    private HttpClientChannelInitializer getHttpClientChannelInitializer() {
        return this.httpClientChannelInitializer;
    }

    public HttpRoute getHttpRoute() {
        return this.httpRoute;
    }

    public String getTrgHlrConnPoolId() {
        return this.trgHlrConnPoolId;
    }

    public void setTrgHlrConnPoolId(String trgHlrConnPoolId) {
        this.trgHlrConnPoolId = trgHlrConnPoolId;
    }

    public ChannelInboundHandlerAdapter getCorrelatedSource() {
        return this.correlatedSource;
    }

    public void setCorrelatedSource(ChannelInboundHandlerAdapter correlatedSource) {
        this.correlatedSource = correlatedSource;
    }

    public boolean isRequestHeaderWritten() {
        return this.requestHeaderWritten;
    }

    public void setRequestHeaderWritten(boolean isRequestWritten) {
        this.requestHeaderWritten = isRequestWritten;
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public void setChunkConfig(ChunkConfig chunkConfig) {
        this.chunkConfig = chunkConfig;
    }

    public void configTargetHandler(HttpCarbonMessage httpCarbonMessage, HttpResponseFuture httpInboundResponseFuture) {
        this.setTargetHandler(this.getHttpClientChannelInitializer().getTargetHandler());
        TargetHandler handler = this.getTargetHandler();
        handler.setHttpResponseFuture(httpInboundResponseFuture);
        handler.setOutboundRequestMsg(httpCarbonMessage);
        handler.setConnectionManager(this.connectionManager);
        handler.setTargetChannel(this);
        this.httpInboundResponseFuture = httpInboundResponseFuture;
    }

    public void setEndPointTimeout(int socketIdleTimeout) {
        ChannelPipeline pipeline = this.getChannel().pipeline();
        IdleStateHandler idleStateHandler = new IdleStateHandler(0L, 0L, socketIdleTimeout, TimeUnit.MILLISECONDS);
        if (pipeline.get("targetHandler") == null) {
            pipeline.addLast("idleStateHandler", (ChannelHandler)idleStateHandler);
        } else {
            pipeline.addBefore("targetHandler", "idleStateHandler", idleStateHandler);
        }
        this.http2ClientChannel.setSocketIdleTimeout(socketIdleTimeout);
    }

    public void setCorrelationIdForLogging() {
        ChannelPipeline pipeline = this.getChannel().pipeline();
        ChannelInboundHandlerAdapter srcHandler = this.getCorrelatedSource();
        if (srcHandler != null && pipeline.get("http-trace-logger") != null) {
            HttpTraceLoggingHandler loggingHandler = (HttpTraceLoggingHandler)pipeline.get("http-trace-logger");
            if (srcHandler instanceof SourceHandler) {
                SourceHandler h1SourceHandler = (SourceHandler)srcHandler;
                loggingHandler.setCorrelatedSourceId(h1SourceHandler.getInboundChannelContext().channel().id().asShortText());
            } else if (srcHandler instanceof Http2SourceHandler) {
                Http2SourceHandler h2SourceHandler = (Http2SourceHandler)srcHandler;
                loggingHandler.setCorrelatedSourceId(h2SourceHandler.getInboundChannelContext().channel().id().asShortText());
            }
        }
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public ChannelFuture getChannelFuture() {
        return this.channelFuture;
    }

    public Http2ClientChannel getHttp2ClientChannel() {
        return this.http2ClientChannel;
    }

    public void writeContent(HttpCarbonMessage httpOutboundRequest) {
        BackPressureHandler backpressureHandler = Util.getBackPressureHandler(this.targetHandler.getContext());
        Util.setBackPressureListener(httpOutboundRequest.isPassthrough(), backpressureHandler, httpOutboundRequest.getSourceContext());
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtTargetRequestReceiving(httpOutboundRequest);
        }
        this.resetTargetChannelState();
        MessageStateContext messageStateContext = httpOutboundRequest.getMessageStateContext();
        if (messageStateContext == null) {
            messageStateContext = new MessageStateContext();
            httpOutboundRequest.setMessageStateContext(messageStateContext);
        }
        httpOutboundRequest.getMessageStateContext().setSenderState(new SendingHeaders(messageStateContext, this, this.httpVersion, this.chunkConfig, this.httpInboundResponseFuture));
        httpOutboundRequest.getHttpContentAsync().setMessageListener(httpContent -> {
            Util.checkUnWritabilityAndNotify(this.targetHandler.getContext(), backpressureHandler);
            this.channel.eventLoop().execute(() -> {
                try {
                    this.writeOutboundRequest(httpOutboundRequest, httpContent);
                }
                catch (Exception exception) {
                    String errorMsg = "Failed to send the request : " + exception.getMessage().toLowerCase(Locale.ENGLISH);
                    LOG.error(errorMsg, exception);
                    this.targetHandler.getHttpResponseFuture().notifyHttpListener(exception);
                }
            });
        });
    }

    private void writeOutboundRequest(HttpCarbonMessage httpOutboundRequest, HttpContent httpContent) throws Exception {
        httpOutboundRequest.getMessageStateContext().getSenderState().writeOutboundRequestEntity(httpOutboundRequest, httpContent);
    }

    private void resetTargetChannelState() {
        this.setRequestHeaderWritten(false);
    }

    public void setForwardedExtension(ForwardedExtensionConfig forwardedConfig, HttpCarbonMessage httpOutboundRequest) {
        if (forwardedConfig == ForwardedExtensionConfig.DISABLE) {
            return;
        }
        String localAddress = ((InetSocketAddress)this.getChannel().localAddress()).getAddress().getHostAddress();
        ForwardedHeaderUpdater headerUpdater = new ForwardedHeaderUpdater(httpOutboundRequest, localAddress);
        if (headerUpdater.isForwardedHeaderRequired()) {
            headerUpdater.setForwardedHeader();
            return;
        }
        if (headerUpdater.isXForwardedHeaderRequired()) {
            if (forwardedConfig == ForwardedExtensionConfig.ENABLE) {
                headerUpdater.setDefactoForwardedHeaders();
                return;
            }
            headerUpdater.transformAndSetForwardedHeader();
            return;
        }
        LOG.warn("Both Forwarded and X-Forwarded-- headers are present. Hence updating only the forwarded header");
        headerUpdater.setForwardedHeader();
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }
}

